/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

public abstract class Selection
implements KeyListener,
MouseListener,
MouseMotionListener,
Serializable {
    public static final int HAND_SIZE = 6;
    public static final int BORDER_WIDTH = 4;
    private Fig content;

    public Selection(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("Cannot place a null Fig inside a Selection");
        }
        if (!fig.isSelectable()) {
            throw new IllegalArgumentException("The given Fig cannot be selected");
        }
        this.content = fig;
    }

    public Fig getContent() {
        return this.content;
    }

    public void setContent(Fig fig) {
        this.content = fig;
    }

    public boolean getLocked() {
        return this.getContent().getLocked();
    }

    public boolean contains(Fig fig) {
        return fig == this.content;
    }

    public void print(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
    }

    public void endTrans() {
        this.getContent().endTrans();
    }

    public Point getLocation() {
        return this.content.getLocation();
    }

    public void damage() {
        this.content.damage();
    }

    public final boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n2, int n3) {
        if (this.content.contains(n2, n3)) {
            return true;
        }
        Handle handle = new Handle(-1);
        this.hitHandle(n2, n3, 0, 0, handle);
        return handle.index != -1;
    }

    public boolean hit(Rectangle rectangle) {
        if (this.content.hit(rectangle)) {
            return true;
        }
        Handle handle = new Handle(-1);
        this.hitHandle(rectangle, handle);
        return handle.index != -1;
    }

    public abstract void hitHandle(Rectangle var1, Handle var2);

    public final void hitHandle(int n2, int n3, int n4, int n5, Handle handle) {
        this.hitHandle(new Rectangle(n2, n3, n4, n5), handle);
    }

    public void reorder(int n2, Layer layer) {
        layer.reorder(this.content, n2);
    }

    public void translate(int n2, int n3) {
        this.content.translate(n2, n3);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.content.getX() - 3, this.content.getY() - 3, this.content.getWidth() + 6, this.content.getHeight() + 6);
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return this.getBounds();
        }
        rectangle.setBounds(this.content.getX() - 3, this.content.getY() - 3, this.content.getWidth() + 6, this.content.getHeight() + 6);
        return rectangle;
    }

    public void delete() {
        this.content.removeFromDiagram();
    }

    public void dispose() {
        this.content.deleteFromModel();
    }

    public abstract void dragHandle(int var1, int var2, int var3, int var4, Handle var5);

    public Rectangle getContentBounds() {
        return this.content.getBounds();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.content instanceof KeyListener) {
            ((KeyListener)((Object)this.content)).keyTyped(keyEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.content instanceof KeyListener) {
            ((KeyListener)((Object)this.content)).keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.content instanceof KeyListener) {
            ((KeyListener)((Object)this.content)).keyReleased(keyEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.content)).mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.content)).mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseReleased(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseExited(mouseEvent);
        }
    }
}

