/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.util.Localizer;

public class ZoomAction
extends AbstractAction {
    private static final long serialVersionUID = -952853421722122499L;
    private double _magnitude;

    public ZoomAction() {
        this(0.0);
    }

    public ZoomAction(double d2) {
        super(ZoomAction.wordFor(d2));
        this._magnitude = d2;
    }

    protected static String wordFor(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Zoom magnitude cannot be less than 0");
        }
        if (d2 == 0.0) {
            return Localizer.localize("GefBase", "ZoomReset");
        }
        if (d2 > 1.0) {
            return Localizer.localize("GefBase", "ZoomIn");
        }
        if (d2 < 1.0) {
            return Localizer.localize("GefBase", "ZoomOut");
        }
        return Localizer.localize("GefBase", "DoNothing");
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        serializable = Globals.curEditor();
        if (serializable == null) {
            return;
        }
        if (this._magnitude > 0.0) {
            ((Editor)serializable).setScale(((Editor)serializable).getScale() * this._magnitude);
        } else {
            ((Editor)serializable).setScale(1.0);
        }
        ((Editor)serializable).damageAll();
    }
}

