/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;

public abstract class Decoration
implements Serializable {
    private int arrowWidth = 7;
    private int arrowHeight = 12;
    private Color arrowLineColor = Color.black;
    private Color arrowFillColor = Color.black;

    public Decoration() {
    }

    public Decoration(Color color, Color color2) {
        this.setLineColor(color);
        this.setFillColor(color2);
    }

    public Color getLineColor() {
        return this.arrowLineColor;
    }

    public void setLineColor(Color color) {
        this.arrowLineColor = color;
    }

    public Color getFillColor() {
        return this.arrowFillColor;
    }

    public void setFillColor(Color color) {
        this.arrowFillColor = color;
    }

    public abstract void paint(Graphics var1, Point var2, Point var3, Color var4, Color var5);

    public int getLineLength(Point point, Point point2) {
        int n2 = (point2.x - point.x) * (point2.x - point.x);
        int n3 = (point2.y - point.y) * (point2.y - point.y);
        return (int)Math.sqrt(n2 + n3);
    }

    public Point pointAlongLine(Point point, Point point2, int n2) {
        int n3 = this.getLineLength(point, point2);
        if (n3 == 0) {
            return point;
        }
        return new Point(point.x + (point2.x - point.x) * n2 / n3, point.y + (point2.y - point.y) * n2 / n3);
    }

    public double dist(int n2, int n3, int n4, int n5) {
        double d2 = n2 - n4;
        double d3 = n3 - n5;
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public double dist(double d2, double d3) {
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public int getWidth() {
        return this.arrowWidth;
    }

    public int getHeight() {
        return this.arrowHeight;
    }

    public void setWidth(int n2) {
        this.arrowWidth = n2;
    }

    public void setHeight(int n2) {
        this.arrowHeight = n2;
    }
}

