/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RectangleEditor
extends JPanel
implements PropertyEditor {
    protected Rectangle _rect = null;
    private Vector listeners;
    protected JTextField xField;
    protected JTextField yField;
    protected JTextField wField;
    protected JTextField hField;

    public RectangleEditor() {
        this.setLayout(new GridLayout(1, 4));
        this.setSize(this.getInsets().left + this.getInsets().right + 20, this.getInsets().top + this.getInsets().bottom + 20);
        this.xField = new JTextField("0", 4);
        this.yField = new JTextField("0", 4);
        this.hField = new JTextField("0", 4);
        this.wField = new JTextField("0", 4);
        this.add(this.xField);
        this.add(this.yField);
        this.add(this.hField);
        this.add(this.wField);
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof Rectangle)) {
            return;
        }
        this._rect = (Rectangle)object;
        this.updateWidgets();
    }

    @Override
    public Object getValue() {
        return this._rect;
    }

    @Override
    public String getJavaInitializationString() {
        return "new Rectangle(" + this.getAsText() + ")";
    }

    @Override
    public String getAsText() {
        Rectangle rectangle = (Rectangle)this.getValue();
        return rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height;
    }

    @Override
    public void setAsText(String string) {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Object object = (Rectangle)this.getValue();
        object = "(" + ((Rectangle)object).x + "," + ((Rectangle)object).y + ")+(" + ((Rectangle)object).width + "x" + ((Rectangle)object).height + " )";
        graphics.drawString((String)object, rectangle.x + 2, rectangle.x + rectangle.height - 4);
    }

    public void setEnable(boolean bl2) {
        this.xField.setEditable(bl2);
        this.yField.setEditable(bl2);
        this.wField.setEditable(bl2);
        this.hField.setEditable(bl2);
    }

    public void updateWidgets() {
        this.xField.setText(Integer.toString(this._rect.x));
        this.yField.setText(Integer.toString(this._rect.y));
        this.wField.setText(Integer.toString(this._rect.width));
        this.hField.setText(Integer.toString(this._rect.height));
    }

    protected void readFields() {
        try {
            int n2 = Integer.parseInt(this.xField.getText());
            int n3 = Integer.parseInt(this.yField.getText());
            int n4 = Integer.parseInt(this.wField.getText());
            int n5 = Integer.parseInt(this.hField.getText());
            this.setValue(new Rectangle(n2, n3, n4, n5));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.updateWidgets();
            return;
        }
    }

    @Override
    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getSource() != this && (long)aWTEvent.getID() == 128L) {
            this.readFields();
            return;
        }
        super.processEvent(aWTEvent);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new PropertyChangeEvent(this, null, null, null);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ((PropertyChangeListener)vector.elementAt(i2)).propertyChange((PropertyChangeEvent)serializable);
        }
    }
}

