/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdPrint
extends Cmd
implements Printable {
    private static final long serialVersionUID = 5930094057682454011L;
    PrinterJob printerJob;
    PageFormat pageFormat;
    int maxPageIndex = 1;
    boolean fitDiagramToPage = true;
    boolean isFirstPrintCall = true;
    double scale;
    int nCol;
    double pageX;
    double pageY;
    double pageWidth;
    double pageHeight;
    double diagramX;
    double diagramY;
    double diagramWidth;
    double diagramHeight;

    public CmdPrint() {
        super("Print");
    }

    public CmdPrint(String diagramName) {
        this();
        this.setDiagramName(diagramName);
    }

    public void setDiagramName(String name) {
        this.setArg("diagramName", name);
    }

    public void setPrintPageNumbers(boolean b) {
        this.setArg("printPageNumbers", b ? Boolean.TRUE : Boolean.FALSE);
    }

    public void doIt() {
        PrinterJob printerJob = this.getPrinterJob();
        printerJob.setPrintable(new CmdPrint(), this.getPageFormat());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException pe) {
                Globals.showStatus("Error got a Printer exception");
            }
        }
        Globals.showStatus("Printing finished");
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdPrint");
    }

    private boolean isFirstPrintCall() {
        return this.isFirstPrintCall;
    }

    private void setFirstPrintCall(boolean b) {
        this.isFirstPrintCall = b;
    }

    private boolean fitDiagramToPage() {
        return this.fitDiagramToPage;
    }

    private void setFitDiagramToPage(boolean b) {
        this.fitDiagramToPage = b;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.maxPageIndex) {
            return 1;
        }
        Editor editor = Globals.curEditor();
        Graphics2D g2d = (Graphics2D)graphics;
        Rectangle drawingArea = null;
        SelectionManager sm = editor.getSelectionManager();
        Vector selectedFigs = sm.getFigs();
        Enumeration iter = null;
        if (selectedFigs.size() > 0) {
            iter = selectedFigs.elements();
        } else {
            iter = editor.figs();
            drawingArea = new Rectangle();
        }
        while (iter.hasMoreElements()) {
            Fig fig = (Fig)iter.nextElement();
            Rectangle rect = fig.getBounds();
            if (drawingArea == null) {
                drawingArea = new Rectangle(rect);
            }
            drawingArea.add(rect);
        }
        if (drawingArea == null || drawingArea.width == 0 || drawingArea.height == 0) {
            return 1;
        }
        boolean h = editor.getGridHidden();
        editor.setGridHidden(true);
        if (this.isFirstPrintCall()) {
            this.setFirstPrintCall(false);
            this.pageWidth = pageFormat.getImageableWidth();
            this.pageHeight = pageFormat.getImageableHeight();
            this.pageX = pageFormat.getImageableX();
            this.pageY = pageFormat.getImageableY();
            this.diagramWidth = drawingArea.width;
            this.diagramHeight = drawingArea.height;
            this.diagramX = drawingArea.x;
            this.diagramY = drawingArea.y;
            this.scale = Math.min(this.pageWidth / (double)(drawingArea.width + 1), this.pageHeight / (double)(drawingArea.height + 1));
            if (this.scale < 1.0 && !this.promptFitToPage()) {
                editor.setGridHidden(h);
                return 1;
            }
            if (this.fitDiagramToPage()) {
                this.maxPageIndex = 1;
            } else {
                this.nCol = Math.max((int)Math.ceil(this.diagramWidth / this.pageWidth), 1);
                int nRow = Math.max((int)Math.ceil(this.diagramHeight / this.pageHeight), 1);
                this.maxPageIndex = this.nCol * nRow;
            }
        }
        if (this.fitDiagramToPage()) {
            if (this.scale < 1.0) {
                g2d.scale(this.scale, this.scale);
                g2d.translate(this.pageX / this.scale - this.diagramX + 1.0, this.pageY / this.scale - this.diagramY + 1.0);
            } else {
                g2d.translate(this.pageX - this.diagramX + 1.0, this.pageY - this.diagramY + 1.0);
            }
        } else {
            double iCol = pageIndex % this.nCol;
            double iRow = pageIndex / this.nCol;
            double x = iCol * this.pageWidth;
            double y = iRow * this.pageHeight;
            g2d.translate(this.pageX - x + 1.0, this.pageY - y + 1.0);
        }
        g2d.setClip(drawingArea);
        editor.print(g2d);
        editor.setGridHidden(h);
        return 0;
    }

    PrinterJob getPrinterJob() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
        }
        return this.printerJob;
    }

    PageFormat getPageFormat() {
        PrinterJob pj;
        if (this.pageFormat == null && (pj = this.getPrinterJob()) != null) {
            this.pageFormat = pj.defaultPage();
        }
        return this.pageFormat;
    }

    void setPageFormat(PageFormat pf) {
        this.pageFormat = pf;
    }

    public void doPageSetup() {
        this.setPageFormat(this.getPrinterJob().pageDialog(this.getPageFormat()));
    }

    private boolean promptFitToPage() {
        Object[] options = new Object[]{"Fit to page", "Multiple Pages", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "The diagram exceeds the current page size. Select option?", "Print", 1, 3, null, options, options[0]);
        if (n == 2) {
            return false;
        }
        if (n == 1) {
            this.setFitDiagramToPage(false);
        } else {
            this.setFitDiagramToPage(true);
        }
        return true;
    }
}

