/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPrimitive;

public class NetPort
extends NetPrimitive
implements GraphPortHooks,
Serializable {
    private static final long serialVersionUID = -3506978147166333303L;
    public static String DEFAULT_EDGE_CLASS = "org.tigris.gef.graph.presentation.NetEdge";
    private Vector edges;
    private Object _parent;
    private static Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$graph$presentation$NetPort == null ? (class$org$tigris$gef$graph$presentation$NetPort = NetPort.class$("org.tigris.gef.graph.presentation.NetPort")) : class$org$tigris$gef$graph$presentation$NetPort));
    static /* synthetic */ Class class$org$tigris$gef$graph$presentation$NetPort;

    public NetPort(Object parent) {
        this._parent = parent;
        this.edges = new Vector();
    }

    public String getId() {
        return this.toString();
    }

    public NetNode getParentNode() {
        return (NetNode)this._parent;
    }

    public NetEdge getParentEdge() {
        return (NetEdge)this._parent;
    }

    public Object getParent() {
        return this._parent;
    }

    public Vector getEdges() {
        return this.edges;
    }

    public void addEdge(NetEdge edge) {
        this.edges.addElement(edge);
    }

    public void removeEdge(NetEdge edge) {
        this.edges.removeElement(edge);
    }

    public void deleteFromModel() {
        LOG.debug((Object)"Deleting from model");
        int size = this.edges.size();
        for (int i = 0; i < size; ++i) {
            NetEdge edge = (NetEdge)this.edges.get(0);
            edge.deleteFromModel();
        }
        this.firePropertyChange("disposed", false, true);
    }

    public void postConnect(GraphModel gm, Object otherPort) {
        NetPort otherNetPort = (NetPort)otherPort;
        NetNode parent = this.getParentNode();
        parent.postConnect(gm, otherNetPort.getParentNode(), this, otherNetPort);
    }

    public void postDisconnect(GraphModel gm, Object otherPort) {
        NetPort otherNetPort = (NetPort)otherPort;
        NetNode parent = this.getParentNode();
        parent.postDisconnect(gm, otherNetPort.getParentNode(), this, otherNetPort);
    }

    protected Class defaultEdgeClass(NetPort otherPort) {
        try {
            return Class.forName(DEFAULT_EDGE_CLASS);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    public NetEdge makeEdgeFor(NetPort otherPort) {
        NetEdge edge;
        Class edgeClass = this.defaultEdgeClass(otherPort);
        if (edgeClass == null) {
            LOG.error((Object)"defaultEdgeClass is null");
            return null;
        }
        try {
            edge = (NetEdge)edgeClass.newInstance();
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Failed to create edge ", (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            LOG.error((Object)"Failed to create edge ", (Throwable)e);
            return null;
        }
        LOG.debug((Object)("Made edge " + edge.getClass().getName()));
        return edge;
    }

    public boolean canConnectTo(GraphModel gm, Object anotherPort) {
        NetNode myNode = this.getParentNode();
        NetNode otherNode = ((NetPort)anotherPort).getParentNode();
        return myNode.canConnectTo(gm, otherNode, anotherPort, this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

