/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Point;
import org.tigris.gef.presentation.Fig;

public class FigCircle
extends Fig {
    private static final long serialVersionUID = 7376986113799307733L;
    public static final double CIRCLE_ADJUST_RADIUS = 0.1;
    protected boolean _isDashed = false;

    public FigCircle(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public FigCircle(int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
    }

    public FigCircle(int x, int y, int w, int h, boolean resizable) {
        super(x, y, w, h);
        this.resizable = resizable;
    }

    public FigCircle(int x, int y, int w, int h, boolean resizable, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
        this.resizable = resizable;
    }

    public void paint(Object g) {
        plotter.drawOval(g, this._filled, this._fillColor, this._lineColor, this._lineWidth, this.getDashed(), this._x, this._y, this._w, this._h);
    }

    public void appendSvg(StringBuffer sb) {
        sb.append("<ellipse id='").append(this.getId()).append("'");
        this.appendSvgStyle(sb);
        sb.append("cx='").append(this.getCenter().x).append("'").append("cy='").append(this.getCenter().y).append("'").append("rx='").append(this.getWidth() / 2).append("'").append("ry='").append(this.getHeight() / 2).append("' />");
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        double dx = (double)(this._x + this._w / 2 - x) * 2.0 / (double)this._w;
        double dy = (double)(this._y + this._h / 2 - y) * 2.0 / (double)this._h;
        double distSquared = dx * dx + dy * dy;
        return distSquared <= 1.01;
    }

    public Point connectionPoint(Point anotherPt) {
        double rx = this._w / 2;
        double ry = this._h / 2;
        double dx = anotherPt.x - this._x;
        double dy = anotherPt.y - this._y;
        double dd = ry * ry * dx * dx + rx * rx * dy * dy;
        double mu = rx * ry / Math.sqrt(dd);
        Point res = new Point((int)(mu * dx + (double)this._x + rx), (int)(mu * dy + (double)this._y + ry));
        return res;
    }
}

