/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.vp_pda.v4;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import ro.atreides.pda_utils.PdaInputDialog;
import ro.atreides.vp_pda.v4.Config3;
import ro.atreides.vp_pda.v4.Location3;
import ro.atreides.vp_pda.v4.LocationsPanel;
import ro.atreides.vp_pda.v4.OrderPanel;
import ro.atreides.vp_pda.v4.PdaLogic3;
import ro.atreides.vp_pda.v4.PreorderPanel;
import ro.atreides.vp_pda.v4.Table3;

public class TablesPanel {
    private Shell parentShell;
    private PdaLogic3 logic;

    public TablesPanel(final Shell parentShell, PdaLogic3 logic1) {
        this.parentShell = parentShell;
        this.logic = logic1;
        int close = Config3.closeMode ? 80 : 0;
        final Shell tablesShell = new Shell(parentShell, close);
        Location3 locatie = this.logic.getLocatie();
        Iterator loc = this.logic.getTablesForLocatie(locatie.getId()).iterator();
        Label locatieLabel = new Label((Composite)tablesShell, 0x1000800);
        locatieLabel.setText(locatie.getLabel());
        Button meseButton = new Button((Composite)tablesShell, 8);
        meseButton.setText("PLAN");
        meseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                new LocationsPanel(parentShell, TablesPanel.this.logic);
                tablesShell.close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button refreshButton = new Button((Composite)tablesShell, 8);
        refreshButton.setText("REFRESH");
        refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                TablesPanel.this.logic.sendRefreshRequest();
                new LocationsPanel(parentShell, TablesPanel.this.logic);
                tablesShell.close();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        final Table table = new Table((Composite)tablesShell, 2560);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        int columnCount = 2;
        for (int i = 0; i < 2; ++i) {
            TableColumn column = new TableColumn(table, 0);
            column.setText("12345678901234");
        }
        final Hashtable<String, Table3> positions = new Hashtable<String, Table3>();
        int i = 0;
        while (loc.hasNext()) {
            TableItem item = new TableItem(table, 0);
            Font initialFont = item.getFont();
            FontData[] fontData = initialFont.getFontData();
            for (int k = 0; k < fontData.length; ++k) {
                fontData[k].setHeight(Config3.meseFontSize);
            }
            Font newFont = new Font((Device)parentShell.getDisplay(), fontData);
            item.setFont(newFont);
            for (int j = 0; j < 2 && loc.hasNext(); ++j) {
                Table3 loco = (Table3)loc.next();
                int status = loco.getStatus();
                String text = loco.getLabel();
                if (loco.getStatus() > 0) {
                    text = text + " " + loco.getUserName();
                }
                item.setText(j, text);
                if (status == 1) {
                    item.setBackground(j, parentShell.getDisplay().getSystemColor(7));
                }
                if (status == 5) {
                    item.setBackground(j, parentShell.getDisplay().getSystemColor(3));
                }
                positions.put(i + "_" + j, loco);
            }
            if (!loc.hasNext()) break;
            ++i;
        }
        for (i = 0; i < 2; ++i) {
            table.getColumn(i).pack();
        }
        table.pack();
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = table.getClientArea();
                Point pt = new Point(event.x, event.y);
                boolean stop = false;
                for (int index = table.getTopIndex(); !stop && index < table.getItemCount(); ++index) {
                    boolean visible = false;
                    TableItem item = table.getItem(index);
                    for (int i = 0; i < 2; ++i) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            Table3 loco = (Table3)positions.get(index + "_" + i);
                            if (TablesPanel.this.logic.getIdWaiter() == -1) {
                                TablesPanel.this.showLoginDialog(parentShell, loco);
                            } else {
                                TablesPanel.this.afterTableSelection(loco);
                            }
                            tablesShell.close();
                            stop = true;
                            break;
                        }
                        if (visible || !rect.intersects(clientArea)) continue;
                        visible = true;
                    }
                    if (visible) continue;
                    return;
                }
            }
        });
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        event.height = Config3.meseRowSize;
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        locatieLabel.setBounds(0, 0, 70, 20);
        meseButton.setBounds(75, 0, 60, 20);
        refreshButton.setBounds(135, 0, 70, 20);
        table.setBounds(0, 21, 240, 280);
        tablesShell.setSize(240, Config3.dY);
        tablesShell.open();
    }

    private void afterTableSelection(Table3 table) {
        if (this.logic.canUserTable(this.logic.getIdWaiter(), table.getId())) {
            if (this.logic.isTableEmpty(table.getId())) {
                new PreorderPanel(this.parentShell, this.logic, table);
            } else {
                new OrderPanel(this.parentShell, this.logic, table);
            }
        } else {
            new TablesPanel(this.parentShell, this.logic);
        }
    }

    private void showLoginDialog(final Shell parentShell, final Table3 requestedTable) {
        Shell loginShell = new Shell(parentShell, 64);
        String[] fields = new String[]{"Utilizator", "Parola"};
        String[] defaults = new String[]{"", ""};
        final PdaInputDialog dialog = new PdaInputDialog(loginShell, fields, defaults, "Autentificare");
        DisposeListener lis = new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (dialog.isSet()) {
                    String[] results = dialog.getResults();
                    String user = results[0];
                    String parola = results[1];
                    boolean ok = TablesPanel.this.logic.tryLogin(user, parola);
                    if (ok) {
                        TablesPanel.this.afterTableSelection(requestedTable);
                    } else {
                        new TablesPanel(parentShell, TablesPanel.this.logic);
                    }
                } else {
                    new TablesPanel(parentShell, TablesPanel.this.logic);
                }
            }
        };
        dialog.setDisposeListener(lis);
    }
}

