/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class SkinRadioButtonUI
extends BasicRadioButtonUI {
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    protected Skin skin = SkinLookAndFeel.getSkin();
    private boolean initialized = false;
    static final SkinRadioButtonUI buttonUI = new SkinRadioButtonUI();
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.initialized) {
            this.focusColor = Color.black;
            this.initialized = true;
        }
        b.setOpaque(false);
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        size = b.getSize(size);
        SkinRadioButtonUI.viewRect.y = 0;
        SkinRadioButtonUI.viewRect.x = 0;
        SkinRadioButtonUI.viewRect.width = SkinRadioButtonUI.size.width;
        SkinRadioButtonUI.viewRect.height = SkinRadioButtonUI.size.height;
        SkinRadioButtonUI.iconRect.height = 0;
        SkinRadioButtonUI.iconRect.width = 0;
        SkinRadioButtonUI.iconRect.y = 0;
        SkinRadioButtonUI.iconRect.x = 0;
        SkinRadioButtonUI.textRect.height = 0;
        SkinRadioButtonUI.textRect.width = 0;
        SkinRadioButtonUI.textRect.y = 0;
        SkinRadioButtonUI.textRect.x = 0;
        Icon icon = b.isSelected() ? b.getSelectedIcon() : b.getIcon();
        if (b.isRolloverEnabled() && model.isRollover()) {
            icon = b.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
        }
        if (icon == null) {
            icon = this.skin.getButton().getRadioIcon(b);
        }
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getDefaultTextIconGap(b));
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, SkinRadioButtonUI.size.width, SkinRadioButtonUI.size.height);
        }
        if (icon != null) {
            icon.paintIcon(c, g, SkinRadioButtonUI.iconRect.x, SkinRadioButtonUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else if (model.isEnabled()) {
                g.setColor(b.getForeground());
                BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), SkinRadioButtonUI.textRect.x, SkinRadioButtonUI.textRect.y + fm.getAscent());
            } else {
                g.setColor(b.getBackground().brighter());
                BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), SkinRadioButtonUI.textRect.x + 1, SkinRadioButtonUI.textRect.y + fm.getAscent() + 1);
                g.setColor(b.getBackground().darker());
                BasicGraphicsUtils.drawString(g, text, model.getMnemonic(), SkinRadioButtonUI.textRect.x, SkinRadioButtonUI.textRect.y + fm.getAscent());
            }
        }
        if (b.hasFocus() && b.isFocusPainted() && SkinRadioButtonUI.textRect.width > 0 && SkinRadioButtonUI.textRect.height > 0) {
            this.paintFocus(g, textRect, size);
        }
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension d) {
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, textRect.x, textRect.y, textRect.width, textRect.height);
    }

    public static ComponentUI createUI(JComponent c) {
        SkinRadioButtonUI.buttonUI.skin = SkinLookAndFeel.getSkin();
        SkinRadioButtonUI.buttonUI.initialized = false;
        return buttonUI;
    }
}

