/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinPersonality;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkImage;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkListCellRenderer;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkStyle;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkTableHeaderRenderer;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import com.l2fprod.util.ImageUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

final class GtkPersonality
extends AbstractSkinPersonality {
    Image background;
    int backgroundPaintMode;
    DefaultButton menu;
    Border menuBarBorder;
    Border toolBarBorder;
    DefaultButton menuitemSelected;
    DefaultButton menuBackground;
    DefaultButton itemSelected;
    DefaultButton itemUnselected;
    DefaultButton comboBox;
    DefaultButton rolloverComboBox;
    DefaultButton disabledComboBox;
    DefaultButton focus;
    Insets comboBoxInsets = new Insets(1, 4, 1, 4);
    static int MINIMAL_SIZE = 50;

    public GtkPersonality(GtkParser parser) throws Exception {
        if (parser.getClass("GtkWindow") != null) {
            GtkStyle windowStyle = parser.getClass("GtkWindow").getStyle();
            GtkImage image = windowStyle.getEngine().findImage(new String[]{"function"}, new String[]{"FLAT_BOX"});
            this.backgroundPaintMode = "TRUE".equals(image.getProperty("stretch")) ? 1 : 2;
            this.background = image.getImage(parser.getDirectory());
            if (this.background != null && this.backgroundPaintMode == 2) {
                int width = this.background.getWidth(ImageUtils.producer);
                int height = this.background.getHeight(ImageUtils.producer);
                int factor = Math.max(MINIMAL_SIZE / height, MINIMAL_SIZE / width);
                if (factor > 1) {
                    this.background = ImageUtils.buildTile(this.background, factor);
                }
            }
            this.background = ImageUtils.toBufferedImage(this.background);
        }
        this.menuBackground = GtkUtils.newButton(parser, "GtkMenu", new String[]{"function"}, new String[]{"BOX"});
        this.toolBarBorder = GtkUtils.newButton(parser, "GtkToolbar", new String[]{"function"}, new String[]{"BOX"}, false, true, false);
        if (this.toolBarBorder != null) {
            this.toolBarBorder = new BorderUIResource(this.toolBarBorder);
        }
        this.menuBarBorder = GtkUtils.newButton(parser, "GtkMenuBar", new String[]{"function"}, new String[]{"BOX"}, false, true, false);
        if (this.menuBarBorder != null) {
            this.menuBarBorder = new BorderUIResource(this.menuBarBorder);
        }
        this.menuitemSelected = GtkUtils.newButton(parser, "GtkMenuItem", new String[]{"function"}, new String[]{"BOX"});
        this.itemUnselected = GtkUtils.newButton(parser, "GtkListItem", new String[]{"function", "state"}, new String[]{"FLAT_BOX", "INSENSITIVE"});
        this.itemSelected = GtkUtils.newButton(parser, "GtkListItem", new String[]{"function", "state"}, new String[]{"FLAT_BOX", null});
        this.comboBox = GtkUtils.newButton(parser, "GtkOptionMenu", new String[]{"function", "state"}, new String[]{"BOX", null}, false, true, false);
        if (this.comboBox == null) {
            this.comboBox = GtkUtils.newButton(parser, "GtkOptionMenu", new String[]{"function"}, new String[]{"TAB"}, false, true, true);
        }
        this.rolloverComboBox = GtkUtils.newButton(parser, "GtkOptionMenu", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"}, false, true, false);
        this.disabledComboBox = GtkUtils.newButton(parser, "GtkOptionMenu", new String[]{"function", "state"}, new String[]{"BOX", "INSENSITIVE"}, false, true, false);
        this.focus = GtkUtils.newButton(parser, "default", new String[]{"function"}, new String[]{"FOCUS"}, true);
        if (this.focus != null) {
            this.focus.setCenterFill(5);
        }
    }

    public Insets getComboBoxInsets() {
        if (this.comboBox != null) {
            return this.comboBox.getInsets();
        }
        return this.comboBoxInsets;
    }

    public Dimension getComboBoxPreferredSize(JComboBox c) {
        if (this.comboBox != null) {
            return this.comboBox.getMinimumSize();
        }
        return null;
    }

    public TableCellRenderer getTableHeaderRenderer() {
        if (this.itemSelected != null && this.itemUnselected != null) {
            return new GtkTableHeaderRenderer(this.itemSelected, this.itemUnselected);
        }
        return new DefaultTableCellRenderer();
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        if (c instanceof JMenuBar && this.menuBarBorder != null) {
            c.setBorder(this.menuBarBorder);
        }
        if (c instanceof JToolBar && this.toolBarBorder != null) {
            c.setBorder(this.toolBarBorder);
        }
        return true;
    }

    public void uninstallSkin(JComponent c) {
    }

    public boolean paintDialog(Graphics g, Component c) {
        if (c instanceof JPopupMenu && this.menuBackground != null) {
            this.menuBackground.paint(g, c);
        } else {
            JComponent component = (JComponent)c;
            if (this.background != null) {
                Rectangle rect = component.getVisibleRect();
                ImageUtils.paint(component, g, this.background, rect.x, rect.y, rect.width, rect.height, true, this.backgroundPaintMode);
            }
        }
        return true;
    }

    public boolean paintFocus(Graphics g, JComponent c) {
        return false;
    }

    public boolean paintMenu(Graphics g, JMenu c) {
        return false;
    }

    public boolean paintMenuItem(Graphics g, JMenuItem c) {
        if (this.menuitemSelected != null) {
            if (c.isArmed() || c instanceof JMenu && c.getModel().isSelected()) {
                this.menuitemSelected.paint(g, c);
            }
            return true;
        }
        return false;
    }

    public boolean paintComboBox(Graphics g, JComboBox c, Rectangle bounds, boolean hasFocus, boolean isRollover) {
        if (!c.isEnabled() && this.disabledComboBox != null) {
            this.disabledComboBox.paint(g, c);
            return true;
        }
        if (isRollover && this.rolloverComboBox != null) {
            this.rolloverComboBox.paint(g, c);
            return true;
        }
        if (this.comboBox != null) {
            this.comboBox.paint(g, c);
            return true;
        }
        return false;
    }

    public TableCellRenderer createTableHeaderRenderer() {
        return this.getTableHeaderRenderer();
    }

    public ListCellRenderer createListCellRenderer() {
        if (this.itemSelected != null && this.itemUnselected != null) {
            return new GtkListCellRenderer(this.itemSelected, this.itemUnselected);
        }
        return new DefaultListCellRenderer();
    }
}

