/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain.address;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.deversoft.odf.gearbox.common.domain.address.AddressFieldTypeEnum;
import ro.deversoft.odf.gearbox.common.domain.address.StructuredAddressComponent;

public class StructuredAddress {
    List<StructuredAddressComponent> addressComponents;

    public String getValueForField(AddressFieldTypeEnum addressFieldTypeEnum) {
        for (StructuredAddressComponent component : this.addressComponents) {
            if (component.getFieldType() != addressFieldTypeEnum) continue;
            return component.getValue();
        }
        return null;
    }

    public void mergeWithFallback(StructuredAddress fallback) {
        if (fallback == null) {
            return;
        }
        ArrayList<StructuredAddressComponent> resultList = new ArrayList<StructuredAddressComponent>();
        for (AddressFieldTypeEnum fieldTypeEnum : AddressFieldTypeEnum.values()) {
            if (this.getValueForField(fieldTypeEnum) == null) {
                if (fallback.getValueForField(fieldTypeEnum) == null) continue;
                resultList.add(StructuredAddressComponent.builder().setFieldType(fieldTypeEnum).setValue(fallback.getValueForField(fieldTypeEnum)).build());
                continue;
            }
            resultList.add(StructuredAddressComponent.builder().setFieldType(fieldTypeEnum).setValue(this.getValueForField(fieldTypeEnum)).build());
        }
        this.setAddressComponents(resultList);
    }

    public static StructuredAddress fromMap(Map<AddressFieldTypeEnum, String> map) {
        StructuredAddress structuredAddress = new StructuredAddress();
        for (AddressFieldTypeEnum fieldTypeEnum : map.keySet()) {
            String value = map.get((Object)fieldTypeEnum);
            if (value == null) continue;
            structuredAddress.getAddressComponents().add(StructuredAddressComponent.builder().setFieldType(fieldTypeEnum).setValue(value).build());
        }
        return structuredAddress;
    }

    public Map<AddressFieldTypeEnum, String> toMap() {
        Map<AddressFieldTypeEnum, String> result = Collections.synchronizedMap(new LinkedHashMap());
        if (this.addressComponents != null) {
            this.addressComponents.stream().forEach(k -> {
                AddressFieldTypeEnum fieldType = k.getFieldType();
                String value = k.getValue();
                result.put(fieldType, value);
            });
        }
        return result;
    }

    public static Map<String, String> flattenListOfBankIbans(List<StructuredAddress> list) {
        Map<String, String> result = Collections.synchronizedMap(new LinkedHashMap());
        for (StructuredAddress structuredAddress : list) {
            String iban = structuredAddress.getValueForField(AddressFieldTypeEnum.COMPANY_IBAN);
            String bank = structuredAddress.getValueForField(AddressFieldTypeEnum.COMPANY_BANK);
            result.put(iban, bank);
        }
        return result;
    }

    private static List<StructuredAddressComponent> $default$addressComponents() {
        return new ArrayList<StructuredAddressComponent>();
    }

    public static StructuredAddressBuilder builder() {
        return new StructuredAddressBuilder();
    }

    public List<StructuredAddressComponent> getAddressComponents() {
        return this.addressComponents;
    }

    public StructuredAddress setAddressComponents(List<StructuredAddressComponent> addressComponents) {
        this.addressComponents = addressComponents;
        return this;
    }

    public StructuredAddress() {
        this.addressComponents = StructuredAddress.$default$addressComponents();
    }

    public StructuredAddress(List<StructuredAddressComponent> addressComponents) {
        this.addressComponents = addressComponents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructuredAddress)) {
            return false;
        }
        StructuredAddress other = (StructuredAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<StructuredAddressComponent> this$addressComponents = this.getAddressComponents();
        List<StructuredAddressComponent> other$addressComponents = other.getAddressComponents();
        return !(this$addressComponents == null ? other$addressComponents != null : !((Object)this$addressComponents).equals(other$addressComponents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StructuredAddress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StructuredAddressComponent> $addressComponents = this.getAddressComponents();
        result = result * 59 + ($addressComponents == null ? 43 : ((Object)$addressComponents).hashCode());
        return result;
    }

    public String toString() {
        return "StructuredAddress(addressComponents=" + this.getAddressComponents() + ")";
    }

    public static class StructuredAddressBuilder {
        private boolean addressComponents$set;
        private List<StructuredAddressComponent> addressComponents$value;

        StructuredAddressBuilder() {
        }

        public StructuredAddressBuilder setAddressComponents(List<StructuredAddressComponent> addressComponents) {
            this.addressComponents$value = addressComponents;
            this.addressComponents$set = true;
            return this;
        }

        public StructuredAddress build() {
            List addressComponents$value = this.addressComponents$value;
            if (!this.addressComponents$set) {
                addressComponents$value = StructuredAddress.$default$addressComponents();
            }
            return new StructuredAddress(addressComponents$value);
        }

        public String toString() {
            return "StructuredAddress.StructuredAddressBuilder(addressComponents$value=" + this.addressComponents$value + ")";
        }
    }
}

