/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr;

import java.util.StringTokenizer;

public class DevUtils {
    public static boolean debug = true;

    public static void analyzeDebugOptions() {
        if (System.getProperty("debug") != null && "".equals(System.getProperty("debug"))) {
            System.out.println("The valid debug options are: [" + DevUtils.getDebugOptions() + "]");
        }
    }

    public static boolean debuging(String arg) {
        if (!debug) {
            return false;
        }
        if (arg == null || arg.equals("") || arg.equals("*") || arg.equals("all")) {
            return true;
        }
        try {
            String[] debugs = System.getProperty("debug").split(" *\\, *");
            int i = 0;
            while (i < debugs.length) {
                if (debugs[i].equals(arg) || debugs[i].equals("*") || debugs[i].equals("all")) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (Exception e) {
            debug = false;
            return false;
        }
    }

    public static String getDebugOptions() {
        return "stackTrace, editors, naming, io, jdbc, browsers, j2p bridge";
    }

    public static boolean includeStackTrace() {
        try {
            StringTokenizer st = new StringTokenizer(System.getProperty("debug"), ", ", false);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equalsIgnoreCase("stackTrace")) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void handleException(String debugSource, String source, Throwable e) {
        if (DevUtils.debuging(debugSource)) {
            System.err.println(" ->> Caught unhandled exception: " + e);
            System.err.println(" ->> " + debugSource + " : " + source);
            e.printStackTrace();
        }
    }

    public static void delay(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

