/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.ext;

import com.shfarr.ui.layouts.MaxLayout;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class FhTableHeader
extends JTableHeader {
    public static final MouseListener FAKE_MOUSE_LISTENER = new MouseAdapter(){};
    public static final MouseMotionListener FAKE_MOUSE_MOTION_LISTENER = new MouseMotionAdapter(){};
    protected JComponent title = null;

    public FhTableHeader() {
        this.init();
    }

    public FhTableHeader(TableColumnModel cm) {
        super(cm);
        this.init();
    }

    private void init() {
        this.setLayout(new MaxLayout(){

            protected void performLayout(Container parent) {
                Insets ins = parent.getInsets();
                Rectangle vRect = ((JViewport)parent.getParent()).getVisibleRect();
                if (FhTableHeader.this.getTitle() != null) {
                    FhTableHeader.this.getTitle().setBounds(vRect.x, ins.top, vRect.width, FhTableHeader.this.getTitleHeight() - ins.top - ins.bottom);
                }
            }
        });
    }

    public Rectangle getHeaderRect(int column) {
        Rectangle r = super.getHeaderRect(column);
        r.y += this.getTitleHeight();
        r.height -= this.getTitleHeight();
        return r;
    }

    public int getTitleHeight() {
        return this.title != null ? this.title.getPreferredSize().height : 0;
    }

    public JComponent getTitle() {
        return this.title;
    }

    public void setTitle(JComponent panel) {
        if (panel != null) {
            this.title = panel;
            this.add(this.title);
            this.title.addMouseListener(FAKE_MOUSE_LISTENER);
            this.title.addMouseMotionListener(FAKE_MOUSE_MOTION_LISTENER);
        } else {
            this.remove(this.title);
            this.title = null;
        }
    }
}

