/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.bind.JsonTreeReader$1;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class JsonTreeReader
extends JsonReader {
    private static final Reader a = new JsonTreeReader$1();
    private static final Object a = new Object();
    private final List<Object> a = new ArrayList();

    public JsonTreeReader(JsonElement jsonElement) {
        super(a);
        this.a.add(jsonElement);
    }

    @Override
    public final void beginArray() {
        this.a(JsonToken.BEGIN_ARRAY);
        JsonArray jsonArray = (JsonArray)this.a();
        this.a.add(jsonArray.iterator());
    }

    @Override
    public final void endArray() {
        this.a(JsonToken.END_ARRAY);
        this.b();
        this.b();
    }

    @Override
    public final void beginObject() {
        this.a(JsonToken.BEGIN_OBJECT);
        JsonObject jsonObject = (JsonObject)this.a();
        this.a.add(jsonObject.entrySet().iterator());
    }

    @Override
    public final void endObject() {
        this.a(JsonToken.END_OBJECT);
        this.b();
        this.b();
    }

    @Override
    public final boolean hasNext() {
        JsonToken jsonToken = this.peek();
        return jsonToken != JsonToken.END_OBJECT && jsonToken != JsonToken.END_ARRAY;
    }

    @Override
    public final JsonToken peek() {
        Object object;
        block12: {
            boolean bl2;
            while (true) {
                if (this.a.isEmpty()) {
                    return JsonToken.END_DOCUMENT;
                }
                object = this.a();
                if (!(object instanceof Iterator)) break block12;
                bl2 = this.a.get(this.a.size() - 2) instanceof JsonObject;
                if (!(object = (Iterator)object).hasNext()) break;
                if (bl2) {
                    return JsonToken.NAME;
                }
                this.a.add(object.next());
            }
            if (bl2) {
                return JsonToken.END_OBJECT;
            }
            return JsonToken.END_ARRAY;
        }
        if (object instanceof JsonObject) {
            return JsonToken.BEGIN_OBJECT;
        }
        if (object instanceof JsonArray) {
            return JsonToken.BEGIN_ARRAY;
        }
        if (object instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
            if (jsonPrimitive.isString()) {
                return JsonToken.STRING;
            }
            if (jsonPrimitive.isBoolean()) {
                return JsonToken.BOOLEAN;
            }
            if (jsonPrimitive.isNumber()) {
                return JsonToken.NUMBER;
            }
            throw new AssertionError();
        }
        if (object instanceof JsonNull) {
            return JsonToken.NULL;
        }
        if (object == a) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw new AssertionError();
    }

    private Object a() {
        return this.a.get(this.a.size() - 1);
    }

    private Object b() {
        return this.a.remove(this.a.size() - 1);
    }

    private void a(JsonToken jsonToken) {
        if (this.peek() != jsonToken) {
            throw new IllegalStateException("Expected " + (Object)((Object)jsonToken) + " but was " + (Object)((Object)this.peek()));
        }
    }

    @Override
    public final String nextName() {
        this.a(JsonToken.NAME);
        Map.Entry entry = (Map.Entry)((Iterator)this.a()).next();
        this.a.add(entry.getValue());
        return (String)entry.getKey();
    }

    @Override
    public final String nextString() {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.STRING && jsonToken != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.STRING) + " but was " + (Object)((Object)jsonToken));
        }
        return ((JsonPrimitive)this.b()).getAsString();
    }

    @Override
    public final boolean nextBoolean() {
        this.a(JsonToken.BOOLEAN);
        return ((JsonPrimitive)this.b()).getAsBoolean();
    }

    @Override
    public final void nextNull() {
        this.a(JsonToken.NULL);
        this.b();
    }

    @Override
    public final double nextDouble() {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken));
        }
        double d2 = ((JsonPrimitive)this.a()).getAsDouble();
        if (!this.isLenient() && (Double.isNaN(d2) || Double.isInfinite(d2))) {
            throw new NumberFormatException("JSON forbids NaN and infinities: " + d2);
        }
        this.b();
        return d2;
    }

    @Override
    public final long nextLong() {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken));
        }
        long l2 = ((JsonPrimitive)this.a()).getAsLong();
        this.b();
        return l2;
    }

    @Override
    public final int nextInt() {
        JsonToken jsonToken = this.peek();
        if (jsonToken != JsonToken.NUMBER && jsonToken != JsonToken.STRING) {
            throw new IllegalStateException("Expected " + (Object)((Object)JsonToken.NUMBER) + " but was " + (Object)((Object)jsonToken));
        }
        int n2 = ((JsonPrimitive)this.a()).getAsInt();
        this.b();
        return n2;
    }

    @Override
    public final void close() {
        this.a.clear();
        this.a.add(a);
    }

    @Override
    public final void skipValue() {
        if (this.peek() == JsonToken.NAME) {
            this.nextName();
            return;
        }
        this.b();
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName();
    }

    public final void promoteNameToValue() {
        this.a(JsonToken.NAME);
        Map.Entry entry = (Map.Entry)((Iterator)this.a()).next();
        this.a.add(entry.getValue());
        this.a.add(new JsonPrimitive((String)entry.getKey()));
    }
}

