/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.util.UUID;

public class UuidType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 48;
    private static final UuidType singleTon = new UuidType();

    public static UuidType getSingleton() {
        return singleTon;
    }

    private UuidType() {
        super(SqlType.STRING, new Class[]{UUID.class});
    }

    protected UuidType(SqlType sqlType, Class<?>[] classArray) {
        super(sqlType, classArray);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String string) {
        try {
            return UUID.fromString(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LoggerFactory$1.create("Problems with field " + fieldType + " parsing default UUID-string '" + string + "'", illegalArgumentException);
        }
    }

    @Override
    public Object resultToSqlArg$6e4db97a(FieldType fieldType, k k2, int n2) {
        return k2.a();
    }

    @Override
    public Object sqlArgToJava(FieldType object, Object object2, int n2) {
        object = (String)object2;
        try {
            return UUID.fromString((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LoggerFactory$1.create("Problems with column " + n2 + " parsing UUID-string '" + (String)object + "'", illegalArgumentException);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object object) {
        return ((UUID)object).toString();
    }

    @Override
    public boolean isValidGeneratedType() {
        return true;
    }

    @Override
    public boolean isSelfGeneratedId() {
        return true;
    }

    @Override
    public Object generateId() {
        return UUID.randomUUID();
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }
}

