/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.CallDetailRecord;
import org.asteriskjava.live.CallerId;
import org.asteriskjava.live.ChannelState;
import org.asteriskjava.live.ChannelStateHistoryEntry;
import org.asteriskjava.live.DialedChannelHistoryEntry;
import org.asteriskjava.live.Extension;
import org.asteriskjava.live.ExtensionHistoryEntry;
import org.asteriskjava.live.HangupCause;
import org.asteriskjava.live.LinkedChannelHistoryEntry;
import org.asteriskjava.live.NoSuchChannelException;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.live.internal.CallDetailRecordImpl;
import org.asteriskjava.live.internal.MeetMeUserImpl;
import org.asteriskjava.manager.action.AbsoluteTimeoutAction;
import org.asteriskjava.manager.action.ChangeMonitorAction;
import org.asteriskjava.manager.action.GetVarAction;
import org.asteriskjava.manager.action.HangupAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.MonitorAction;
import org.asteriskjava.manager.action.PauseMixMonitorAction;
import org.asteriskjava.manager.action.PauseMonitorAction;
import org.asteriskjava.manager.action.PlayDtmfAction;
import org.asteriskjava.manager.action.RedirectAction;
import org.asteriskjava.manager.action.SetVarAction;
import org.asteriskjava.manager.action.StopMonitorAction;
import org.asteriskjava.manager.action.UnpauseMonitorAction;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.MixMonitorDirection;

class AsteriskChannelImpl
extends AbstractLiveObject
implements AsteriskChannel {
    private static final String CAUSE_VARIABLE_NAME = "PRI_CAUSE";
    private String id;
    private String traceId;
    private final Date dateOfCreation;
    private Date dateOfRemoval;
    private String name;
    private CallerId callerId;
    private ChannelState state;
    private String account;
    private final List<ExtensionHistoryEntry> extensionHistory;
    private final List<ChannelStateHistoryEntry> stateHistory;
    private final List<LinkedChannelHistoryEntry> linkedChannelHistory;
    private final List<DialedChannelHistoryEntry> dialedChannelHistory;
    private AsteriskChannel dialedChannel;
    private AsteriskChannel dialingChannel;
    private AsteriskChannel linkedChannel;
    private boolean wasLinked;
    private HangupCause hangupCause;
    private String hangupCauseText;
    private CallDetailRecordImpl callDetailRecord;
    private MeetMeUserImpl meetMeUserImpl;
    private AsteriskQueueEntryImpl queueEntryImpl;
    private Extension parkedAt;
    private Character dtmfReceived;
    private Character dtmfSent;
    private boolean isMonitored;
    private final Map<String, String> variables;

    AsteriskChannelImpl(AsteriskServerImpl asteriskServerImpl, String string, String string2, Date date) {
        super(asteriskServerImpl);
        if (asteriskServerImpl == null) {
            throw new IllegalArgumentException("Parameter 'server' passed to AsteriskChannelImpl() must not be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Parameter 'name' passed to AsteriskChannelImpl() must not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter 'id' passed to AsteriskChannelImpl() must not be null.");
        }
        if (date == null) {
            throw new IllegalArgumentException("Parameter 'dateOfCreation' passed to AsteriskChannelImpl() must not be null.");
        }
        this.name = string;
        this.id = string2;
        this.dateOfCreation = date;
        this.extensionHistory = new ArrayList<ExtensionHistoryEntry>();
        this.stateHistory = new ArrayList<ChannelStateHistoryEntry>();
        this.linkedChannelHistory = new ArrayList<LinkedChannelHistoryEntry>();
        this.dialedChannelHistory = new ArrayList<DialedChannelHistoryEntry>();
        this.variables = new HashMap<String, String>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    void idChanged(Date object, String string) {
        object = this.id;
        if (object != null && ((String)object).equals(string)) {
            return;
        }
        this.id = string;
        this.firePropertyChange("id", object, string);
    }

    String getTraceId() {
        return this.traceId;
    }

    void setTraceId(String string) {
        this.traceId = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void nameChanged(Date object, String string) {
        object = this.name;
        if (object != null && ((String)object).equals(string)) {
            return;
        }
        this.name = string;
        this.firePropertyChange("name", object, string);
    }

    @Override
    public CallerId getCallerId() {
        return this.callerId;
    }

    void setCallerId(CallerId callerId) {
        CallerId callerId2 = this.callerId;
        this.callerId = callerId;
        this.firePropertyChange("callerId", callerId2, callerId);
    }

    @Override
    public ChannelState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasInState(ChannelState channelState) {
        List<ChannelStateHistoryEntry> list = this.stateHistory;
        synchronized (list) {
            Iterator<ChannelStateHistoryEntry> iterator = this.stateHistory.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getState() != channelState) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean wasBusy() {
        return this.wasInState(ChannelState.BUSY) || this.hangupCause == HangupCause.AST_CAUSE_BUSY || this.hangupCause == HangupCause.AST_CAUSE_USER_BUSY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stateChanged(Date serializable, ChannelState channelState) {
        ChannelState channelState2 = this.state;
        if (channelState2 == channelState) {
            return;
        }
        serializable = new ChannelStateHistoryEntry((Date)serializable, channelState);
        List<ChannelStateHistoryEntry> list = this.stateHistory;
        synchronized (list) {
            this.stateHistory.add((ChannelStateHistoryEntry)serializable);
        }
        this.state = channelState;
        this.firePropertyChange("state", (Object)channelState2, (Object)channelState);
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    void setAccount(String string) {
        String string2 = this.account;
        this.account = string;
        this.firePropertyChange("account", string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Extension getCurrentExtension() {
        Extension extension;
        List<ExtensionHistoryEntry> list = this.extensionHistory;
        synchronized (list) {
            extension = this.extensionHistory.isEmpty() ? null : this.extensionHistory.get(this.extensionHistory.size() - 1).getExtension();
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Extension getFirstExtension() {
        Extension extension;
        List<ExtensionHistoryEntry> list = this.extensionHistory;
        synchronized (list) {
            extension = this.extensionHistory.isEmpty() ? null : this.extensionHistory.get(0).getExtension();
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExtensionHistoryEntry> getExtensionHistory() {
        ArrayList<ExtensionHistoryEntry> arrayList;
        List<ExtensionHistoryEntry> list = this.extensionHistory;
        synchronized (list) {
            arrayList = new ArrayList<ExtensionHistoryEntry>(this.extensionHistory);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extensionVisited(Date serializable, Extension extension) {
        Extension extension2 = this.getCurrentExtension();
        serializable = new ExtensionHistoryEntry((Date)serializable, extension);
        List<ExtensionHistoryEntry> list = this.extensionHistory;
        synchronized (list) {
            this.extensionHistory.add((ExtensionHistoryEntry)serializable);
        }
        this.firePropertyChange("currentExtension", extension2, extension);
    }

    @Override
    public Date getDateOfCreation() {
        return this.dateOfCreation;
    }

    @Override
    public Date getDateOfRemoval() {
        return this.dateOfRemoval;
    }

    @Override
    public HangupCause getHangupCause() {
        return this.hangupCause;
    }

    @Override
    public String getHangupCauseText() {
        return this.hangupCauseText;
    }

    @Override
    public CallDetailRecord getCallDetailRecord() {
        return this.callDetailRecord;
    }

    void callDetailRecordReceived(Date object, CallDetailRecordImpl callDetailRecordImpl) {
        object = this.callDetailRecord;
        this.callDetailRecord = callDetailRecordImpl;
        this.firePropertyChange("callDetailRecord", object, callDetailRecordImpl);
    }

    synchronized void hungup(Date date, HangupCause hangupCause, String string) {
        this.dateOfRemoval = date;
        this.hangupCause = hangupCause;
        this.hangupCauseText = string;
        this.stateChanged(date, ChannelState.HUNGUP);
    }

    @Override
    public AsteriskChannel getDialedChannel() {
        return this.dialedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DialedChannelHistoryEntry> getDialedChannelHistory() {
        ArrayList<DialedChannelHistoryEntry> arrayList;
        List<LinkedChannelHistoryEntry> list = this.linkedChannelHistory;
        synchronized (list) {
            arrayList = new ArrayList<DialedChannelHistoryEntry>(this.dialedChannelHistory);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void channelDialed(Date object, AsteriskChannel asteriskChannel) {
        AsteriskChannel asteriskChannel2 = this.dialedChannel;
        object = new DialedChannelHistoryEntry((Date)object, asteriskChannel);
        List<DialedChannelHistoryEntry> list = this.dialedChannelHistory;
        synchronized (list) {
            this.dialedChannelHistory.add((DialedChannelHistoryEntry)object);
        }
        this.dialedChannel = asteriskChannel;
        this.firePropertyChange("dialedChannel", asteriskChannel2, asteriskChannel);
    }

    @Override
    public AsteriskChannel getDialingChannel() {
        return this.dialingChannel;
    }

    synchronized void channelDialing(Date object, AsteriskChannel asteriskChannel) {
        object = this.dialingChannel;
        this.dialingChannel = asteriskChannel;
        this.firePropertyChange("dialingChannel", object, asteriskChannel);
    }

    @Override
    public AsteriskChannel getLinkedChannel() {
        return this.linkedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LinkedChannelHistoryEntry> getLinkedChannelHistory() {
        ArrayList<LinkedChannelHistoryEntry> arrayList;
        List<LinkedChannelHistoryEntry> list = this.linkedChannelHistory;
        synchronized (list) {
            arrayList = new ArrayList<LinkedChannelHistoryEntry>(this.linkedChannelHistory);
        }
        return arrayList;
    }

    @Override
    public boolean wasLinked() {
        return this.wasLinked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void channelLinked(Date object, AsteriskChannel asteriskChannel) {
        AsteriskChannel asteriskChannel2 = this.linkedChannel;
        object = new LinkedChannelHistoryEntry((Date)object, asteriskChannel);
        List<LinkedChannelHistoryEntry> list = this.linkedChannelHistory;
        synchronized (list) {
            this.linkedChannelHistory.add((LinkedChannelHistoryEntry)object);
        }
        this.linkedChannel = asteriskChannel;
        this.wasLinked = true;
        this.firePropertyChange("linkedChannel", asteriskChannel2, asteriskChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void channelUnlinked(Date date) {
        LinkedChannelHistoryEntry linkedChannelHistoryEntry;
        AsteriskChannel asteriskChannel = this.linkedChannel;
        List<LinkedChannelHistoryEntry> list = this.linkedChannelHistory;
        synchronized (list) {
            linkedChannelHistoryEntry = this.linkedChannelHistory.isEmpty() ? null : this.linkedChannelHistory.get(this.linkedChannelHistory.size() - 1);
        }
        if (linkedChannelHistoryEntry != null) {
            linkedChannelHistoryEntry.setDateUnlinked(date);
        }
        this.linkedChannel = null;
        this.firePropertyChange("linkedChannel", asteriskChannel, null);
    }

    @Override
    public MeetMeUserImpl getMeetMeUser() {
        return this.meetMeUserImpl;
    }

    void setMeetMeUserImpl(MeetMeUserImpl meetMeUserImpl) {
        MeetMeUserImpl meetMeUserImpl2 = this.meetMeUserImpl;
        this.meetMeUserImpl = meetMeUserImpl;
        this.firePropertyChange("meetMeUser", meetMeUserImpl2, meetMeUserImpl);
    }

    @Override
    public void hangup() {
        this.hangup(null);
    }

    @Override
    public void hangup(HangupCause object) {
        if (object != null) {
            this.setVariable(CAUSE_VARIABLE_NAME, Integer.toString(((HangupCause)((Object)object)).getCode()));
            object = new HangupAction(this.name, ((HangupCause)((Object)object)).getCode());
        } else {
            object = new HangupAction(this.name);
        }
        object = this.server.sendAction((ManagerAction)object);
        if (object instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    @Override
    public void setAbsoluteTimeout(int n2) {
        ManagerResponse managerResponse = this.server.sendAction(new AbsoluteTimeoutAction(this.name, n2));
        if (managerResponse instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + managerResponse.getMessage());
        }
    }

    @Override
    public void redirect(String object, String string, int n2) {
        if ((object = this.server.sendAction(new RedirectAction(this.name, (String)object, string, n2))) instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    @Override
    public void redirectBothLegs(String object, String string, int n2) {
        object = this.linkedChannel == null ? this.server.sendAction(new RedirectAction(this.name, (String)object, string, n2)) : this.server.sendAction(new RedirectAction(this.name, this.linkedChannel.getName(), (String)object, string, n2, (String)object, string, n2));
        if (object instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVariable(String string) {
        String string2;
        Map<String, String> map = this.variables;
        synchronized (map) {
            string2 = this.variables.get(string);
            if (string2 != null) {
                return string2;
            }
            ManagerResponse managerResponse = this.server.sendAction(new GetVarAction(this.name, string));
            if (managerResponse instanceof ManagerError) {
                throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + managerResponse.getMessage());
            }
            string2 = managerResponse.getAttribute("Value");
            if (string2 == null) {
                string2 = managerResponse.getAttribute(string);
            }
            this.variables.put(string, string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVariable(String string, String string2) {
        Object object = this.server.sendAction(new SetVarAction(this.name, string, string2));
        if (object instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
        object = this.variables;
        synchronized (object) {
            this.variables.put(string, string2);
            return;
        }
    }

    @Override
    public void playDtmf(String object) {
        if (object == null) {
            throw new IllegalArgumentException("DTMF digit to send must not be null");
        }
        if ((object = this.server.sendAction(new PlayDtmfAction(this.name, (String)object))) instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    @Override
    public void startMonitoring(String string) {
        this.startMonitoring(string, null, false);
    }

    @Override
    public void startMonitoring(String string, String string2) {
        this.startMonitoring(string, string2, false);
    }

    @Override
    public void startMonitoring(String object, String string, boolean bl2) {
        if ((object = this.server.sendAction(new MonitorAction(this.name, (String)object, string, bl2))) instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    @Override
    public void changeMonitoring(String object) {
        if (object == null) {
            throw new IllegalArgumentException("New filename must not be null");
        }
        if ((object = this.server.sendAction(new ChangeMonitorAction(this.name, (String)object))) instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    @Override
    public void stopMonitoring() {
        ManagerResponse managerResponse = this.server.sendAction(new StopMonitorAction(this.name));
        if (managerResponse instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + managerResponse.getMessage());
        }
    }

    @Override
    public void pauseMonitoring() {
        ManagerResponse managerResponse = this.server.sendAction(new PauseMonitorAction(this.name));
        if (managerResponse instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + managerResponse.getMessage());
        }
    }

    @Override
    public void unpauseMonitoring() {
        ManagerResponse managerResponse = this.server.sendAction(new UnpauseMonitorAction(this.name));
        if (managerResponse instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + managerResponse.getMessage());
        }
    }

    @Override
    public void pauseMixMonitor(MixMonitorDirection object) {
        object = this.server.sendAction(new PauseMixMonitorAction(this.name, 1, ((MixMonitorDirection)((Object)object)).getStateName()));
        if (object instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    @Override
    public void unPauseMixMonitor(MixMonitorDirection object) {
        object = this.server.sendAction(new PauseMixMonitorAction(this.name, 0, ((MixMonitorDirection)((Object)object)).getStateName()));
        if (object instanceof ManagerError) {
            throw new NoSuchChannelException("Channel '" + this.name + "' is not available: " + ((ManagerResponse)object).getMessage());
        }
    }

    @Override
    public Extension getParkedAt() {
        return this.parkedAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateVariable(String string, String string2) {
        Map<String, String> map = this.variables;
        synchronized (map) {
            this.variables.put(string, string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getVariables() {
        Map<String, String> map = this.variables;
        synchronized (map) {
            return new HashMap<String, String>(this.variables);
        }
    }

    @Override
    public Character getDtmfReceived() {
        return this.dtmfReceived;
    }

    @Override
    public Character getDtmfSent() {
        return this.dtmfSent;
    }

    void dtmfReceived(Character c2) {
        Character c3 = this.dtmfReceived;
        this.dtmfReceived = c2;
        this.firePropertyChange("dtmfReceived", c3, c2);
    }

    void dtmfSent(Character c2) {
        Character c3 = this.dtmfSent;
        this.dtmfSent = c2;
        this.firePropertyChange("dtmfSent", c3, c2);
    }

    void setParkedAt(Extension extension) {
        Extension extension2 = this.parkedAt;
        this.parkedAt = extension;
        this.firePropertyChange("parkedAt", extension2, extension);
    }

    @Override
    public AsteriskQueueEntryImpl getQueueEntry() {
        return this.queueEntryImpl;
    }

    void setQueueEntry(AsteriskQueueEntryImpl asteriskQueueEntryImpl) {
        AsteriskQueueEntryImpl asteriskQueueEntryImpl2 = this.queueEntryImpl;
        this.queueEntryImpl = asteriskQueueEntryImpl;
        this.firePropertyChange("queueEntry", asteriskQueueEntryImpl2, asteriskQueueEntryImpl);
    }

    @Override
    public boolean isMonitored() {
        return this.isMonitored;
    }

    void setMonitored(boolean bl2) {
        boolean bl3 = this.isMonitored;
        this.isMonitored = bl2;
        this.firePropertyChange("monitored", bl3, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        AsteriskChannel asteriskChannel;
        AsteriskChannel asteriskChannel2;
        AsteriskChannel asteriskChannel3;
        StringBuffer stringBuffer = new StringBuffer("AsteriskChannel[");
        AsteriskChannel asteriskChannel4 = this;
        synchronized (asteriskChannel4) {
            stringBuffer.append("id='").append(this.getId()).append("',");
            stringBuffer.append("name='").append(this.getName()).append("',");
            stringBuffer.append("callerId='").append(this.getCallerId()).append("',");
            stringBuffer.append("state='").append((Object)this.getState()).append("',");
            stringBuffer.append("account='").append(this.getAccount()).append("',");
            stringBuffer.append("dateOfCreation=").append(this.getDateOfCreation()).append(",");
            asteriskChannel3 = this.dialedChannel;
            asteriskChannel2 = this.dialingChannel;
            asteriskChannel = this.linkedChannel;
        }
        if (asteriskChannel3 == null) {
            stringBuffer.append("dialedChannel=null,");
        } else {
            stringBuffer.append("dialedChannel=AsteriskChannel[");
            asteriskChannel4 = asteriskChannel3;
            synchronized (asteriskChannel4) {
                stringBuffer.append("id='").append(asteriskChannel3.getId()).append("',");
                stringBuffer.append("name='").append(asteriskChannel3.getName()).append("'],");
            }
        }
        if (asteriskChannel2 == null) {
            stringBuffer.append("dialingChannel=null,");
        } else {
            stringBuffer.append("dialingChannel=AsteriskChannel[");
            asteriskChannel4 = asteriskChannel2;
            synchronized (asteriskChannel4) {
                stringBuffer.append("id='").append(asteriskChannel2.getId()).append("',");
                stringBuffer.append("name='").append(asteriskChannel2.getName()).append("'],");
            }
        }
        if (asteriskChannel == null) {
            stringBuffer.append("linkedChannel=null");
        } else {
            stringBuffer.append("linkedChannel=AsteriskChannel[");
            asteriskChannel4 = asteriskChannel;
            synchronized (asteriskChannel4) {
                stringBuffer.append("id='").append(asteriskChannel.getId()).append("',");
                stringBuffer.append("name='").append(asteriskChannel.getName()).append("']");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

