/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.util.List;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdSelectNext
extends Cmd {
    private static final long serialVersionUID = -5038323715965138457L;
    public static final String DIR = "Direction";
    public static final String DIR_NEXT = "Next";
    public static final String DIR_PREV = "Previous";

    public CmdSelectNext() {
        this(true);
    }

    public CmdSelectNext(boolean bl2) {
        this(bl2 ? DIR_NEXT : DIR_PREV);
    }

    public CmdSelectNext(String string) {
        super("Select" + string);
        this.setArg(DIR, string);
    }

    @Override
    public void doIt() {
        Fig fig = null;
        int n2 = 1;
        Object object = (String)this.getArg(DIR);
        if (DIR_PREV.equals(object)) {
            n2 = -1;
        }
        Editor editor = Globals.curEditor();
        object = editor.getSelectionManager();
        List<Fig> list = editor.getLayerManager().getContents();
        int n3 = list.size();
        int n4 = n3 + 1;
        if (((SelectionManager)object).size() == 0) {
            n4 = 0;
        } else if (((SelectionManager)object).size() == 1) {
            object = ((Selection)((SelectionManager)object).selections().firstElement()).getContent();
            n4 = (list.indexOf(object) + n2 + n3) % n3;
        }
        if (n3 > n4) {
            fig = list.get(n4);
        }
        if (fig != null) {
            editor.getSelectionManager().select(fig);
        }
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdSelectNext");
    }
}

