/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.graph.GraphController;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphEdgeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphNodeRenderer;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public class LayerPerspective
extends LayerDiagram
implements GraphListener {
    private static final long serialVersionUID = -3219953846728127850L;
    public static final int GAP = 16;
    private GraphModel _gm;
    private GraphController controller;
    private GraphNodeRenderer _nodeRenderer = new DefaultGraphNodeRenderer();
    private GraphEdgeRenderer _edgeRenderer = new DefaultGraphEdgeRenderer();
    private Vector _allowedNetClasses = new Vector();
    private Hashtable _nodeTypeRegions = new Hashtable();
    private Diagram diagram;
    private static Log LOG = LogFactory.getLog(LayerPerspective.class);

    public LayerPerspective(String string, GraphModel graphModel) {
        super(string);
        this._gm = graphModel;
        this.controller = null;
        this._gm.addGraphEventListener(this);
    }

    public LayerPerspective(String string, GraphModel graphModel, GraphController graphController) {
        super(string);
        this._gm = graphModel;
        this.controller = graphController;
        this._gm.addGraphEventListener(this);
    }

    public GraphModel getGraphModel() {
        return this._gm;
    }

    public void setGraphModel(GraphModel graphModel) {
        this._gm.removeGraphEventListener(this);
        this._gm = graphModel;
        this._gm.addGraphEventListener(this);
    }

    public GraphController getGraphController() {
        return this.controller;
    }

    public void setGraphController(GraphController graphController) {
        this.controller = graphController;
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._nodeRenderer;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        this._nodeRenderer = graphNodeRenderer;
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._edgeRenderer;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        this._edgeRenderer = graphEdgeRenderer;
    }

    public void allowNetClass(Class clazz) {
        this._allowedNetClasses.addElement(clazz);
    }

    public void addNodeTypeRegion(Class clazz, Rectangle rectangle) {
        this._nodeTypeRegions.put(clazz, rectangle);
    }

    public void putInPosition(Fig fig) {
        Serializable serializable = fig.getOwner().getClass();
        if ((serializable = (Rectangle)this._nodeTypeRegions.get(serializable)) != null) {
            fig.setLocation(((Rectangle)serializable).x, ((Rectangle)serializable).y);
            this.bumpOffOtherNodesIn(fig, (Rectangle)serializable, false, true);
        }
    }

    public void bumpOffOtherNodesIn(Fig fig, Rectangle rectangle, boolean bl2, boolean bl3) {
        Rectangle rectangle2 = fig.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (rectangle.intersects(rectangle2)) {
            Enumeration enumeration = this.nodesIn(rectangle2);
            if (!enumeration.hasMoreElements()) {
                return;
            }
            if (enumeration.nextElement() == fig && !enumeration.hasMoreElements()) {
                return;
            }
            int n7 = (n6 + 1) / 2 * (n6 % 2 == 0 ? -1 : 1);
            if (bl3) {
                rectangle2.y = n3 + n7 * (rectangle2.height + 16);
            } else {
                rectangle2.x = n2 + n7 * (rectangle2.width + 16);
            }
            fig.setLocation(rectangle2.x, rectangle2.y);
            if (!rectangle.intersects(rectangle2)) {
                n7 = rectangle.x;
                int n8 = rectangle.y;
                if (bl3) {
                    ++n4;
                    n7 = rectangle2.x + rectangle2.width + 16;
                    if (bl2) {
                        n8 += n4 % 2 * (rectangle2.height + 16) / 2;
                    }
                } else {
                    ++n5;
                    n8 = rectangle2.y + rectangle2.height + 16;
                    if (bl2) {
                        n7 += n5 % 2 * (rectangle2.width + 16) / 2;
                    }
                }
                fig.setLocation(n7, n8);
                rectangle2.setLocation(n7, n8);
            }
            ++n6;
        }
    }

    @Override
    public void nodeAdded(GraphEvent object) {
        if (this.presentationFor(object = ((GraphEvent)object).getArg()) == null) {
            if (!this.shouldShow(object)) {
                System.out.println("node rejected");
                return;
            }
            if ((object = this._nodeRenderer.getFigNodeFor(this._gm, this, object, null)) != null) {
                ((Fig)object).setLayer(this);
                this.putInPosition((Fig)object);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding node");
                }
                this.add((Fig)object);
            }
        }
    }

    @Override
    public void edgeAdded(GraphEvent object) {
        if (this.presentationFor(object = ((GraphEvent)object).getArg()) == null) {
            if (!this.shouldShow(object)) {
                System.out.println("edge rejected");
                return;
            }
            if ((object = this._edgeRenderer.getFigEdgeFor(this._gm, this, object, null)) != null) {
                ((Fig)object).setLayer(this);
                this.add((Fig)object);
                ((FigEdge)object).computeRoute();
                ((Fig)object).endTrans();
            }
        }
    }

    @Override
    public void nodeRemoved(GraphEvent serializable) {
        if ((serializable = this.presentationFor(serializable.getArg())) != null) {
            if (serializable instanceof FigNode && ((FigNode)serializable).getHighlight()) {
                ((FigNode)serializable).setHighlight(false);
            }
            this.remove((Fig)serializable);
        }
    }

    @Override
    public void edgeRemoved(GraphEvent serializable) {
        if ((serializable = this.presentationFor(serializable.getArg())) != null) {
            this.remove((Fig)serializable);
        }
    }

    @Override
    public void graphChanged(GraphEvent graphEvent) {
    }

    public boolean shouldShow(Object object) {
        if (this._allowedNetClasses.size() > 0 && !this._allowedNetClasses.contains(object.getClass())) {
            return false;
        }
        return !(object instanceof NetEdge) || this.getPortFig(((NetEdge)object).getSourcePort()) != null && this.getPortFig(((NetEdge)object).getDestPort()) != null;
    }

    void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public Diagram getDiagram() {
        return this.diagram;
    }
}

