/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.PlaceMemento;
import org.tigris.gef.graph.GraphFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.undo.UndoManager;

public class ModePlace
extends FigModifyingModeImpl {
    private static final long serialVersionUID = 8861862975789222877L;
    protected Object _node;
    protected FigNode _pers;
    protected GraphFactory _factory;
    protected boolean _addRelatedEdges = false;
    protected String _instructions;
    private static Log LOG = LogFactory.getLog(ModePlace.class);

    public ModePlace(GraphFactory graphFactory) {
        this._factory = graphFactory;
        this._node = null;
        this._pers = null;
        this._instructions = null;
    }

    public ModePlace(GraphFactory graphFactory, String string) {
        this._factory = graphFactory;
        this._node = null;
        this._pers = null;
        this._instructions = string;
    }

    @Override
    public String instructions() {
        if (this._instructions == null) {
            this._instructions = "";
        }
        return this._instructions;
    }

    @Override
    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public void setAddRelatedEdges(boolean bl2) {
        this._addRelatedEdges = bl2;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        UndoManager.getInstance().addMementoLock(this);
        this._node = this._factory.makeNode();
        this.start();
        this.editor = Globals.curEditor();
        GraphModel graphModel = this.editor.getGraphModel();
        GraphNodeRenderer graphNodeRenderer = this.editor.getGraphNodeRenderer();
        Layer layer = this.editor.getLayerManager().getActiveLayer();
        this._pers = graphNodeRenderer.getFigNodeFor(graphModel, layer, this._node, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mousePressed: Got a fig at position (" + this._pers.getX() + "," + this._pers.getY() + ")"));
        }
        this.mouseMoved(mouseEvent);
        mouseEvent.consume();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.editor.damageAll();
        this._pers = null;
        mouseEvent.consume();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this._pers == null) {
            mouseEvent.consume();
            return;
        }
        this.editor.damageAll();
        Point point = new Point(n2, n3);
        this.editor.snap(point);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mouseMoved: About to set location (" + this._pers.getX() + "," + this._pers.getY() + ")"));
        }
        this._pers.setLocation(point.x, point.y);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mouseMoved: Location set (" + this._pers.getX() + "," + this._pers.getY() + ")"));
        }
        this.editor.damageAll();
        mouseEvent.consume();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as already consumed");
            }
            return;
        }
        Serializable object = this.editor.getGraphModel();
        if (!(object instanceof MutableGraphModel)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as graph is not mutable");
            }
            return;
        }
        if ((object = (MutableGraphModel)object).canAddNode(this._node)) {
            LOG.debug((Object)("mouseReleased Adding fig to editor (" + this._pers.getX() + "," + this._pers.getY()));
            UndoManager.getInstance().startChain();
            this.editor.add(this._pers);
            object.addNode(this._node);
            if (this._addRelatedEdges) {
                object.addNodeRelatedEdges(this._node);
            }
            object = null;
            Rectangle rectangle = this._pers.getBounds();
            for (Fig object2 : this.editor.getLayerManager().getActiveLayer().getContents()) {
                Rectangle rectangle2;
                if (!object2.getUseTrapRect() || !(object2 instanceof FigNode) || !object2.isVisible() || object2.equals(this._pers) || (rectangle2 = object2.getTrapRect()) == null || !rectangle2.contains(rectangle.x, rectangle.y) || !rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) continue;
                object = object2;
            }
            this._pers.setEnclosingFig((Fig)object);
            if (this._node instanceof GraphNodeHooks) {
                ((GraphNodeHooks)this._node).postPlacement(this.editor);
            }
            UndoManager.getInstance().removeMementoLock(this);
            if (UndoManager.getInstance().isGenerateMementos()) {
                PlaceMemento placeMemento = new PlaceMemento(this.editor, this._node, this._pers);
                UndoManager.getInstance().addMemento(placeMemento);
            }
            UndoManager.getInstance().addMementoLock(this);
            this.editor.getSelectionManager().select(this._pers);
        }
        this.done();
        mouseEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            LOG.debug((Object)"ESC pressed");
            this.leave();
        }
    }

    @Override
    public void done() {
        super.done();
        this._pers = null;
        this._node = null;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._pers != null) {
            this._pers.paint(graphics);
        }
    }
}

