/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import org.tigris.gef.base.AlignAction;
import org.tigris.gef.base.CmdAdjustGrid;
import org.tigris.gef.base.CmdAdjustGuide;
import org.tigris.gef.base.CmdAdjustPageBreaks;
import org.tigris.gef.base.CmdCopy;
import org.tigris.gef.base.CmdExit;
import org.tigris.gef.base.CmdGroup;
import org.tigris.gef.base.CmdOpen;
import org.tigris.gef.base.CmdOpenWindow;
import org.tigris.gef.base.CmdPaste;
import org.tigris.gef.base.CmdPrint;
import org.tigris.gef.base.CmdPrintPageSetup;
import org.tigris.gef.base.CmdRemoveFromGraph;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.base.CmdSave;
import org.tigris.gef.base.CmdSavePGML;
import org.tigris.gef.base.CmdSaveSVG;
import org.tigris.gef.base.CmdSelectAll;
import org.tigris.gef.base.CmdSelectInvert;
import org.tigris.gef.base.CmdSelectNext;
import org.tigris.gef.base.CmdShowProperties;
import org.tigris.gef.base.CmdSpawn;
import org.tigris.gef.base.CmdUngroup;
import org.tigris.gef.base.CmdUseReshape;
import org.tigris.gef.base.CmdUseResize;
import org.tigris.gef.base.CmdUseRotate;
import org.tigris.gef.base.DistributeAction;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.base.NudgeAction;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.JGraph;
import org.tigris.gef.ui.IStatusBar;
import org.tigris.gef.ui.PaletteFig;
import org.tigris.gef.ui.ToolBar;
import org.tigris.gef.undo.RedoAction;
import org.tigris.gef.undo.UndoAction;
import org.tigris.gef.util.Localizer;

public class JGraphFrame
extends JFrame
implements Cloneable,
ModeChangeListener,
IStatusBar {
    private static final long serialVersionUID = -8167010467922210977L;
    private ToolBar _toolbar = new PaletteFig();
    private JGraph _graph;
    private JLabel _statusbar = new JLabel(" ");
    private JPanel _mainPanel = new JPanel(new BorderLayout());
    private JPanel _graphPanel = new JPanel(new BorderLayout());
    private JMenuBar _menubar = new JMenuBar();

    public JGraphFrame() {
        this("untitled");
    }

    public JGraphFrame(boolean bl2) {
        super("untitled");
        if (!bl2) {
            this.init(new JGraph());
        }
    }

    public JGraphFrame(String string) {
        this(string, new JGraph());
    }

    public JGraphFrame(String string, Editor editor) {
        this(string, new JGraph(editor));
    }

    public JGraphFrame(String string, JGraph jGraph) {
        super(string);
        this.init(jGraph);
    }

    public void init() {
        this.init(new JGraph());
    }

    public void init(JGraph container) {
        this._graph = container;
        container = this.getContentPane();
        this.setUpMenus();
        container.setLayout(new BorderLayout());
        container.add((Component)this._menubar, "North");
        this._graphPanel.add((Component)this._graph, "Center");
        this._graphPanel.setBorder(new EtchedBorder(1));
        this._mainPanel.add((Component)this._toolbar, "North");
        this._mainPanel.add((Component)this._graphPanel, "Center");
        container.add((Component)this._mainPanel, "Center");
        container.add((Component)this._statusbar, "South");
        this.setSize(300, 250);
        this._graph.addModeChangeListener(this);
    }

    public JGraphFrame(GraphModel graphModel) {
        this("untitled");
        this.setGraphModel(graphModel);
    }

    public Object clone() {
        return null;
    }

    public JGraph getGraph() {
        return this._graph;
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._graph.getEditor().getGraphEdgeRenderer();
    }

    public GraphModel getGraphModel() {
        return this._graph.getGraphModel();
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._graph.getEditor().getGraphNodeRenderer();
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this._menubar;
    }

    public ToolBar getToolBar() {
        return this._toolbar;
    }

    @Override
    public void modeChange(ModeChangeEvent modeChangeEvent) {
        if (!Globals.getSticky() && Globals.mode() instanceof ModeSelect) {
            this._toolbar.unpressAllButtons();
        }
    }

    public void setGraph(JGraph jGraph) {
        this._graph = jGraph;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        this._graph.getEditor().setGraphEdgeRenderer(graphEdgeRenderer);
    }

    public void setGraphModel(GraphModel graphModel) {
        this._graph.setGraphModel(graphModel);
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        this._graph.getEditor().setGraphNodeRenderer(graphNodeRenderer);
    }

    @Override
    public void setJMenuBar(JMenuBar jMenuBar) {
        this._menubar = jMenuBar;
        this.getContentPane().add((Component)this._menubar, "North");
    }

    public void setToolBar(ToolBar toolBar) {
        this._toolbar = toolBar;
        this._mainPanel.add((Component)this._toolbar, "North");
    }

    protected void setUpMenus() {
        JMenuItem jMenuItem = new JMenu(Localizer.localize("GefBase", "File"));
        jMenuItem.setMnemonic('F');
        this._menubar.add((JMenu)jMenuItem);
        JMenuItem jMenuItem2 = ((JMenu)jMenuItem).add(new CmdOpen());
        JMenuItem jMenuItem3 = ((JMenu)jMenuItem).add(new CmdSave());
        ((JMenu)jMenuItem).add(new CmdSavePGML());
        ((JMenu)jMenuItem).add(new CmdSaveSVG());
        Serializable serializable = new CmdPrint();
        JMenuItem jMenuItem4 = ((JMenu)jMenuItem).add((Action)((Object)serializable));
        ((JMenu)jMenuItem).add(new CmdPrintPageSetup((CmdPrint)serializable));
        ((JMenu)jMenuItem).add(new CmdOpenWindow("org.tigris.gef.base.PrefsEditor", "Preferences..."));
        jMenuItem = ((JMenu)jMenuItem).add(new CmdExit());
        JMenuItem jMenuItem5 = new JMenu(Localizer.localize("GefBase", "Edit"));
        jMenuItem5.setMnemonic('E');
        this._menubar.add((JMenu)jMenuItem5);
        JMenuItem jMenuItem6 = ((JMenu)jMenuItem5).add(new UndoAction(Localizer.localize("GefBase", "Undo")));
        jMenuItem6.setMnemonic(Localizer.localize("GefBase", "UndoMnemonic").charAt(0));
        JMenuItem jMenuItem7 = ((JMenu)jMenuItem5).add(new RedoAction(Localizer.localize("GefBase", "Redo")));
        jMenuItem7.setMnemonic(Localizer.localize("GefBase", "RedoMnemonic").charAt(0));
        serializable = new JMenu(Localizer.localize("GefBase", "Select"));
        ((JMenu)jMenuItem5).add((JMenuItem)serializable);
        ((JMenu)serializable).add(new CmdSelectAll());
        ((JMenu)serializable).add(new CmdSelectNext(false));
        ((JMenu)serializable).add(new CmdSelectNext(true));
        ((JMenu)serializable).add(new CmdSelectInvert());
        ((JMenu)jMenuItem5).addSeparator();
        JMenuItem jMenuItem8 = ((JMenu)jMenuItem5).add(new CmdCopy());
        jMenuItem8.setMnemonic('C');
        JMenuItem jMenuItem9 = ((JMenu)jMenuItem5).add(new CmdPaste());
        jMenuItem9.setMnemonic('P');
        serializable = ((JMenu)jMenuItem5).add(new CmdRemoveFromGraph());
        ((JMenu)jMenuItem5).addSeparator();
        ((JMenu)jMenuItem5).add(new CmdUseReshape());
        ((JMenu)jMenuItem5).add(new CmdUseResize());
        ((JMenu)jMenuItem5).add(new CmdUseRotate());
        jMenuItem5 = new JMenu(Localizer.localize("GefBase", "View"));
        this._menubar.add((JMenu)jMenuItem5);
        jMenuItem5.setMnemonic('V');
        ((JMenu)jMenuItem5).add(new CmdSpawn());
        ((JMenu)jMenuItem5).add(new CmdShowProperties());
        ((JMenu)jMenuItem5).addSeparator();
        ((JMenu)jMenuItem5).add(new CmdAdjustGrid());
        ((JMenu)jMenuItem5).add(new CmdAdjustGuide());
        ((JMenu)jMenuItem5).add(new CmdAdjustPageBreaks());
        Serializable serializable2 = new JMenu(Localizer.localize("GefBase", "Arrange"));
        this._menubar.add((JMenu)serializable2);
        serializable2.setMnemonic('A');
        jMenuItem5 = serializable2.add(new CmdGroup());
        jMenuItem5.setMnemonic('G');
        JMenuItem jMenuItem10 = serializable2.add(new CmdUngroup());
        jMenuItem10.setMnemonic('U');
        JMenuItem jMenuItem11 = new JMenu(Localizer.localize("GefBase", "Align"));
        serializable2.add(jMenuItem11);
        ((JMenu)jMenuItem11).add(new AlignAction(0));
        ((JMenu)jMenuItem11).add(new AlignAction(1));
        ((JMenu)jMenuItem11).add(new AlignAction(2));
        ((JMenu)jMenuItem11).add(new AlignAction(3));
        ((JMenu)jMenuItem11).add(new AlignAction(5));
        ((JMenu)jMenuItem11).add(new AlignAction(6));
        ((JMenu)jMenuItem11).add(new AlignAction(7));
        jMenuItem11 = new JMenu(Localizer.localize("GefBase", "Distribute"));
        serializable2.add(jMenuItem11);
        ((JMenu)jMenuItem11).add(new DistributeAction(0));
        ((JMenu)jMenuItem11).add(new DistributeAction(1));
        ((JMenu)jMenuItem11).add(new DistributeAction(4));
        ((JMenu)jMenuItem11).add(new DistributeAction(5));
        JMenuItem jMenuItem12 = new JMenu(Localizer.localize("GefBase", "Reorder"));
        serializable2.add(jMenuItem12);
        jMenuItem11 = ((JMenu)jMenuItem12).add(new CmdReorder(1));
        JMenuItem jMenuItem13 = ((JMenu)jMenuItem12).add(new CmdReorder(2));
        JMenuItem jMenuItem14 = ((JMenu)jMenuItem12).add(new CmdReorder(3));
        jMenuItem12 = ((JMenu)jMenuItem12).add(new CmdReorder(4));
        Serializable serializable3 = new JMenu(Localizer.localize("GefBase", "Nudge"));
        serializable2.add((JMenuItem)serializable3);
        serializable3.add(new NudgeAction(1));
        serializable3.add(new NudgeAction(2));
        serializable3.add(new NudgeAction(3));
        serializable3.add(new NudgeAction(4));
        serializable2 = KeyStroke.getKeyStroke(79, 2);
        serializable3 = KeyStroke.getKeyStroke(83, 2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(80, 2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(115, 8);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(90, 2);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(89, 2);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(67, 2);
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(86, 2);
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(71, 2);
        KeyStroke keyStroke9 = KeyStroke.getKeyStroke(85, 2);
        KeyStroke keyStroke10 = KeyStroke.getKeyStroke(66, 2);
        KeyStroke keyStroke11 = KeyStroke.getKeyStroke(70, 2);
        KeyStroke keyStroke12 = KeyStroke.getKeyStroke(66, 3);
        KeyStroke keyStroke13 = KeyStroke.getKeyStroke(70, 3);
        jMenuItem2.setAccelerator((KeyStroke)serializable2);
        jMenuItem3.setAccelerator((KeyStroke)serializable3);
        jMenuItem4.setAccelerator(keyStroke);
        jMenuItem.setAccelerator(keyStroke2);
        ((JMenuItem)serializable).setAccelerator(keyStroke3);
        jMenuItem6.setAccelerator(keyStroke4);
        jMenuItem7.setAccelerator(keyStroke5);
        jMenuItem8.setAccelerator(keyStroke6);
        jMenuItem9.setAccelerator(keyStroke7);
        jMenuItem5.setAccelerator(keyStroke8);
        jMenuItem10.setAccelerator(keyStroke9);
        jMenuItem11.setAccelerator(keyStroke12);
        jMenuItem13.setAccelerator(keyStroke13);
        jMenuItem14.setAccelerator(keyStroke10);
        jMenuItem12.setAccelerator(keyStroke11);
    }

    @Override
    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        if (bl2) {
            Globals.setStatusBar(this);
        }
    }

    @Override
    public void showStatus(String string) {
        if (this._statusbar != null) {
            this._statusbar.setText(string);
        }
    }
}

