/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.export;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.gef.persistence.export.FontUtility;
import org.tigris.gef.persistence.export.SvgWriter$Utf8Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public class SvgWriter
extends Graphics {
    private SvgWriter$Utf8Writer _writer;
    Document _svg;
    Element _root;
    private Color _fColor = Color.black;
    private Color _bgColor = Color.white;
    private Rectangle _drawingArea;
    private Font _font = new Font("Verdana", 0, 8);
    private Rectangle _clip;
    private int _xOffset = 0;
    private int _yOffset = 0;
    private int _hInset = 10;
    private int _vInset = 10;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private String SVGns = "http://www.w3.org/2000/svg";
    private boolean isInline = false;

    public SvgWriter(OutputStream object, Rectangle rectangle) {
        this._writer = new SvgWriter$Utf8Writer((OutputStream)object);
        this._drawingArea = rectangle;
        this.translate(this._hInset - rectangle.x, this._vInset - rectangle.y);
        object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setNamespaceAware(false);
        ((DocumentBuilderFactory)object).setValidating(false);
        object = ((DocumentBuilderFactory)object).newDocumentBuilder();
        this._svg = ((DocumentBuilder)object).newDocument();
        this._root = this._svg.createElement("svg");
        this._root.setAttribute("xmlns", this.SVGns);
        this._root.setAttribute("width", "" + (2 * this._hInset + this.scaleX(this._drawingArea.width)));
        this._root.setAttribute("height", "" + (2 * this._vInset + this.scaleY(this._drawingArea.height)));
        this._root.setAttribute("version", "1.1");
    }

    public SvgWriter(OutputStream outputStream, Rectangle rectangle, boolean bl2) {
        this(outputStream, rectangle);
        this.isInline = bl2;
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public Graphics create(int n2, int n3, int n4, int n5) {
        return this;
    }

    @Override
    public void dispose() {
        this._svg.appendChild(this._root);
        this.printDOMTree(this._svg);
        this._writer.close();
    }

    public void printDOMTree(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                if (!this.isInline) {
                    this._writer.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                    this._writer.print("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
                }
                this.printDOMTree(((Document)node).getDocumentElement());
                return;
            }
            case 1: {
                this._writer.print("<");
                this._writer.print(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                    Node node2 = namedNodeMap.item(i2);
                    this._writer.print(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() > 0) {
                    this._writer.println(">");
                    int n2 = nodeList.getLength();
                    for (int i3 = 0; i3 < n2; ++i3) {
                        this.printDOMTree(nodeList.item(i3));
                    }
                    this._writer.print("</");
                    this._writer.print(node.getNodeName());
                    this._writer.println(">");
                    return;
                }
                this._writer.println("/>");
                return;
            }
            case 5: {
                this._writer.print("&");
                this._writer.print(node.getNodeName());
                this._writer.print(";");
                return;
            }
            case 4: {
                this._writer.print("<![CDATA[");
                this._writer.print(node.getNodeValue());
                this._writer.print("]]>");
                return;
            }
            case 3: {
                String string = node.getNodeValue();
                block15: for (int i4 = 0; i4 < string.length(); ++i4) {
                    switch (string.charAt(i4)) {
                        case '&': {
                            this._writer.print("&amp;");
                            continue block15;
                        }
                        case '<': {
                            this._writer.print("&lt;");
                            continue block15;
                        }
                        case '>': {
                            this._writer.print("&gt;");
                            continue block15;
                        }
                        default: {
                            this._writer.print(string.charAt(i4));
                        }
                    }
                }
                return;
            }
            case 7: {
                this._writer.print("<?");
                this._writer.print(node.getNodeName());
                String string = node.getNodeValue();
                this._writer.print("");
                this._writer.print(string);
                this._writer.print("?>");
            }
        }
    }

    @Override
    public Color getColor() {
        return this._fColor;
    }

    private String getColorAsString() {
        return "#" + Integer.toHexString(this._fColor.getRGB()).substring(2);
    }

    @Override
    public void setColor(Color color) {
        this._fColor = color;
    }

    private Color getBackgroundColor() {
        return this._bgColor;
    }

    private String getBackgroundColorAsString() {
        return "#" + Integer.toHexString(this._bgColor.getRGB()).substring(2);
    }

    private void setBackgroundColor(Color color) {
        this._bgColor = color;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public void setFont(Font font) {
        this._font = font;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this._font);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontUtility.getFontMetrics(font);
    }

    @Override
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        return false;
    }

    private int scaleX(int n2) {
        return (int)((double)n2 * this.xScale);
    }

    private int scaleY(int n2) {
        return (int)((double)n2 * this.yScale);
    }

    private int transformX(int n2) {
        return this.scaleX(n2) + this._xOffset;
    }

    private int transformY(int n2) {
        return this.scaleY(n2) + this._yOffset;
    }

    private void drawRect(int n2, int n3, int n4, int n5, String string, String string2, String string3) {
        Element element = this._svg.createElement("rect");
        element.setAttribute("x", "" + this.transformX(n2));
        element.setAttribute("y", "" + this.transformY(n3));
        element.setAttribute("width", "" + this.scaleX(n4));
        element.setAttribute("height", "" + this.scaleY(n5));
        element.setAttribute("fill", string);
        element.setAttribute("stroke", string2);
        element.setAttribute("stroke-width", string3);
        this._root.appendChild(element);
    }

    @Override
    public void drawRect(int n2, int n3, int n4, int n5) {
        this.drawRect(n2, n3, n4, n5, "none", this.getColorAsString(), "1");
    }

    @Override
    public void fillRect(int n2, int n3, int n4, int n5) {
        this.drawRect(n2, n3, n4, n5, this.getColorAsString(), this.getColorAsString(), "1");
    }

    @Override
    public void clearRect(int n2, int n3, int n4, int n5) {
        this.drawRect(n2, n3, n4, n5, this.getBackgroundColorAsString(), this.getBackgroundColorAsString(), "1");
    }

    private void writeEllipsePath(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    private void drawOval(int n2, int n3, int n4, int n5, String string, String string2, String string3) {
        Element element = this._svg.createElement("ellipse");
        element.setAttribute("cx", "" + this.transformX(n2 + n4 / 2));
        element.setAttribute("cy", "" + this.transformY(n3 + n5 / 2));
        element.setAttribute("rx", "" + (double)this.scaleX(n4) / 2.0);
        element.setAttribute("ry", "" + (double)this.scaleY(n5) / 2.0);
        element.setAttribute("fill", string);
        element.setAttribute("stroke", string2);
        element.setAttribute("stroke-width", string3);
        this._root.appendChild(element);
    }

    @Override
    public void drawOval(int n2, int n3, int n4, int n5) {
        this.drawOval(n2, n3, n4, n5, "none", this.getColorAsString(), "1");
    }

    @Override
    public void fillOval(int n2, int n3, int n4, int n5) {
        this.drawOval(n2, n3, n4, n5, this.getColorAsString(), this.getColorAsString(), "1");
    }

    @Override
    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    private void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7, String string, String string2, String string3) {
        Element element = this._svg.createElement("rect");
        element.setAttribute("x", "" + this.transformX(n2));
        element.setAttribute("y", "" + this.transformY(n3));
        element.setAttribute("width", "" + this.scaleX(n4));
        element.setAttribute("height", "" + this.scaleY(n5));
        element.setAttribute("rx", "" + this.scaleX(n6));
        element.setAttribute("ry", "" + this.scaleY(n7));
        element.setAttribute("fill", string);
        element.setAttribute("stroke", string2);
        element.setAttribute("stroke-width", string3);
        this._root.appendChild(element);
    }

    @Override
    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawRoundRect(n2, n3, n4, n5, n6, n7, this.getBackgroundColorAsString(), this.getColorAsString(), "1");
    }

    @Override
    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawRoundRect(n2, n3, n4, n5, n6, n7, this.getColorAsString(), this.getColorAsString(), "1");
    }

    private void drawPolygon(int[] nArray, int[] nArray2, int n2, String charSequence, String string, String string2) {
        double d2 = 0.0;
        double d3 = 0.0;
        Element element = this._svg.createElement("polygon");
        element.setAttribute("fill", (String)charSequence);
        element.setAttribute("stroke", string);
        element.setAttribute("stroke-width", string2);
        charSequence = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                ((StringBuffer)charSequence).append(" ");
            }
            ((StringBuffer)charSequence).append(this.transformX(nArray[i2]) + "," + this.transformY(nArray2[i2]));
            if ((double)this.transformX(nArray[i2]) > d2) {
                d2 = this.transformX(nArray[i2]);
            }
            if (!((double)this.transformY(nArray2[i2]) > d3)) continue;
            d3 = this.transformY(nArray2[i2]);
        }
        element.setAttribute("points", ((StringBuffer)charSequence).toString());
        this._root.appendChild(element);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.drawPolygon(nArray, nArray2, n2, "none", this.getColorAsString(), "1");
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.drawPolygon(nArray, nArray2, n2, this.getColorAsString(), this.getColorAsString(), "1");
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        double d2 = 0.0;
        double d3 = 0.0;
        Element element = this._svg.createElement("polyline");
        element.setAttribute("fill", "none");
        element.setAttribute("stroke", this.getColorAsString());
        element.setAttribute("stroke-width", "1");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.transformX(nArray[i2]) + "," + this.transformY(nArray2[i2]));
            if ((double)this.transformX(nArray[i2]) > d2) {
                d2 = this.transformX(nArray[i2]);
            }
            if (!((double)this.transformY(nArray2[i2]) > d3)) continue;
            d3 = this.transformY(nArray2[i2]);
        }
        element.setAttribute("points", stringBuffer.toString());
        this._root.appendChild(element);
    }

    @Override
    public void drawLine(int n2, int n3, int n4, int n5) {
        Element element = this._svg.createElement("line");
        element.setAttribute("x1", "" + this.transformX(n2));
        element.setAttribute("y1", "" + this.transformY(n3));
        element.setAttribute("x2", "" + this.transformX(n4));
        element.setAttribute("y2", "" + this.transformY(n5));
        element.setAttribute("fill", this.getColorAsString());
        element.setAttribute("stroke", this.getColorAsString());
        element.setAttribute("stroke-width", "1");
        this._root.appendChild(element);
    }

    @Override
    public void setClip(int n2, int n3, int n4, int n5) {
        this._clip = new Rectangle(n2, n3, n4, n5);
    }

    @Override
    public void setClip(Shape shape) {
        shape = shape.getBounds();
        this.setClip(((Rectangle)shape).x, ((Rectangle)shape).y, ((Rectangle)shape).width, ((Rectangle)shape).height);
    }

    @Override
    public Rectangle getClipBounds() {
        return this._clip;
    }

    @Override
    public void clipRect(int n2, int n3, int n4, int n5) {
        if (this._clip == null) {
            this.setClip(n2, n3, n4, n5);
            return;
        }
        this._clip = this._clip.intersection(new Rectangle(n2, n3, n4, n5));
    }

    @Override
    public Shape getClip() {
        return this._clip;
    }

    @Override
    public void translate(int n2, int n3) {
        this._xOffset = n2;
        this._yOffset = n3;
    }

    public void scale(double d2, double d3) {
        this.xScale = d2;
        this.yScale = d3;
    }

    @Override
    public void drawString(String string, int n2, int n3) {
        Element element = this._svg.createElement("text");
        element.setAttribute("x", "" + this.transformX(n2));
        element.setAttribute("y", "" + this.transformY(n3));
        element.setAttribute("font-family", this._font.getFamily());
        element.setAttribute("font-size", "" + this._font.getSize());
        if (this.getFont().isBold()) {
            element.setAttribute("font-weight", "bold");
        }
        if (this.getFont().isItalic()) {
            element.setAttribute("font-style", "italic");
        }
        element.appendChild(this._svg.createTextNode(string));
        this._root.appendChild(element);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
    }

    public void drawString(CharacterIterator characterIterator, int n2, int n3) {
    }
}

