/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.AnnotationProperties;
import org.tigris.gef.presentation.Fig;

public abstract class AnnotationStrategy
implements Serializable {
    Hashtable annotations = new Hashtable();

    public Point restoreAnnotationPosition(Fig fig) {
        return new Point(1, 1);
    }

    public abstract void translateAnnotations(Fig var1);

    public abstract void storeAnnotationPosition(Fig var1);

    protected boolean lineIsVisible(Fig fig) {
        return true;
    }

    public void addAnnotation(Fig fig, Fig fig2, AnnotationProperties annotationProperties) {
        if (this.annotations.containsKey(fig2) || fig == null || fig2 == null) {
            return;
        }
        fig2.setAnnotationOwner(fig);
        this.annotations.put(fig2, annotationProperties);
    }

    public int numOfAnnotations() {
        return this.annotations.size();
    }

    public AnnotationProperties getAnnotationProperties(Fig fig) {
        return (AnnotationProperties)this.annotations.get(fig);
    }

    public Enumeration getAllAnnotations() {
        return this.annotations.keys();
    }

    public Vector getAnnotationsVector() {
        Vector vector = new Vector();
        Enumeration enumeration = this.getAllAnnotations();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public void replaceAnnotation(Fig fig, AnnotationProperties annotationProperties) {
        Fig fig2 = fig.getAnnotationOwner();
        this.annotations.remove(fig);
        this.addAnnotation(fig2, fig, annotationProperties);
    }

    public void removeAnnotation(Fig fig) {
        AnnotationProperties annotationProperties = this.getAnnotationProperties(fig);
        if (annotationProperties != null) {
            annotationProperties.removeLine();
        }
        fig.unsetAnnotationOwner();
        this.annotations.remove(fig);
    }

    public void removeAllAnnotations() {
        Enumeration enumeration = this.annotations.keys();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            this.removeAnnotation(fig);
        }
    }

    public void removeAllConnectingLines() {
        Enumeration enumeration = this.annotations.keys();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            fig = ((AnnotationProperties)this.annotations.get(fig)).getConnectingLine();
            if (!Globals.curEditor().getLayerManager().getContents().contains(fig)) continue;
            Globals.curEditor().remove(fig);
        }
    }
}

