/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.deversoft.odf.gearbox.common.domain.LanguageDDD;
import ro.deversoft.odf.gearbox.common.domain.StringWithLanguageIndication;

public class StringI18List {
    private transient Map<String, String> i18Nodes = null;
    List<StringWithLanguageIndication> itemsList;

    public StringI18List() {
        this(new ArrayList<StringWithLanguageIndication>());
    }

    public StringI18List(List<StringWithLanguageIndication> items) {
        this.itemsList = items;
        this.rebuildNodesIfNeeded();
    }

    private void rebuildNodesIfNeeded() {
        if (this.i18Nodes == null || this.i18Nodes.size() != this.itemsList.size()) {
            this.rebuildNodes();
        }
    }

    private void rebuildNodes() {
        if (this.i18Nodes == null) {
            this.i18Nodes = new HashMap<String, String>();
        }
        for (StringWithLanguageIndication item : this.itemsList) {
            this.i18Nodes.put(item.getLang().code.toUpperCase(), item.getPayload());
        }
    }

    public boolean add(StringWithLanguageIndication jsonNodeWithLanguageIndication) {
        this.rebuildNodesIfNeeded();
        boolean result = this.itemsList.add(jsonNodeWithLanguageIndication);
        if (result) {
            this.i18Nodes.put(jsonNodeWithLanguageIndication.lang.code.toUpperCase(), jsonNodeWithLanguageIndication.payload);
        }
        return result;
    }

    public StringWithLanguageIndication getValueForLang(LanguageDDD languageDDD, LanguageDDD defaultLanguage) {
        for (StringWithLanguageIndication item : this.itemsList) {
            LanguageDDD lang = item.getLang();
            String code = lang.getCode();
            if (!code.equalsIgnoreCase(languageDDD.getCode())) continue;
            return item;
        }
        for (StringWithLanguageIndication item : this.itemsList) {
            if (!item.getLang().getCode().equalsIgnoreCase(defaultLanguage.getCode())) continue;
            return item;
        }
        return null;
    }

    public String getForLang(String lang, String defaultLang) {
        this.rebuildNodesIfNeeded();
        String resultInRequestedLang = this.i18Nodes.get(lang.toUpperCase());
        if (resultInRequestedLang == null) {
            resultInRequestedLang = this.i18Nodes.get(defaultLang.toUpperCase());
        }
        return resultInRequestedLang;
    }

    public void setForLang(LanguageDDD lang, String value) {
        this.rebuildNodesIfNeeded();
        StringWithLanguageIndication toadd = new StringWithLanguageIndication(value, lang);
        this.add(toadd);
    }

    public StringI18List cloneAndPrefixForAllLanguages(String prefix) {
        Set languages = this.getItemsList().stream().map(StringWithLanguageIndication::getLang).map(LanguageDDD::getCode).collect(Collectors.toSet());
        StringI18List target = new StringI18List();
        languages.stream().forEach(k -> target.setForLang(LanguageDDD.builder().code((String)k).build(), prefix + this.getForLang((String)k, (String)k)));
        return target;
    }

    public Map<String, String> getI18Nodes() {
        return this.i18Nodes;
    }

    public List<StringWithLanguageIndication> getItemsList() {
        return this.itemsList;
    }

    public StringI18List setI18Nodes(Map<String, String> i18Nodes) {
        this.i18Nodes = i18Nodes;
        return this;
    }

    public StringI18List setItemsList(List<StringWithLanguageIndication> itemsList) {
        this.itemsList = itemsList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringI18List)) {
            return false;
        }
        StringI18List other = (StringI18List)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<StringWithLanguageIndication> this$itemsList = this.getItemsList();
        List<StringWithLanguageIndication> other$itemsList = other.getItemsList();
        return !(this$itemsList == null ? other$itemsList != null : !((Object)this$itemsList).equals(other$itemsList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringI18List;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<StringWithLanguageIndication> $itemsList = this.getItemsList();
        result = result * 59 + ($itemsList == null ? 43 : ((Object)$itemsList).hashCode());
        return result;
    }

    public String toString() {
        return "StringI18List(i18Nodes=" + this.getI18Nodes() + ", itemsList=" + this.getItemsList() + ")";
    }
}

