/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.mapstruct.AfterMapping;
import org.mapstruct.Context;
import org.mapstruct.InheritConfiguration;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import ro.deversoft.odf.gearbox.common.ODFId;
import ro.deversoft.odf.gearbox.common.ODFIdentified;

public interface CommonMapperEntityInLogicLayer<DDDBeanType, EntityType> {
    public DDDBeanType entityToDomain(EntityType var1);

    @InheritConfiguration(name="entityToDomain")
    public void entityIntoExistingDomain(EntityType var1, @MappingTarget DDDBeanType var2);

    @InheritInverseConfiguration(name="entityToDomain")
    public EntityType domainToEntity(DDDBeanType var1);

    @InheritInverseConfiguration(name="entityToDomain")
    public EntityType domainToEntityWithContext(DDDBeanType var1, @Context Object var2);

    @InheritConfiguration(name="domainToEntity")
    public void domainIntoExistingEntity(DDDBeanType var1, @MappingTarget EntityType var2);

    @InheritConfiguration(name="domainToEntity")
    @Mapping(target="id", ignore=true)
    public EntityType domainToNewEntity(DDDBeanType var1);

    default public List<DDDBeanType> listEntitiesThruMapper(Collection<EntityType> listOfEntities) {
        return listOfEntities.stream().map(this::entityToDomain).collect(Collectors.toList());
    }

    default public List<EntityType> listDDDThruMapper(Collection<DDDBeanType> listOfDDDObjects) {
        return listOfDDDObjects.stream().map(this::domainToEntity).collect(Collectors.toList());
    }

    default public Set<DDDBeanType> setEntitiesThruMapper(Collection<EntityType> setOfEntities) {
        return setOfEntities.stream().map(this::entityToDomain).collect(Collectors.toSet());
    }

    default public Set<EntityType> setDDDThruMapper(Collection<DDDBeanType> setOfDDDObjects) {
        return setOfDDDObjects.stream().map(this::domainToEntity).collect(Collectors.toSet());
    }

    @AfterMapping
    default public void nullifyRelatedEntitiesThatAriseFromNullIds(DDDBeanType domainBean, @MappingTarget EntityType entityBean) {
        this.getNullableRelatedEntitiesMappings().ifPresent(listOfMappings -> listOfMappings.stream().forEach(relatedEntityMappingConfig -> {
            Optional optIdForRelated = (Optional)((RelatedEntityConfig)relatedEntityMappingConfig).getterOfRelatedEntityId.apply(domainBean);
            if (optIdForRelated == null || !optIdForRelated.isPresent()) {
                ((RelatedEntityConfig)relatedEntityMappingConfig).setterOfNull.accept(entityBean, null);
            }
        }));
    }

    default public Optional<List<RelatedEntityConfig<DDDBeanType, EntityType>>> getNullableRelatedEntitiesMappings() {
        return Optional.empty();
    }

    public static class RelatedEntityConfig<DDDBeanType, EntityType> {
        @NonNull
        private final Function<DDDBeanType, Optional<ODFId>> getterOfRelatedEntityId;
        @NonNull
        private final BiConsumer<EntityType, ? extends ODFIdentified<?>> setterOfNull;

        public RelatedEntityConfig(@NonNull Function<DDDBeanType, Optional<ODFId>> getterOfRelatedEntityId, @NonNull BiConsumer<EntityType, ? extends ODFIdentified<?>> setterOfNull) {
            if (getterOfRelatedEntityId == null) {
                throw new NullPointerException("getterOfRelatedEntityId is marked non-null but is null");
            }
            if (setterOfNull == null) {
                throw new NullPointerException("setterOfNull is marked non-null but is null");
            }
            this.getterOfRelatedEntityId = getterOfRelatedEntityId;
            this.setterOfNull = setterOfNull;
        }
    }
}

