/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ocl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.MacroRecord;
import org.tigris.gef.ocl.TemplateRecord;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateReader
extends DefaultHandler {
    private static final TemplateReader INSTANCE = new TemplateReader();
    private static final Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$ocl$TemplateReader == null ? (class$org$tigris$gef$ocl$TemplateReader = TemplateReader.class$("org.tigris.gef.ocl.TemplateReader")) : class$org$tigris$gef$ocl$TemplateReader));
    private Hashtable _templates;
    private Vector _macros;
    private TemplateRecord _currentTemplate = null;
    private MacroRecord _currentMacro = null;
    private String filename;
    static /* synthetic */ Class class$org$tigris$gef$ocl$TemplateReader;

    protected TemplateReader() {
    }

    public static TemplateReader getInstance() {
        return INSTANCE;
    }

    public Hashtable read(String filename) throws ExpansionException {
        this.filename = filename;
        InputStream in = null;
        try {
            try {
                in = (class$org$tigris$gef$ocl$TemplateReader == null ? (class$org$tigris$gef$ocl$TemplateReader = TemplateReader.class$("org.tigris.gef.ocl.TemplateReader")) : class$org$tigris$gef$ocl$TemplateReader).getResourceAsStream(filename);
            }
            catch (Exception ex) {
                String relativePath = filename;
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                in = new FileInputStream(relativePath);
            }
            this._templates = new Hashtable();
            this._macros = new Vector();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser pc = factory.newSAXParser();
            InputSource source = new InputSource(in);
            source.setSystemId(new URL("file", null, filename).toString());
            pc.parse(source, (DefaultHandler)this);
        }
        catch (Exception ex) {
            throw new ExpansionException(ex);
        }
        return this._templates;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
        this._currentTemplate = null;
        this._currentMacro = null;
    }

    public void endDocument() {
        this._currentTemplate = null;
        this._currentMacro = null;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void startElement(String uri, String localname, String elementName, Attributes atts) throws SAXException {
        if (elementName.equals("template")) {
            String guard = atts.getValue("guard");
            String className = atts.getValue("class");
            LOG.debug((Object)("Start template guard=\"" + guard + "\" class=\"" + className + "\""));
            Class<?> classObj = null;
            Object objToStack = null;
            try {
                classObj = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new SAXException("Can't find the class " + className + " refered to in the file " + this.filename, e);
            }
            this._currentTemplate = new TemplateRecord(classObj, guard, null);
            this._currentMacro = null;
        } else if (elementName.equals("macro")) {
            String name = atts.getValue("name");
            this._currentMacro = new MacroRecord(name, null);
            this._currentTemplate = null;
        } else {
            this._currentMacro = null;
            this._currentTemplate = null;
            if (!elementName.equals("TemplateSet")) {
                throw new SAXException("unknown tag: " + elementName);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this._currentMacro != null) {
            this._currentMacro.characters(ch, start, length);
        } else if (this._currentTemplate != null) {
            this._currentTemplate.characters(ch, start, length);
        }
    }

    public void endElement(String uri, String localname, String elementName) throws SAXException {
        if (this._currentTemplate != null && elementName.equals("template")) {
            String body = this._currentTemplate.getBody().trim();
            body = this.expandMacros(body);
            this._currentTemplate.setBody(body);
            Class classObj = this._currentTemplate.getKey();
            Vector<TemplateRecord> existing = (Vector<TemplateRecord>)this._templates.get(classObj);
            if (existing == null) {
                existing = new Vector<TemplateRecord>();
            }
            existing.addElement(this._currentTemplate);
            this._templates.put(classObj, existing);
            this._currentTemplate = null;
        } else if (this._currentMacro != null && elementName.equals("macro")) {
            String body = this._currentMacro.getBody().trim();
            body = this.expandMacros(body);
            this._currentMacro.setBody(body);
            boolean inserted = false;
            int newNameLength = this._currentMacro.getName().length();
            int size = this._macros.size();
            for (int i = 0; i < size && !inserted; ++i) {
                String n = ((MacroRecord)this._macros.elementAt((int)i)).name;
                if (n.length() >= newNameLength) continue;
                this._macros.insertElementAt(this._currentMacro, i);
                inserted = true;
            }
            if (!inserted) {
                this._macros.addElement(this._currentMacro);
            }
            this._currentMacro = null;
        }
    }

    public String expandMacros(String body) {
        StringBuffer resultBuffer = new StringBuffer(body.length() * 2);
        StringTokenizer st = new StringTokenizer(body, "\n\r");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            String expanded = this.expandMacrosOnOneLine(line);
            resultBuffer.append(expanded);
            resultBuffer.append("\n");
        }
        return resultBuffer.toString();
    }

    public String expandMacrosOnOneLine(String body) {
        int numMacros = this._macros.size();
        for (int i = 0; i < numMacros; ++i) {
            String k = ((MacroRecord)this._macros.elementAt((int)i)).name;
            int findIndex = body.indexOf(k);
            if (findIndex == -1) continue;
            String mac = ((MacroRecord)this._macros.elementAt((int)i)).body;
            String prefix = body.substring(0, findIndex);
            String suffix = body.substring(findIndex + k.length());
            StringBuffer resultBuffer = new StringBuffer(mac.length() + (prefix.length() + suffix.length()) * 10);
            StringTokenizer st = new StringTokenizer(mac, "\n\r");
            while (st.hasMoreElements()) {
                resultBuffer.append(prefix);
                resultBuffer.append(st.nextToken());
                resultBuffer.append(suffix);
                if (!st.hasMoreElements()) continue;
                resultBuffer.append("\n");
            }
            return resultBuffer.toString();
        }
        return body;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

