/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.ModeCreateEdge;
import org.tigris.gef.base.ModeImpl;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;

public class ModeManager
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 3180158274454415153L;
    private Vector _modes = new Vector();
    public Editor editor;
    protected EventListenerList _listeners = new EventListenerList();
    private static Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$base$ModeManager == null ? (class$org$tigris$gef$base$ModeManager = ModeManager.class$("org.tigris.gef.base.ModeManager")) : class$org$tigris$gef$base$ModeManager));
    static /* synthetic */ Class class$org$tigris$gef$base$ModeManager;
    static /* synthetic */ Class class$org$tigris$gef$event$ModeChangeListener;

    public ModeManager(Editor ed) {
        this.editor = ed;
    }

    public void setEditor(Editor w) {
        this.editor = w;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public FigModifyingMode top() {
        if (this._modes.isEmpty()) {
            return null;
        }
        return (FigModifyingMode)this._modes.lastElement();
    }

    public void push(FigModifyingMode newMode) {
        if (!this.includes(newMode.getClass())) {
            this._modes.addElement(newMode);
        }
    }

    public FigModifyingMode pop() {
        if (this._modes.isEmpty()) {
            return null;
        }
        FigModifyingMode res = this.top();
        if (res.canExit()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing mode " + res));
            }
            this._modes.removeElement(res);
            this.fireModeChanged();
        }
        return res;
    }

    public void popAll() {
        while (!this._modes.isEmpty() && this.top().canExit()) {
            this._modes.removeElement(this.top());
        }
    }

    public boolean includes(Class modeClass) {
        Enumeration subs = this._modes.elements();
        while (subs.hasMoreElements()) {
            FigModifyingMode m = (FigModifyingMode)subs.nextElement();
            if (m.getClass() != modeClass) continue;
            return true;
        }
        return false;
    }

    public void leaveAll() {
        for (int i = this._modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.leave();
        }
    }

    public void keyTyped(KeyEvent ke) {
        this.checkModeTransitions(ke);
        for (int i = this._modes.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.keyTyped(ke);
        }
    }

    public void keyReleased(KeyEvent ke) {
        for (int i = this._modes.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.keyReleased(ke);
        }
    }

    public void keyPressed(KeyEvent ke) {
        Vector modes = (Vector)this._modes.clone();
        for (int i = modes.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)modes.get(i);
            if (!this._modes.contains(m)) continue;
            m.keyPressed(ke);
        }
    }

    public void mouseMoved(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.mouseMoved(me);
        }
    }

    public void mouseDragged(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.mouseDragged(me);
        }
    }

    public void mouseClicked(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.mouseClicked(me);
        }
    }

    public void mousePressed(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this._modes.size() - 1; i >= 0; --i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MousePressed testing mode " + this._modes.get(i).getClass().getName()));
            }
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.mousePressed(me);
        }
    }

    public void mouseReleased(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this._modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.mouseReleased(me);
        }
    }

    public void mouseEntered(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.mouseEntered(me);
        }
    }

    public void mouseExited(MouseEvent me) {
        for (int i = this._modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this._modes.get(i);
            m.mouseExited(me);
        }
    }

    public void checkModeTransitions(InputEvent ie) {
        if (!this.top().canExit() && ie.getID() == 501) {
            int y;
            MouseEvent me = (MouseEvent)ie;
            int x = me.getX();
            Fig underMouse = this.editor.hit(x, y = me.getY());
            if (underMouse instanceof FigNode && ((FigNode)underMouse).isDragConnectable()) {
                Object startPort = ((FigNode)underMouse).hitPort(x, y);
                if (startPort != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"ModeManager mousepressed detected on a draggable port");
                    }
                    ModeCreateEdge createArc = new ModeCreateEdge(this.editor);
                    this.push(createArc);
                    ((ModeImpl)createArc).mousePressed(me);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ModeManager mousepressed detected but not on a port");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ModeManager mousepressed detected but not on a port dragable node");
            }
        }
    }

    public void addModeChangeListener(ModeChangeListener listener) {
        this._listeners.add(class$org$tigris$gef$event$ModeChangeListener == null ? (class$org$tigris$gef$event$ModeChangeListener = ModeManager.class$("org.tigris.gef.event.ModeChangeListener")) : class$org$tigris$gef$event$ModeChangeListener, listener);
    }

    public void removeModeChangeListener(ModeChangeListener listener) {
        this._listeners.remove(class$org$tigris$gef$event$ModeChangeListener == null ? (class$org$tigris$gef$event$ModeChangeListener = ModeManager.class$("org.tigris.gef.event.ModeChangeListener")) : class$org$tigris$gef$event$ModeChangeListener, listener);
    }

    protected void fireModeChanged() {
        Object[] listeners = this._listeners.getListenerList();
        ModeChangeEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$tigris$gef$event$ModeChangeListener == null ? ModeManager.class$("org.tigris.gef.event.ModeChangeListener") : class$org$tigris$gef$event$ModeChangeListener)) continue;
            if (e == null) {
                e = new ModeChangeEvent(this.editor, this._modes);
            }
            ((ModeChangeListener)listeners[i + 1]).modeChange(e);
        }
    }

    public void paint(Graphics g) {
        Enumeration modes = this._modes.elements();
        while (modes.hasMoreElements()) {
            FigModifyingMode m = (FigModifyingMode)modes.nextElement();
            m.paint(g);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

