/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPort;
import org.tigris.gef.graph.presentation.NetPrimitive;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public abstract class NetEdge
extends NetPrimitive
implements GraphEdgeHooks,
Serializable {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$tigris$gef$graph$presentation$NetEdge == null ? (class$org$tigris$gef$graph$presentation$NetEdge = NetEdge.class$("org.tigris.gef.graph.presentation.NetEdge")) : class$org$tigris$gef$graph$presentation$NetEdge));
    protected NetPort _sourcePort;
    protected NetPort _destPort;
    protected Vector _ports;
    static /* synthetic */ Class class$org$tigris$gef$graph$presentation$NetEdge;

    public void setSourcePort(NetPort s) {
        this._sourcePort = s;
    }

    public NetPort getSourcePort() {
        return this._sourcePort;
    }

    public void setDestPort(NetPort d) {
        this._destPort = d;
    }

    public NetPort getDestPort() {
        return this._destPort;
    }

    public NetPort otherEnd(NetPort oneEnd) {
        NetPort sp = this.getSourcePort();
        if (sp == oneEnd) {
            return this.getDestPort();
        }
        return sp;
    }

    public Vector getPorts() {
        return this._ports;
    }

    public void setPorts(Vector v) {
        this._ports = v;
    }

    public boolean connect(GraphModel gm, Object srcPort, Object destPort) {
        NetPort srcNetPort = (NetPort)srcPort;
        NetPort destNetPort = (NetPort)destPort;
        if (!srcNetPort.canConnectTo(gm, destPort)) {
            return false;
        }
        if (!destNetPort.canConnectTo(gm, srcPort)) {
            return false;
        }
        this.setSourcePort(srcNetPort);
        this.setDestPort(destNetPort);
        srcNetPort.addEdge(this);
        destNetPort.addEdge(this);
        srcNetPort.postConnect(gm, destPort);
        destNetPort.postConnect(gm, srcPort);
        return true;
    }

    public void deleteFromModel() {
        LOG.debug((Object)"Deleting from model");
        if (this.getSourcePort() != null && this.getDestPort() != null) {
            this._sourcePort.removeEdge(this);
            this._destPort.removeEdge(this);
            DefaultGraphModel gm = (DefaultGraphModel)Globals.curEditor().getGraphModel();
            gm.removeEdge(this);
            this._sourcePort.postDisconnect(gm, this.getDestPort());
            this._destPort.postDisconnect(gm, this.getSourcePort());
            this.firePropertyChange("disposed", false, true);
        }
    }

    public FigEdge presentationFor(Layer lay) {
        FigEdge fe;
        if (lay != null && (fe = (FigEdge)lay.presentationFor(this)) != null) {
            return fe;
        }
        NetNode sourceNode = this._sourcePort.getParentNode();
        NetNode destNode = this._destPort.getParentNode();
        FigNode sourceFigNode = sourceNode.presentationFor(lay);
        FigNode destFigNode = destNode.presentationFor(lay);
        Fig sourcePortFig = sourceFigNode.getPortFig(this._sourcePort);
        Fig destPortFig = destFigNode.getPortFig(this._destPort);
        fe = this.makePresentation(lay);
        fe.setSourcePortFig(sourcePortFig);
        fe.setDestPortFig(destPortFig);
        fe.setSourceFigNode(sourceFigNode);
        fe.setDestFigNode(destFigNode);
        fe.setOwner(this);
        return fe;
    }

    public abstract FigEdge makePresentation(Layer var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

