/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.tests;

import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class XOMTestCase
extends TestCase {
    public XOMTestCase(String name) {
        super(name);
    }

    public static void assertEquals(Text expected, Text actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Text expected, Text actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals((String)message, (String)expected.getValue(), (String)actual.getValue());
    }

    private static void nullCheck(String message, Node expected, Node actual) {
        if (expected == null) {
            throw new ComparisonFailure(message, null, actual.toXML());
        }
        if (actual == null) {
            throw new ComparisonFailure(message, expected.toXML(), null);
        }
    }

    public static void assertEquals(Attribute expected, Attribute actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Attribute expected, Attribute actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        String value1 = expected.getValue();
        String value2 = actual.getValue();
        if ("xml:base".equals(expected.getQualifiedName())) {
            if (value1.equals(value2)) {
                return;
            }
            if (value1.startsWith("../")) {
                XOMTestCase.assertTrue((String)message, (boolean)value2.endsWith(value1.substring(2)));
            } else {
                XOMTestCase.assertTrue((String)message, (value1.endsWith(String.valueOf('/') + value2) || value2.endsWith(String.valueOf('/') + value1) ? 1 : 0) != 0);
            }
        } else {
            XOMTestCase.assertEquals((String)message, (String)value1, (String)value2);
            XOMTestCase.assertEquals((String)message, (String)expected.getLocalName(), (String)actual.getLocalName());
            XOMTestCase.assertEquals((String)message, (String)expected.getQualifiedName(), (String)actual.getQualifiedName());
            XOMTestCase.assertEquals((String)message, (String)expected.getNamespaceURI(), (String)actual.getNamespaceURI());
        }
    }

    public static void assertEquals(DocType expected, DocType actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, DocType expected, DocType actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals((String)message, (String)expected.getPublicID(), (String)actual.getPublicID());
        XOMTestCase.assertEquals((String)message, (String)expected.getSystemID(), (String)actual.getSystemID());
        XOMTestCase.assertEquals((String)message, (String)expected.getRootElementName(), (String)actual.getRootElementName());
    }

    public static void assertEquals(Element expected, Element actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Element expected, Element actual) {
        String uri1;
        String prefix1;
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals((String)message, (String)expected.getLocalName(), (String)actual.getLocalName());
        XOMTestCase.assertEquals((String)message, (String)expected.getNamespacePrefix(), (String)actual.getNamespacePrefix());
        XOMTestCase.assertEquals((String)message, (String)expected.getNamespaceURI(), (String)actual.getNamespaceURI());
        XOMTestCase.assertEquals((String)message, (int)expected.getAttributeCount(), (int)actual.getAttributeCount());
        int i = 0;
        while (i < expected.getAttributeCount()) {
            Attribute att1 = expected.getAttribute(i);
            Attribute att2 = actual.getAttribute(att1.getLocalName(), att1.getNamespaceURI());
            XOMTestCase.assertNotNull((String)message, (Object)att2);
            XOMTestCase.assertEquals(message, att1, att2);
            ++i;
        }
        i = 0;
        while (i < expected.getNamespaceDeclarationCount()) {
            prefix1 = expected.getNamespacePrefix(i);
            uri1 = expected.getNamespaceURI(prefix1);
            XOMTestCase.assertNotNull((String)message, (Object)actual.getNamespaceURI(prefix1));
            XOMTestCase.assertEquals((String)message, (String)uri1, (String)actual.getNamespaceURI(prefix1));
            ++i;
        }
        i = 0;
        while (i < actual.getNamespaceDeclarationCount()) {
            prefix1 = actual.getNamespacePrefix(i);
            uri1 = actual.getNamespaceURI(prefix1);
            XOMTestCase.assertNotNull((String)message, (Object)expected.getNamespaceURI(prefix1));
            XOMTestCase.assertEquals((String)message, (String)uri1, (String)expected.getNamespaceURI(prefix1));
            ++i;
        }
        XOMTestCase.compareChildren(message, expected, actual);
    }

    private static boolean hasAdjacentTextNodes(Element element) {
        boolean previousWasText = false;
        int count = element.getChildCount();
        int i = 0;
        while (i < count) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                if (previousWasText) {
                    return true;
                }
                previousWasText = true;
            } else {
                previousWasText = false;
            }
            ++i;
        }
        return false;
    }

    private static void compareChildren(String message, Element expected, Element actual) {
        Element expectedCopy = expected;
        Element actualCopy = actual;
        if (XOMTestCase.hasAdjacentTextNodes(expected)) {
            expectedCopy = XOMTestCase.combineTextNodes(expected);
        }
        if (XOMTestCase.hasAdjacentTextNodes(actual)) {
            actualCopy = XOMTestCase.combineTextNodes(actual);
        }
        int count = expectedCopy.getChildCount();
        XOMTestCase.assertEquals((String)message, (int)count, (int)actualCopy.getChildCount());
        int nonTextNodes = count;
        int i = 0;
        while (i < count) {
            Node child1 = expectedCopy.getChild(i);
            if (child1 instanceof Text) {
                --nonTextNodes;
                Node child2 = actualCopy.getChild(i);
                XOMTestCase.assertEquals(message, child1, child2);
            }
            ++i;
        }
        i = 0;
        while (i < nonTextNodes) {
            Node expectedChild = XOMTestCase.getNonTextNode(expected, i);
            Node actualChild = XOMTestCase.getNonTextNode(actual, i);
            XOMTestCase.assertEquals(message, expectedChild, actualChild);
            ++i;
        }
    }

    private static Node getNonTextNode(Element element, int index) {
        int nonTextCount = 0;
        int count = element.getChildCount();
        int i = 0;
        while (i < count) {
            Node child = element.getChild(i);
            if (!(child instanceof Text)) {
                if (nonTextCount == index) {
                    return child;
                }
                ++nonTextCount;
            }
            ++i;
        }
        throw new RuntimeException("Bug in XOMTestCase: this statement should not be reachable");
    }

    private static Element combineTextNodes(Element element) {
        Element stub = new Element("a");
        Comment stubc = new Comment("c");
        StringBuffer sb = new StringBuffer();
        int count = element.getChildCount();
        int i = 0;
        while (i < count) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                sb.setLength(0);
                do {
                    sb.append(child.getValue());
                } while (++i != count && (child = element.getChild(i)) instanceof Text);
                --i;
                stub.appendChild(sb.toString());
            } else {
                stub.appendChild(stubc.copy());
            }
            ++i;
        }
        return stub;
    }

    public static void assertEquals(Document expected, Document actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Document expected, Document actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals((String)message, (int)expected.getChildCount(), (int)actual.getChildCount());
        int i = 0;
        while (i < actual.getChildCount()) {
            Node child1 = expected.getChild(i);
            Node child2 = actual.getChild(i);
            XOMTestCase.assertEquals(message, child1, child2);
            ++i;
        }
    }

    public static void assertEquals(Comment expected, Comment actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Comment expected, Comment actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals((String)message, (String)expected.getValue(), (String)actual.getValue());
    }

    public static void assertEquals(ProcessingInstruction expected, ProcessingInstruction actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, ProcessingInstruction expected, ProcessingInstruction actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals((String)message, (String)expected.getValue(), (String)actual.getValue());
        XOMTestCase.assertEquals((String)message, (String)expected.getTarget(), (String)actual.getTarget());
    }

    public static void assertEquals(String message, Namespace expected, Namespace actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals((String)message, (String)expected.getValue(), (String)actual.getValue());
        XOMTestCase.assertEquals((String)message, (String)expected.getPrefix(), (String)actual.getPrefix());
    }

    public static void assertEquals(Node expected, Node actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Node expected, Node actual) {
        block11: {
            if (actual == expected) {
                return;
            }
            XOMTestCase.nullCheck(message, expected, actual);
            try {
                if (expected instanceof Document) {
                    XOMTestCase.assertEquals(message, (Document)expected, (Document)actual);
                    break block11;
                }
                if (expected instanceof Element) {
                    XOMTestCase.assertEquals(message, (Element)expected, (Element)actual);
                    break block11;
                }
                if (expected instanceof Text) {
                    XOMTestCase.assertEquals(message, (Text)expected, (Text)actual);
                    break block11;
                }
                if (expected instanceof DocType) {
                    XOMTestCase.assertEquals(message, (DocType)expected, (DocType)actual);
                    break block11;
                }
                if (expected instanceof Comment) {
                    XOMTestCase.assertEquals(message, (Comment)expected, (Comment)actual);
                    break block11;
                }
                if (expected instanceof ProcessingInstruction) {
                    XOMTestCase.assertEquals(message, (ProcessingInstruction)expected, (ProcessingInstruction)actual);
                    break block11;
                }
                if (expected instanceof Attribute) {
                    XOMTestCase.assertEquals(message, (Attribute)expected, (Attribute)actual);
                    break block11;
                }
                if (expected instanceof Namespace) {
                    XOMTestCase.assertEquals(message, (Namespace)expected, (Namespace)actual);
                    break block11;
                }
                throw new IllegalArgumentException("Unexpected node type " + expected.getClass().getName());
            }
            catch (ClassCastException ex) {
                throw new ComparisonFailure(String.valueOf(message) + "; Mismatched node types: " + expected.getClass().getName() + " != " + actual.getClass().getName(), expected.toXML(), actual.toXML());
            }
        }
    }
}

