/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.integrations.erp.soft1.nextitsol.vatra;

import com.google.gson.reflect.TypeToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.andreinc.aleph.AlephFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.deversoft.integrations.erp.ErpIterface;
import ro.deversoft.integrations.erp.api.domain.Article;
import ro.deversoft.integrations.erp.api.domain.ArticlePriceQtyBean;
import ro.deversoft.integrations.erp.api.domain.CURRENCY;
import ro.deversoft.integrations.erp.api.domain.Customer;
import ro.deversoft.integrations.erp.api.domain.Order;
import ro.deversoft.integrations.erp.api.domain.OrderType;
import ro.deversoft.integrations.erp.api.domain.Payment;
import ro.deversoft.integrations.erp.api.domain.Sale;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.GenericClientsPerRevenueCode;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.MonetaryCodeBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.SeriesPerRevenueCode;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.Soft1PaymentTypeEnum;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.Soft1RONextItSolConfig;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.Utils;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.GetArticlesRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.GetArticlesRequestQBS;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.GetCountriesRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.GetDistrictsRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.GetTvaRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.GetUMRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.LoginRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.SessionInitRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.customers.AddCustomerRequestBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.customers.AddCustomerRequestWrapperDTO;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.customers.AddCustomerResponseDTO;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.customers.GetClientsRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.monetary.MonetaryData;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.monetary.MonetaryDoc;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.monetary.MonetaryItem;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.monetary.PushMonetaryRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.sales.PushSalesRequest;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.sales.SalDoc;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.sales.SaleData;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.request.sales.SaleItem;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.ArticleResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.ArticleResponseBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.ClientResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.ClientResponseBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.CountriesResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.CountryResponseBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.DistrictResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.DistrictResponseBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.LoginResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.PushMonetaryResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.PushSaleResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.QBS.ArticleResponseQBS;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.SessionInitResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.TVAResponse;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.TVAResponseBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.UMBean;
import ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto.response.UMResponse;

public class Soft1RONextItSolLogic
implements ErpIterface {
    private static final Logger log = LoggerFactory.getLogger(Soft1RONextItSolLogic.class);
    public static final SimpleDateFormat MONETARY_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS");
    public static final String WILD_CARD = "*";
    Soft1RONextItSolConfig config;
    Map<String, ClientResponseBean> customerDTOMap = new ConcurrentHashMap<String, ClientResponseBean>();
    Map<String, ArticleResponseBean> articleDTOMap = new ConcurrentHashMap<String, ArticleResponseBean>();
    Map<String, TVAResponseBean> tvaDTOMap = new ConcurrentHashMap<String, TVAResponseBean>();
    Map<String, UMBean> umDTOMap = new ConcurrentHashMap<String, UMBean>();
    Map<String, DistrictResponseBean> districtsDTOMap = new ConcurrentHashMap<String, DistrictResponseBean>();
    Map<String, CountryResponseBean> countriesDTOMap = new ConcurrentHashMap<String, CountryResponseBean>();
    String loginClientId;
    LoginResponse loginResponse;
    Map<String, String> clientIdPerRevenueCode = new HashMap<String, String>();

    public static final void main(String[] args) {
        try {
            String configFileCONTENT = Utils.buildStringFromInputStreamNpoGZIP(new FileInputStream(args[0]));
            Soft1RONextItSolLogic soft1RONextItSolLogic = new Soft1RONextItSolLogic();
            soft1RONextItSolLogic.init(configFileCONTENT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init(String configFileCONTENT) {
        this.config = (Soft1RONextItSolConfig)Utils.loadFromJsonString(configFileCONTENT, Soft1RONextItSolConfig.class, null);
    }

    @Override
    public void initializeGlobalSession() throws IOException {
        this.login();
    }

    @Override
    public boolean pushOrders(String revenueCode, List<Order> orders, List<String> errors) throws IOException {
        this.initializeSessionPrivate(revenueCode);
        boolean b = this.pushOrdersInternal(orders, errors, revenueCode);
        return b;
    }

    @Override
    public void initializeSessionPublic(String revenueCode) throws IOException {
        this.initializeSessionPrivate(revenueCode);
    }

    @Override
    public void checkAndPushCustomers(String revenueCode, Set<Customer> requiredCustomers, Set<Customer> successfullyAddedCustomers, Set<Customer> notAddedBecauseOfErrors) throws IOException {
        this.initializeSessionPrivate(revenueCode);
        LinkedHashSet<Customer> toAddSet = new LinkedHashSet<Customer>();
        for (Customer requiredCustomer : requiredCustomers) {
            if (requiredCustomer.getExternalKey() != null && requiredCustomer.getExternalKey().trim().length() != 0) continue;
            toAddSet.add(requiredCustomer);
        }
        if (toAddSet != null) {
            for (Customer toAdd : toAddSet) {
                AddCustomerResponseDTO addCustomerResponse = this.addCustomerToSoft1(toAdd, revenueCode);
                if (addCustomerResponse != null && addCustomerResponse.isSuccess()) {
                    toAdd.setExternalKey(addCustomerResponse.getId());
                    successfullyAddedCustomers.add(toAdd);
                    continue;
                }
                notAddedBecauseOfErrors.add(toAdd);
            }
        }
    }

    private boolean pushOrdersInternal(List<Order> orders, List<String> errors, String revenueCode) throws IOException {
        boolean pushSales = this.pushSales(orders, errors, revenueCode);
        boolean pushMonetary = this.pushPayments(orders, errors, revenueCode);
        return pushSales && pushMonetary;
    }

    private boolean pushSales(List<Order> orders, List<String> errors, String revenueCodeAllowed) throws IOException {
        Map<String, List> ordersGroupedForSaleExport = Collections.synchronizedMap(new LinkedHashMap());
        HashMap<String, String> shortFormatByLongFormatMap = new HashMap<String, String>();
        for (Order order : orders) {
            String groupKeyString = AlephFormatter.str((String)this.config.getOrderGroupingKeyLabelFormat()).args(order.getGroupingKeyValues()).fmt();
            groupKeyString = groupKeyString + "_OrderType:" + order.getOrderType().name();
            groupKeyString = groupKeyString + "_Customer:" + (order.getCustomer() != null ? order.getCustomer().buildKey() : "null");
            List orderListForThisGroupingKey = ordersGroupedForSaleExport.getOrDefault(groupKeyString, new ArrayList());
            orderListForThisGroupingKey.add(order);
            ordersGroupedForSaleExport.put(groupKeyString, orderListForThisGroupingKey);
            String groupKeyStringShort = AlephFormatter.str((String)this.config.getOrderGroupingKeyLabelFormatShort()).args(order.getGroupingKeyValues()).fmt();
            groupKeyStringShort = groupKeyStringShort + "_" + order.getOrderType().getShortCode();
            if (order.getCustomer() != null) {
                groupKeyStringShort = groupKeyStringShort + "_" + order.getCustomer().getExternalKey();
            }
            shortFormatByLongFormatMap.put(groupKeyString, groupKeyStringShort);
        }
        Map<String, SalDoc> headersGrouped = Collections.synchronizedMap(new LinkedHashMap());
        for (String groupingKey : ordersGroupedForSaleExport.keySet()) {
            List orderList = (List)ordersGroupedForSaleExport.get(groupingKey);
            Order order = (Order)orderList.get(0);
            List noInvoicesOrders = orderList.stream().filter(k -> k.getOrderType() != OrderType.INVOICE_FISCAL_RECEIPT).collect(Collectors.toList());
            String revenueCode = order.getRevenueCode();
            if (!revenueCode.equalsIgnoreCase(revenueCodeAllowed)) continue;
            Object seriesPerRevenueCode = this.config.salesSeriesPerRevenueCode.get(revenueCode);
            if (seriesPerRevenueCode == null) {
                seriesPerRevenueCode = this.config.salesSeriesPerRevenueCode.get(WILD_CARD);
            }
            String series = "";
            switch (order.getOrderType()) {
                case CIF_FISCAL_RECEIPT: {
                    series = ((SeriesPerRevenueCode)seriesPerRevenueCode).getGenericClientFiscalReceiptWithCuiSerie();
                    break;
                }
                case PLAIN_FISCAL_RECEIPT: {
                    series = ((SeriesPerRevenueCode)seriesPerRevenueCode).getGenericClientFiscalReceiptOnlySerie();
                    break;
                }
                case INVOICE_FISCAL_RECEIPT: {
                    series = ((SeriesPerRevenueCode)seriesPerRevenueCode).getGenericClientFiscalReceiptWithInvoiceSerie();
                    break;
                }
            }
            Iterator<Sale> customerCode = this.getCustomerCode(order, revenueCode);
            String docNameShort = (String)shortFormatByLongFormatMap.get(groupingKey);
            SalDoc salDoc = SalDoc.builder().setSERIES(series).setFINCODE(docNameShort).setCOMMENTS(groupingKey).setTRDR((String)((Object)customerCode)).setGSISQTY(noInvoicesOrders.size()).build();
            headersGrouped.put(groupingKey, salDoc);
        }
        String string = "#{mtrl}_#{price}_#{whouse}";
        for (String groupingKey : ordersGroupedForSaleExport.keySet()) {
            LinkedHashMap<String, SaleItem> saleItemGrouped = new LinkedHashMap<String, SaleItem>();
            List ordersForThisGroupingKey = (List)ordersGroupedForSaleExport.get(groupingKey);
            Double totalVz1 = 0.0;
            for (Order order : ordersForThisGroupingKey) {
                for (Sale s : order.getSales()) {
                    totalVz1 = totalVz1 + s.getQty() * s.getPrice();
                    totalVz1 = Soft1RONextItSolLogic.roundDoubleUp(totalVz1, 2);
                }
            }
            System.out.println("SOFT1 : total1 pt document " + groupingKey + " : " + totalVz1);
            for (Order order : ordersForThisGroupingKey) {
                for (Sale sale : order.getSales()) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("mtrl", sale.getArticle().getExternalCode());
                    double price = Soft1RONextItSolLogic.roundDoubleUp(sale.getPrice(), 2);
                    params.put("price", price + "");
                    params.put("whouse", sale.getLocalWarehouse());
                    String key = AlephFormatter.str((String)"#{mtrl}_#{price}_#{whouse}").args(params).fmt();
                    SaleItem existing = saleItemGrouped.getOrDefault(key, SaleItem.builder().setMTRL(sale.getArticle().getExternalCode()).setPRICE(price + "").setQTY1("0").setWHOUSE(sale.getLocalWarehouse()).build());
                    double newQty = Soft1RONextItSolLogic.roundDoubleUp(Double.parseDouble(existing.getQTY1()) + sale.getQty(), 3);
                    existing.setQTY1(newQty + "");
                    saleItemGrouped.put(key, existing);
                }
            }
            SaleData saleData = SaleData.builder().build();
            saleData.getITELINES().addAll(saleItemGrouped.values());
            Double total2 = saleData.getITELINES().stream().collect(Collectors.summingDouble(i -> Double.valueOf(i.getPRICE()) * Double.valueOf(i.getQTY1())));
            System.out.println("SOFT1 : total2 (saleData) pt document " + groupingKey + " : " + total2);
            SalDoc salDoc = (SalDoc)headersGrouped.get(groupingKey);
            saleData.getSALDOC().add(salDoc);
            PushSalesRequest toPush = PushSalesRequest.builder().setAPPID(this.config.getAppId()).setCLIENTID(this.clientIdPerRevenueCode.get(revenueCodeAllowed)).setDATA(saleData).build();
            System.out.println("SOFT1 : SEND SALES");
            StringBuffer resultSB = new StringBuffer();
            boolean salePushOK = Utils.postJsonObjectAsApplicationJson(toPush, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
            if (!salePushOK) continue;
            String text = resultSB.toString();
            PushSaleResponse response = (PushSaleResponse)Utils.loadFromJsonString(text = this.fixResponse(text), PushSaleResponse.class, this.config.dateFormat);
            if (response.isSuccess()) {
                System.out.println("SOFT1: SALES EXPORT SUCCESS : Push for groupingKey " + groupingKey + " : OK ");
                continue;
            }
            String x = "SOFT1 : SALES EXPORT FATAL : Push for groupingKey " + groupingKey + " : ERROR  : " + response.toString();
            errors.add(x);
            System.out.println(x);
            return false;
        }
        return true;
    }

    private boolean pushPayments(List<Order> orders, List<String> errors, String revenueCodeAllowed) throws IOException {
        Map<Object, List> ordersGroupedForPaymentsExport = Collections.synchronizedMap(new LinkedHashMap());
        for (Order order : orders) {
            Object groupKeyString = AlephFormatter.str((String)this.config.getPaymentGroupingKeyLabelFormat()).args(order.getGroupingKeyValues()).fmt();
            groupKeyString = (String)groupKeyString + "_OrderType:" + order.getOrderType().name();
            groupKeyString = (String)groupKeyString + "_Customer:" + (order.getCustomer() != null ? order.getCustomer().buildKey() : "null");
            List orderListForThisGroupingKey = ordersGroupedForPaymentsExport.getOrDefault(groupKeyString, new ArrayList());
            orderListForThisGroupingKey.add(order);
            ordersGroupedForPaymentsExport.put(groupKeyString, orderListForThisGroupingKey);
        }
        String ron = this.config.currencies.get((Object)CURRENCY.RON);
        Map<String, MonetaryDoc> headersGrouped = Collections.synchronizedMap(new LinkedHashMap());
        for (String groupingKey : ordersGroupedForPaymentsExport.keySet()) {
            List orderList = (List)ordersGroupedForPaymentsExport.get(groupingKey);
            Order order = (Order)orderList.get(0);
            String revenueCode = order.getRevenueCode();
            if (!revenueCode.equalsIgnoreCase(revenueCodeAllowed)) continue;
            SeriesPerRevenueCode seriesPerRevenueCode = this.config.monetarySeriesPerRevenueCode.get(revenueCode);
            if (seriesPerRevenueCode == null) {
                seriesPerRevenueCode = this.config.monetarySeriesPerRevenueCode.get(WILD_CARD);
            }
            Object series = "";
            switch (order.getOrderType()) {
                case CIF_FISCAL_RECEIPT: {
                    series = seriesPerRevenueCode.getGenericClientFiscalReceiptWithCuiSerie();
                    break;
                }
                case PLAIN_FISCAL_RECEIPT: {
                    series = seriesPerRevenueCode.getGenericClientFiscalReceiptOnlySerie();
                    break;
                }
                case INVOICE_FISCAL_RECEIPT: {
                    series = seriesPerRevenueCode.getGenericClientFiscalReceiptWithInvoiceSerie();
                    break;
                }
            }
            String customerCode = this.getCustomerCode(order, revenueCode);
            Date datazD = (Date)order.getGroupingKeyValues().get("datazDate");
            String dataS = MONETARY_DATE_FORMAT.format(datazD);
            MonetaryDoc salDoc = MonetaryDoc.builder().setSeries((String)series).setBranch(this.config.getBranchesPerRevenueCode().get(revenueCode)).setTrdr(customerCode).setTrndate(dataS).setSocurrency(ron).build();
            headersGrouped.put(groupingKey, salDoc);
        }
        HashMap<String, Object> valuesPaidByPaymentTypeAndOrderGroupingKey = new HashMap<String, Object>();
        for (String groupingKey : ordersGroupedForPaymentsExport.keySet()) {
            List ordersForThisGroupingKey = (List)ordersGroupedForPaymentsExport.get(groupingKey);
            for (Order order : ordersForThisGroupingKey) {
                for (Payment payment : order.getPayments()) {
                    Map perGroupingKeyMap = valuesPaidByPaymentTypeAndOrderGroupingKey.getOrDefault(groupingKey, new HashMap());
                    valuesPaidByPaymentTypeAndOrderGroupingKey.put(groupingKey, perGroupingKeyMap);
                    Double currentValue = perGroupingKeyMap.getOrDefault(payment.getPaymentType(), 0.0);
                    currentValue = currentValue + payment.getValue();
                    currentValue = Soft1RONextItSolLogic.roundDoubleUp(currentValue, 2);
                    perGroupingKeyMap.put(payment.getPaymentType(), currentValue);
                }
            }
        }
        for (String groupingKey : ordersGroupedForPaymentsExport.keySet()) {
            MonetaryData monetaryData = MonetaryData.builder().build();
            List ordersForThisGroupingKey = (List)ordersGroupedForPaymentsExport.get(groupingKey);
            Order firstOrder = (Order)ordersForThisGroupingKey.get(0);
            String revenueCode = firstOrder.getRevenueCode();
            Map paymentsAccumulated = (Map)valuesPaidByPaymentTypeAndOrderGroupingKey.get(groupingKey);
            for (String paymentTypeName : paymentsAccumulated.keySet()) {
                Map<String, Map<String, MonetaryCodeBean>> monetaryCodesPerRevenueCode = this.config.getMonetaryCodesPerRevenueCode();
                String configurationKey = "monetaryCodesPerRevenueCode.";
                Map<String, MonetaryCodeBean> codeBeansByRevenueCode = monetaryCodesPerRevenueCode.get(revenueCode);
                if (codeBeansByRevenueCode == null) {
                    codeBeansByRevenueCode = monetaryCodesPerRevenueCode.get(WILD_CARD);
                    configurationKey = configurationKey + WILD_CARD;
                } else {
                    configurationKey = configurationKey + revenueCode;
                }
                MonetaryCodeBean monetaryCodeBean = codeBeansByRevenueCode.get(paymentTypeName);
                if (monetaryCodeBean != null) {
                    Soft1PaymentTypeEnum soft1PaymentType = monetaryCodeBean.getSoft1PaymentType();
                    String beanTrdr = monetaryCodeBean.getTrdr();
                    MonetaryItem build = MonetaryItem.builder().setTrdr(beanTrdr).setLineval((Double)paymentsAccumulated.get(paymentTypeName)).setSocurrency(ron).build();
                    switch (soft1PaymentType) {
                        case Cash: {
                            monetaryData.getCashLines().add(build);
                            break;
                        }
                        case Card: {
                            build.setCreditCards("1000");
                            monetaryData.getCardLines().add(build);
                            break;
                        }
                        case Voucher: {
                            monetaryData.getVoucherLines().add(build);
                            break;
                        }
                        case Cheque: {
                            monetaryData.getChequeLines().add(build);
                            break;
                        }
                    }
                    continue;
                }
                String e = "SOFT1 : Configuration key " + configurationKey + " Payment type " + paymentTypeName + " is missing !!";
                System.err.println(e);
                errors.add(e);
            }
            MonetaryDoc monetaryHeader = (MonetaryDoc)headersGrouped.get(groupingKey);
            monetaryData.getCfncusDoc().add(monetaryHeader);
            PushMonetaryRequest monetaryRequest = PushMonetaryRequest.builder().setAppId(this.config.getAppId()).setClientId(this.clientIdPerRevenueCode.get(revenueCodeAllowed)).setData(monetaryData).build();
            StringBuffer resultSB = new StringBuffer();
            System.out.println("SOFT1 : SEND MONETARY");
            boolean monetaryPushOK = Utils.postJsonObjectAsApplicationJson(monetaryRequest, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
            if (!monetaryPushOK) continue;
            String text = resultSB.toString();
            PushMonetaryResponse response = (PushMonetaryResponse)Utils.loadFromJsonString(text = this.fixResponse(text), PushMonetaryResponse.class, this.config.dateFormat);
            if (response.isSuccess()) {
                System.out.println("SOFT1 : Push for groupingKey " + groupingKey + " : OK ");
                continue;
            }
            String x = "SOFT1 : FATAL : Push for groupingKey " + groupingKey + " : ERROR  : " + response.toString();
            errors.add(x);
            System.out.println(x);
            return false;
        }
        return true;
    }

    private boolean refreshCustomersFromSoft1(String sessionClientId) throws IOException {
        GetClientsRequest clientsRequest = GetClientsRequest.builder().setAppId(this.config.getAppId()).setClientID(sessionClientId).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : READ CUSTOMERS");
        boolean ok = Utils.postJsonObjectAsApplicationJson(clientsRequest, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok) {
            Type t = new TypeToken<ClientResponse>(){}.getType();
            String text = resultSB.toString();
            ClientResponse remoteClients = (ClientResponse)Utils.loadFromJsonString(text, t, this.config.dateFormat);
            if (remoteClients.isSuccess()) {
                remoteClients.getData().stream().forEach(k -> this.customerDTOMap.put(k.buildKey(), (ClientResponseBean)k));
                return true;
            }
        }
        return false;
    }

    private AddCustomerRequestBean mapCustomerToAddRequestDTO(Customer source) {
        String countryCode = source.getCountryCode();
        CountryResponseBean countryResponseBean = this.countriesDTOMap.get(countryCode);
        boolean ro = countryCode.equalsIgnoreCase("RO");
        String cmpMode = source.isCompany() ? (ro ? "501" : "502") : "11";
        System.out.println("Mapping customer  to addRequestBean : " + source.toString());
        String countyCodeNormalized = source.getCountyCode();
        log.trace("LOG country Code #1 {}", (Object)countyCodeNormalized);
        System.out.println("MAP #1 " + countyCodeNormalized);
        if (countyCodeNormalized == null) {
            countyCodeNormalized = "RO-IF";
            log.trace("MAP #1 LOG country Code was null, set to RO-B");
            System.out.println("MAP #1 LOG country Code was null, set to RO-B");
        }
        String countyCodeNoROPrefix = countyCodeNormalized.replace("RO-", "");
        log.trace("LOG country Code #2 {}", (Object)countyCodeNoROPrefix);
        System.out.println("MAP #2 " + countyCodeNoROPrefix);
        DistrictResponseBean districtResponseBean = this.districtsDTOMap.get(countyCodeNoROPrefix);
        log.trace("LOG country Code #3 bean : {}", (Object)districtResponseBean);
        System.out.println("MAP #3 " + districtResponseBean);
        String districtID = districtResponseBean.getDISTRICT_DISTRICT();
        log.trace("LOG country Code #4 id : {}", (Object)districtID);
        System.out.println("MAP #4 " + districtID);
        AddCustomerRequestBean addCustomerRequest = AddCustomerRequestBean.builder().setNAME(source.getName()).setAFM(source.isCompany() ? source.getNationalId() : "").setCITY(source.getCity()).setDISTRICT(districtID).setDISTRICT1("").setADDRESS(source.getAddress()).setCOUNTRY(countryResponseBean.getCountry()).setTRDCATEGORY(source.isCompany() ? "3000" : "3004").setCMPMODE(cmpMode).setBGBULSTAT(source.isCompany() && ro && source.isVat() ? "RO" : "").build();
        return addCustomerRequest;
    }

    private AddCustomerResponseDTO addCustomerToSoft1(Customer toAdd, String revenueCode) throws IOException {
        AddCustomerRequestBean addCustomerRequestDTO = this.mapCustomerToAddRequestDTO(toAdd);
        String clientID = this.clientIdPerRevenueCode.get(revenueCode);
        AddCustomerRequestWrapperDTO wrapperDTO = AddCustomerRequestWrapperDTO.builder().setAppId(this.config.getAppId()).setClientId(clientID).build();
        wrapperDTO.setCustomer(addCustomerRequestDTO);
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : ADD CUSTOMER");
        boolean ok = Utils.postJsonObjectAsApplicationJson(wrapperDTO, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok) {
            Type t = new TypeToken<AddCustomerResponseDTO>(){}.getType();
            String text = resultSB.toString();
            text = this.fixResponse(text);
            AddCustomerResponseDTO response = (AddCustomerResponseDTO)Utils.loadFromJsonString(text, t, this.config.dateFormat);
            return response;
        }
        return null;
    }

    private String fixResponse(String text) {
        if (!text.startsWith("{")) {
            return "{\"" + text;
        }
        return text;
    }

    private String getCustomerCode(Order order, String revenueCode) {
        String customerCode = "";
        Customer customer = order.getCustomer();
        if (customer == null) {
            Map<String, GenericClientsPerRevenueCode> genericClientsPerRevenueCodeMap = this.config.getGenericClientsPerRevenueCode();
            GenericClientsPerRevenueCode genericClientsPerRevenueCode1 = genericClientsPerRevenueCodeMap.get(revenueCode);
            if (genericClientsPerRevenueCode1 == null) {
                genericClientsPerRevenueCode1 = genericClientsPerRevenueCodeMap.get(WILD_CARD);
            }
            customerCode = genericClientsPerRevenueCode1.getGenericClient();
        } else {
            customerCode = customer.getExternalKey();
        }
        return customerCode;
    }

    private boolean isCompany(ClientResponseBean clientResponseBean) {
        try {
            String cmpmode = clientResponseBean.getCMPMODE();
            boolean isCompany = Integer.parseInt(cmpmode) == 501 || Integer.parseInt(cmpmode) == 502;
            return isCompany;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void refreshTVAWithRemoteData(String sessionClientId) throws IOException {
        GetTvaRequest tvaRequest = GetTvaRequest.builder().setAppId(this.config.getAppId()).setClientID(sessionClientId).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : READ VAT");
        boolean ok = Utils.postJsonObjectAsApplicationJson(tvaRequest, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok) {
            String text = resultSB.toString();
            text = text.replace("VAT.VAT", "VAT_VAT");
            text = text.replace("VAT.PROCENT", "VAT_PROCENT");
            TVAResponse response = (TVAResponse)Utils.loadFromJsonString(text = text.replace("VAT.NUME", "VAT_NUME"), TVAResponse.class, this.config.dateFormat);
            if (response.isSuccess()) {
                response.getRows().stream().forEach(k -> {
                    String vatKey = k.getVAT_VAT();
                    this.tvaDTOMap.put(vatKey, (TVAResponseBean)k);
                });
            }
        }
    }

    private void refreshUMWithRemoteData(String sessionClientId) throws IOException {
        GetUMRequest tvaRequest = GetUMRequest.builder().setAppId(this.config.getAppId()).setClientID(sessionClientId).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : READ UM");
        boolean ok = Utils.postJsonObjectAsApplicationJson(tvaRequest, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok) {
            String text = resultSB.toString();
            text = text.replace("MTRUNIT.IDUM", "MTRUNIT_IDUM");
            text = text.replace("MTRUNIT.UM", "MTRUNIT_UM");
            UMResponse response = (UMResponse)Utils.loadFromJsonString(text = text.replace("MTRUNIT.ISACTIVE", "MTRUNIT_ISACTIVE"), UMResponse.class, this.config.dateFormat);
            if (response.isSuccess()) {
                response.getRows().stream().forEach(k -> this.umDTOMap.put(k.getMTRUNIT_IDUM(), (UMBean)k));
            }
        }
    }

    private void refreshArticlesWithRemoteData1(String sessionClientId) throws IOException {
        String text;
        ArticleResponse response;
        GetArticlesRequest request = GetArticlesRequest.builder().setAppId(this.config.getAppId()).setClientID(sessionClientId).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : READ ARTICLES");
        boolean ok = Utils.postJsonObjectAsApplicationJson(request, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok && (response = (ArticleResponse)Utils.loadFromJsonString(text = resultSB.toString(), ArticleResponse.class, this.config.dateFormat)).isSuccess()) {
            response.getData().stream().forEach(k -> this.articleDTOMap.put(k.getMTRL(), (ArticleResponseBean)k));
        }
    }

    private void refreshArticlesWithRemoteDataQBS(String sessionClientId) throws IOException {
        String text;
        ArticleResponseQBS response;
        GetArticlesRequestQBS request = GetArticlesRequestQBS.builder().setAppId(this.config.getAppId()).setClientID(sessionClientId).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : READ ARTICLES");
        boolean ok = Utils.postJsonObjectAsApplicationJson(request, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok && (response = (ArticleResponseQBS)Utils.loadFromJsonString(text = resultSB.toString(), ArticleResponseQBS.class, this.config.dateFormat)).isSuccess()) {
            List<ArticleResponseBean> data = response.getRows().stream().map(k -> ArticleResponseBean.fromMap(k, this.config.getPriceTagsPerBranch())).collect(Collectors.toList());
            response.setData(data);
            response.getData().stream().forEach(k -> this.articleDTOMap.put(k.getMTRL(), (ArticleResponseBean)k));
        }
    }

    private void refreshDistrictsWithRemoteData(String sessionClientId) throws IOException {
        String text;
        DistrictResponse response;
        GetDistrictsRequest request = GetDistrictsRequest.builder().setAppId(this.config.getAppId()).setClientID(sessionClientId).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : READ DISTRICTS");
        boolean ok = Utils.postJsonObjectAsApplicationJson(request, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok && (response = (DistrictResponse)Utils.loadFromJsonString(text = resultSB.toString(), DistrictResponse.class, this.config.dateFormat)).isSuccess()) {
            response.getRows().forEach(k -> {
                DistrictResponseBean bean = DistrictResponseBean.builder().build();
                bean.fromDTO((Map<String, String>)k);
                this.districtsDTOMap.put(bean.getDISTRICT_CODE(), bean);
            });
        }
    }

    private void refreshCountriesWithRemoteData(String sessionClientId) throws IOException {
        GetCountriesRequest request = GetCountriesRequest.builder().setAppId(this.config.getAppId()).setClientID(sessionClientId).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : READ COUNTRIES");
        boolean ok = Utils.postJsonObjectAsApplicationJson(request, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok) {
            String text = resultSB.toString();
            CountriesResponse response = (CountriesResponse)Utils.loadFromJsonString(text, CountriesResponse.class, this.config.dateFormat);
            System.out.println("Countries");
            if (response.isSuccess()) {
                List<CountryResponseBean> rows = response.getRows();
                rows.stream().forEach(k -> this.countriesDTOMap.put(k.getShortcut(), (CountryResponseBean)k));
            }
        }
    }

    private void initializeSessionPrivate(String revenueCode) throws IOException {
        this.login();
        this.openSession(revenueCode);
        this.refreshGlobalSupportObjects(revenueCode);
    }

    private void refreshGlobalSupportObjects(String revenueCode) throws IOException {
        String clientID = this.clientIdPerRevenueCode.get(revenueCode);
        this.refreshTVAWithRemoteData(clientID);
        this.refreshUMWithRemoteData(clientID);
        this.refreshCustomersFromSoft1(clientID);
        this.refreshArticlesWithRemoteDataQBS(clientID);
        this.refreshDistrictsWithRemoteData(clientID);
        this.refreshCountriesWithRemoteData(clientID);
    }

    private void login() throws IOException {
        String text;
        LoginResponse response;
        LoginRequest loginRequest = LoginRequest.builder().setAppId(this.config.getAppId()).setUsername(this.config.getLoginUser()).setPassword(this.config.getLoginPass()).setService("login").build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : LOGIN");
        boolean ok = Utils.postJsonObjectAsApplicationJson(loginRequest, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok && (response = (LoginResponse)Utils.loadFromJsonString(text = resultSB.toString(), LoginResponse.class, this.config.dateFormat)).isSuccess()) {
            this.loginClientId = response.getClientID();
            this.loginResponse = response;
        }
    }

    private void openSession(String revenueCode) throws IOException {
        String text;
        SessionInitResponse response;
        String branch = this.config.getBranchesPerRevenueCode().get(revenueCode);
        SessionInitRequest sessionInitRequest = SessionInitRequest.builder().setService("authenticate").setClientID(this.loginClientId).setCOMPANY(this.config.getCompany()).setBRANCH(branch).setMODULE(this.config.getModule()).setREFID(this.loginResponse.getResponseBeanForBranchCode(branch).getREFID()).setUSERID(this.config.getLoginUser()).build();
        StringBuffer resultSB = new StringBuffer();
        System.out.println("SOFT1 : OPEN SESSION");
        boolean ok = Utils.postJsonObjectAsApplicationJson(sessionInitRequest, this.config.getServiceURL(), this.config.getDateFormat(), new HashMap<String, String>(), resultSB, this.config.getRequestTimeoutMillis(), this.config.getCharset());
        if (ok && (response = (SessionInitResponse)Utils.loadFromJsonString(text = resultSB.toString(), SessionInitResponse.class, this.config.dateFormat)).isSuccess()) {
            log.debug("Authenticate success for branch " + branch + " !!");
            String thisSessionsClientId = response.getClientID();
            this.clientIdPerRevenueCode.put(revenueCode, thisSessionsClientId);
        }
    }

    public List<Article> getRemoteArticles() {
        ArrayList<Article> apiItems = new ArrayList<Article>();
        this.articleDTOMap.keySet().stream().forEach(externalCode -> {
            ArticleResponseBean articleResponseBean = this.articleDTOMap.get(externalCode);
            String vatCode = articleResponseBean.getVAT();
            TVAResponseBean tvaResponseBean = this.tvaDTOMap.get(vatCode);
            if (tvaResponseBean == null) {
                log.warn("MISSING TVA WITH CODE {} . Skiping product {} ", (Object)vatCode, (Object)articleResponseBean);
                return;
            }
            int tvaInt = Integer.parseInt(tvaResponseBean.getVAT_PROCENT());
            String unitIdS = articleResponseBean.getMTRUNIT1();
            UMBean umBean = this.umDTOMap.get(unitIdS);
            String unitName = umBean.getMTRUNIT_UM();
            Article apiItem = Article.builder().setExternalCode((String)externalCode).setBothPartySharedCode(articleResponseBean.getCODE()).setProductName(articleResponseBean.getNAME()).setUnitName(unitName).setTvaPercent(tvaInt).setReferencePrice(articleResponseBean.getReferencePrice()).build();
            Map<String, Double> tierPrices = articleResponseBean.getTierPrices();
            tierPrices.keySet().stream().forEach(tagName -> {
                Double price = (Double)tierPrices.get(tagName);
                if (price != null) {
                    ArticlePriceQtyBean build = ArticlePriceQtyBean.builder().setPrice(price).build();
                    apiItem.getTierPrices().put((String)tagName, build);
                }
            });
            apiItems.add(apiItem);
        });
        return apiItems;
    }

    public static double roundDoubleUp(double toRound, int scale) {
        try {
            BigDecimal bigDecimal = BigDecimal.valueOf(toRound).setScale(scale + 4, 4);
            double res1 = bigDecimal.doubleValue();
            BigDecimal bd2 = BigDecimal.valueOf(res1).setScale(scale, 4);
            double res2 = bd2.doubleValue();
            return res2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return toRound;
        }
    }
}

