/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.microservices.fiscalreceipt;

import java.io.Serializable;
import ro.deversoft.odf.gearbox.common.CommonUtils;
import ro.deversoft.odf.gearbox.common.domain.PaymentTypeEnum;

public class FiscalPayment
implements Serializable {
    PaymentTypeEnum paymentType;
    String actualPaymentNameM2M;
    double value;
    String details;

    public String getPaymentMeansText() {
        return (CommonUtils.correctString((String)this.actualPaymentNameM2M) ? this.actualPaymentNameM2M : this.paymentType.name()) + ": " + CommonUtils.roundDoubleUp((double)this.value, (int)2);
    }

    public static FiscalPaymentBuilder builder() {
        return new FiscalPaymentBuilder();
    }

    public PaymentTypeEnum getPaymentType() {
        return this.paymentType;
    }

    public String getActualPaymentNameM2M() {
        return this.actualPaymentNameM2M;
    }

    public double getValue() {
        return this.value;
    }

    public String getDetails() {
        return this.details;
    }

    public FiscalPayment setPaymentType(PaymentTypeEnum paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    public FiscalPayment setActualPaymentNameM2M(String actualPaymentNameM2M) {
        this.actualPaymentNameM2M = actualPaymentNameM2M;
        return this;
    }

    public FiscalPayment setValue(double value) {
        this.value = value;
        return this;
    }

    public FiscalPayment setDetails(String details) {
        this.details = details;
        return this;
    }

    public FiscalPayment() {
    }

    public FiscalPayment(PaymentTypeEnum paymentType, String actualPaymentNameM2M, double value, String details) {
        this.paymentType = paymentType;
        this.actualPaymentNameM2M = actualPaymentNameM2M;
        this.value = value;
        this.details = details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiscalPayment)) {
            return false;
        }
        FiscalPayment other = (FiscalPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        PaymentTypeEnum this$paymentType = this.getPaymentType();
        PaymentTypeEnum other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$actualPaymentNameM2M = this.getActualPaymentNameM2M();
        String other$actualPaymentNameM2M = other.getActualPaymentNameM2M();
        if (this$actualPaymentNameM2M == null ? other$actualPaymentNameM2M != null : !this$actualPaymentNameM2M.equals(other$actualPaymentNameM2M)) {
            return false;
        }
        String this$details = this.getDetails();
        String other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !this$details.equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FiscalPayment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        PaymentTypeEnum $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $actualPaymentNameM2M = this.getActualPaymentNameM2M();
        result = result * 59 + ($actualPaymentNameM2M == null ? 43 : $actualPaymentNameM2M.hashCode());
        String $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : $details.hashCode());
        return result;
    }

    public String toString() {
        return "FiscalPayment(paymentType=" + this.getPaymentType() + ", actualPaymentNameM2M=" + this.getActualPaymentNameM2M() + ", value=" + this.getValue() + ", details=" + this.getDetails() + ")";
    }

    public static class FiscalPaymentBuilder {
        private PaymentTypeEnum paymentType;
        private String actualPaymentNameM2M;
        private double value;
        private String details;

        FiscalPaymentBuilder() {
        }

        public FiscalPaymentBuilder setPaymentType(PaymentTypeEnum paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public FiscalPaymentBuilder setActualPaymentNameM2M(String actualPaymentNameM2M) {
            this.actualPaymentNameM2M = actualPaymentNameM2M;
            return this;
        }

        public FiscalPaymentBuilder setValue(double value) {
            this.value = value;
            return this;
        }

        public FiscalPaymentBuilder setDetails(String details) {
            this.details = details;
            return this;
        }

        public FiscalPayment build() {
            return new FiscalPayment(this.paymentType, this.actualPaymentNameM2M, this.value, this.details);
        }

        public String toString() {
            return "FiscalPayment.FiscalPaymentBuilder(paymentType=" + this.paymentType + ", actualPaymentNameM2M=" + this.actualPaymentNameM2M + ", value=" + this.value + ", details=" + this.details + ")";
        }
    }
}

