/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.FhSysButton;
import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class FhMenuBarUI
extends BasicMenuBarUI {
    protected static ActionListener actionAdapter = null;

    public static ComponentUI createUI(JComponent cmp) {
        return new FhMenuBarUI();
    }

    public void installUI(JComponent jc) {
        super.installUI(jc);
        if (!jc.getClass().getName().endsWith("SystemMenuBar")) {
            jc.setLayout(new FhMenuBarLayout());
            FhSysButton fhButton = null;
            int i = 0;
            while (i < jc.getComponentCount()) {
                if (".fhbutton.".equals(jc.getComponent(i).getName())) {
                    fhButton = (FhSysButton)jc.getComponent(i);
                    break;
                }
                ++i;
            }
            if (fhButton == null) {
                fhButton = this.createFhButton();
            }
            jc.add((Component)fhButton, QueueLayout.END);
        }
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        super.paint(g, c);
        Texture texture = (Texture)UIManager.getDefaults().get("MenuBar.texture");
        if (texture != null && ThemeManager.instance().probeSmallTextures()) {
            texture.apply(new Rectangle(0, 0, c.getSize().width, c.getSize().height), (Graphics2D)g, c);
        }
    }

    protected FhSysButton createFhButton() {
        if (actionAdapter == null) {
            actionAdapter = new FhMenuBarActionAdapter();
        }
        FhSysButton fhButton = new FhSysButton(-99999){

            public void setBorder(Border b) {
            }

            public String getName() {
                return ".fhbutton.";
            }
        };
        fhButton.addActionListener(actionAdapter);
        fhButton.setIcon(new ImageIcon(ClassLoader.getSystemResource("fhlaf_resources/fhss.png")));
        return fhButton;
    }

    public void uninstallUI(JComponent jc) {
        super.uninstallUI(jc);
        FhSysButton fhButton = null;
        int i = 0;
        while (i < jc.getComponentCount()) {
            if (".fhbutton.".equals(jc.getComponent(i).getName())) {
                fhButton = (FhSysButton)jc.getComponent(i);
                break;
            }
            ++i;
        }
        if (fhButton != null) {
            jc.remove(fhButton);
        }
    }

    protected class FhMenuBarLayout
    extends QueueLayout {
        public FhMenuBarLayout() {
            super(2, 100, 3);
        }
    }

    protected class FhMenuBarActionAdapter
    implements ActionListener {
        protected FhMenuBarActionAdapter() {
        }

        public void actionPerformed(ActionEvent ae) {
            ThemeManager.instance().launch((JComponent)ae.getSource(), null);
        }
    }
}

