/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh;

import com.shfarr.ui.plaf.fh.borders.FHMultiMatrixBorder;
import com.shfarr.ui.plaf.fh.textures.Texture;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;

public class FhRadioButtonMenuItemUI
extends BasicRadioButtonMenuItemUI {
    public static ComponentUI createUI(JComponent cmp) {
        return new FhRadioButtonMenuItemUI();
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c instanceof AbstractButton) {
            Dimension d = new Dimension(super.getPreferredSize((JComponent)c).width, (int)((double)c.getFont().getSize() * 1.5));
            if (((AbstractButton)c).getIcon() != null) {
                d.height = Math.max(d.height, (int)((double)((AbstractButton)c).getIcon().getIconHeight() * 1.5));
            }
            Insets bi = c.getBorder() != null ? c.getBorder().getBorderInsets(c) : new Insets(0, 0, 0, 0);
            Insets i = ((AbstractButton)c).getMargin();
            d.width += i.left + i.right + bi.left + bi.right;
            d.height += i.top + i.bottom + bi.bottom + bi.top;
            return d;
        }
        return super.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        ThemeManager.instance().probeAntialiasing(g);
        if (c instanceof JRadioButtonMenuItem && c.getBorder() instanceof FHMultiMatrixBorder) {
            String key = ((AbstractButton)c).getModel().isArmed() ? "armed" : (((AbstractButton)c).getModel().isPressed() ? "pressed" : "normal");
            ((FHMultiMatrixBorder)c.getBorder()).selectMatrix(key);
        }
        super.paint(g, c);
        Texture texture = (Texture)UIManager.getDefaults().get("MenuItem.texture");
        if (texture != null && ThemeManager.instance().probeSmallTextures() && ((AbstractButton)c).getModel().isArmed()) {
            texture.apply(new Rectangle(0, 0, c.getSize().width, c.getSize().height), (Graphics2D)g, c);
        }
    }
}

