/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme.edit;

import com.shfarr.ui.GraphicsUtils;
import com.shfarr.ui.layouts.FlexibleGridLayout;
import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.borders.FhMatrixBorder;
import com.shfarr.ui.plaf.fh.textures.MatrixTexture;
import com.shfarr.ui.plaf.fh.theme.ColorPalette;
import com.shfarr.ui.plaf.fh.theme.Theme;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import com.shfarr.ui.plaf.fh.theme.edit.ColorPalettePanel;
import com.shfarr.ui.plaf.fh.theme.edit.ThemeEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MatrixEditor
extends JPanel
implements ActionListener,
ChangeListener {
    private ColorPalettePanel palettePanel = null;
    private JPanel southPanel = null;
    private JLabel colorDispLabel = null;
    private JSpinner widthSpinner = null;
    private JSpinner heightSpinner = null;
    private JPanel editorScroller = null;
    private JPanel editor = null;
    private JSlider widthSlider = null;
    private JSlider heightSlider = null;
    private JPanel borderSample = null;
    private MatrixTexture currentTexture = null;
    private MatrixTexture backupTexture = null;
    private FhMatrixBorder currentBorder = null;
    private FhMatrixBorder backupBorder = null;
    private JComboBox namesCombo = null;
    private JPanel sidePanel = null;
    private String fileName = null;
    private JPanel centerPanel = null;
    private JPanel northPanel = null;
    private String type = "borders";

    public MatrixEditor() {
        super(new BorderLayout(3, 3));
        this.setBorder(new EmptyBorder(10, 4, 0, 0));
        this.add((Component)this.getSidePanel(), "East");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    protected JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            JScrollPane scp = new JScrollPane(this.getPalettePanel());
            scp.setPreferredSize(new Dimension(this.getPalettePanel().getPreferredSize().width + scp.getVerticalScrollBar().getPreferredSize().width + 6, 100));
            this.centerPanel = new JPanel(new BorderLayout(4, 4));
            this.centerPanel.add((Component)this.getEditorScroller(), "Center");
            this.centerPanel.add((Component)this.getNorthPanel(), "North");
            this.centerPanel.add((Component)this.getSouthPanel(), "South");
            this.centerPanel.add((Component)scp, "West");
        }
        return this.centerPanel;
    }

    protected JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel(new FlexibleGridLayout(1, 2, 4, 4));
            ButtonGroup group = new ButtonGroup();
            JRadioButton border = new JRadioButton("Border Matrices");
            border.setSelected(true);
            border.addActionListener(this);
            JRadioButton texture = new JRadioButton("Texture Matrices");
            texture.addActionListener(this);
            group.add(border);
            group.add(texture);
            this.northPanel.add(border);
            this.northPanel.add(texture);
        }
        return this.northPanel;
    }

    protected JPanel getSidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel(new QueueLayout(4, 0, 2));
            this.sidePanel.setBorder(new EmptyBorder(0, 4, 4, 4));
            JButton save = new JButton("Save");
            save.addActionListener(this);
            JButton revert = new JButton("Revert");
            revert.addActionListener(this);
            JButton add = new JButton("Add / Set");
            add.addActionListener(this);
            JButton delete = new JButton("Delete");
            delete.addActionListener(this);
            this.sidePanel.add(save);
            this.sidePanel.add(revert);
            this.sidePanel.add(new JPanel());
            this.sidePanel.add(add);
            this.sidePanel.add(delete);
        }
        return this.sidePanel;
    }

    protected JSlider getHeightSlider() {
        if (this.heightSlider == null) {
            this.heightSlider = new JSlider(1);
            this.heightSlider.setMinimum(0);
            this.heightSlider.setMinorTickSpacing(1);
            this.heightSlider.setPaintTicks(true);
            this.heightSlider.setPaintTrack(false);
            this.heightSlider.setSnapToTicks(true);
            this.heightSlider.addChangeListener(this);
        }
        return this.heightSlider;
    }

    protected JSlider getWidthSlider() {
        if (this.widthSlider == null) {
            this.widthSlider = new JSlider(0);
            this.widthSlider.setMinimum(0);
            this.widthSlider.setMinorTickSpacing(1);
            this.widthSlider.setPaintTicks(true);
            this.widthSlider.setPaintTrack(false);
            this.widthSlider.setSnapToTicks(true);
            this.widthSlider.addChangeListener(this);
        }
        return this.widthSlider;
    }

    protected JPanel getBorderSample() {
        if (this.borderSample == null) {
            this.borderSample = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    Insets i = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
                    Rectangle r = new Rectangle(i.left, i.top, this.getSize().width - i.left - i.right, this.getSize().height - i.top - i.bottom);
                    if (MatrixEditor.this.currentTexture != null) {
                        MatrixEditor.this.currentTexture.apply(r, (Graphics2D)g, this);
                    }
                }
            };
        }
        return this.borderSample;
    }

    protected JPanel getEditor() {
        if (this.editor == null) {
            this.editor = new JPanel(){

                public void paint(Graphics g) {
                    String[][] matrix;
                    super.paint(g);
                    String[][] stringArray = MatrixEditor.this.type.equals("borders") ? (MatrixEditor.this.currentBorder != null ? MatrixEditor.this.currentBorder.getMatrix() : null) : (matrix = MatrixEditor.this.currentTexture != null ? MatrixEditor.this.currentTexture.getMatrix() : null);
                    if (matrix != null) {
                        int ws = (this.getSize().width - 2) / matrix[0].length;
                        int hs = (this.getSize().height - 2) / matrix.length;
                        int i = 0;
                        while (i < matrix[0].length) {
                            int k = 0;
                            while (k < matrix.length) {
                                Rectangle r = new Rectangle(1 + i * ws + 1, 1 + k * hs + 1, ws - 4, hs - 3);
                                GraphicsUtils.paintTiledBackground(g, r, 5);
                                if (matrix[k][i] != null) {
                                    g.drawImage(GraphicsUtils.createColorImage(ThemeManager.instance().getCurrentTheme().colorPalette().getColor(matrix[k][i]), ws - 4, hs - 3), 1 + i * ws + 1, 1 + k * hs + 1, null);
                                }
                                if (MatrixEditor.this.type.equals("borders") && MatrixEditor.this.currentBorder != null) {
                                    g.setColor(Color.black);
                                    g.drawRect(1 + i * ws + 1, 1 + k * hs + 1, ws - 4, hs - 3);
                                    if (i == MatrixEditor.this.currentBorder.getCenter()[0] || k == MatrixEditor.this.currentBorder.getCenter()[1]) {
                                        g.drawRect(1 + i * ws + 2, 1 + k * hs + 2, ws - 6, hs - 5);
                                    }
                                }
                                ++k;
                            }
                            ++i;
                        }
                    }
                }
            };
            this.editor.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent ce) {
                    if (MatrixEditor.this.type.equals("borders")) {
                        MatrixEditor.this.updateSliders();
                    }
                }
            });
            this.editor.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    String[][] matrix = MatrixEditor.this.type.equals("borders") ? (MatrixEditor.this.currentBorder != null ? MatrixEditor.this.currentBorder.getMatrix() : null) : (MatrixEditor.this.currentTexture != null ? MatrixEditor.this.currentTexture.getMatrix() : null);
                    int ws = (MatrixEditor.this.getEditor().getSize().width - 2) / matrix[0].length;
                    int hs = (MatrixEditor.this.getEditor().getSize().height - 2) / matrix.length;
                    int i = me.getY() / hs;
                    int k = me.getX() / ws;
                    if (me.getButton() == 1) {
                        matrix[i][k] = me.getClickCount() == 2 ? null : MatrixEditor.this.getColorDispLabel().getText();
                        if (MatrixEditor.this.type.equals("borders")) {
                            MatrixEditor.this.currentBorder.setMatrix(matrix);
                            MatrixEditor.this.currentBorder.setCenter(MatrixEditor.this.getWidthSlider().getValue(), MatrixEditor.this.getHeightSlider().getMaximum() - MatrixEditor.this.getHeightSlider().getValue());
                        } else {
                            MatrixEditor.this.currentTexture.setMatrix(matrix);
                        }
                    } else {
                        MatrixEditor.this.getColorDispLabel().setText(matrix[i][k].startsWith("!") ? matrix[i][k].substring(1) : matrix[i][k]);
                    }
                    MatrixEditor.this.getEditor().repaint();
                    MatrixEditor.this.getBorderSample().repaint();
                }
            });
        }
        return this.editor;
    }

    protected JPanel getEditorScroller() {
        if (this.editorScroller == null) {
            this.editorScroller = new JPanel(null);
            this.editorScroller.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    MatrixEditor.this.getBorderSample().setBounds(0, 0, MatrixEditor.this.getHeightSlider().getPreferredSize().width, MatrixEditor.this.getWidthSlider().getPreferredSize().height);
                    MatrixEditor.this.getWidthSlider().setBounds(MatrixEditor.this.getBorderSample().getWidth(), 0, MatrixEditor.this.editorScroller.getWidth() - MatrixEditor.this.getBorderSample().getWidth(), MatrixEditor.this.getBorderSample().getHeight());
                    MatrixEditor.this.getHeightSlider().setBounds(0, MatrixEditor.this.getBorderSample().getHeight(), MatrixEditor.this.getBorderSample().getWidth(), MatrixEditor.this.editorScroller.getHeight() - MatrixEditor.this.getBorderSample().getHeight());
                    MatrixEditor.this.getEditor().setBounds(MatrixEditor.this.getBorderSample().getWidth(), MatrixEditor.this.getBorderSample().getHeight(), MatrixEditor.this.editorScroller.getWidth() - MatrixEditor.this.getBorderSample().getWidth(), MatrixEditor.this.editorScroller.getHeight() - MatrixEditor.this.getBorderSample().getHeight());
                }
            });
            this.editorScroller.add(this.getBorderSample());
            this.editorScroller.add(this.getWidthSlider());
            this.editorScroller.add(this.getHeightSlider());
            this.editorScroller.add(this.getEditor());
        }
        return this.editorScroller;
    }

    protected JSpinner getHeightSpinner() {
        if (this.heightSpinner == null) {
            this.heightSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 1000, 1));
            this.heightSpinner.addChangeListener(this);
        }
        return this.heightSpinner;
    }

    protected JSpinner getWidthSpinner() {
        if (this.widthSpinner == null) {
            this.widthSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 1000, 1));
            this.widthSpinner.addChangeListener(this);
        }
        return this.widthSpinner;
    }

    protected JLabel getColorDispLabel() {
        if (this.colorDispLabel == null) {
            this.colorDispLabel = new JLabel("-9");
        }
        return this.colorDispLabel;
    }

    protected JComboBox getNamesCombo() {
        if (this.namesCombo == null) {
            this.namesCombo = new JComboBox();
            this.namesCombo.addActionListener(this);
            this.namesCombo.setEditable(true);
            this.refreshNames(null);
        }
        return this.namesCombo;
    }

    protected JPanel getSouthPanel() {
        if (this.southPanel == null) {
            this.southPanel = new JPanel(new FlexibleGridLayout(3, 4, 4, 4));
            this.southPanel.setBorder(new EmptyBorder(5, 5, 5, 0));
            this.southPanel.add(new JLabel("Name:", 4));
            this.southPanel.add(this.getColorDispLabel());
            this.southPanel.add(new JLabel("    Matrix Width", 4));
            this.southPanel.add(this.getWidthSpinner());
            this.southPanel.add(new JLabel("Matrix", 4));
            this.southPanel.add(this.getNamesCombo());
            this.southPanel.add(new JLabel("    Matrix Height", 4));
            this.southPanel.add(this.getHeightSpinner());
        }
        return this.southPanel;
    }

    protected JToggleButton createToggleButton(String name, Color c) {
        JToggleButton b = new JToggleButton("");
        BufferedImage img = new BufferedImage(20, 20, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.gray);
        g.drawRect(0, 0, 19, 19);
        g.setColor(Color.white);
        g.drawRect(1, 1, 17, 17);
        GraphicsUtils.paintTiledBackground(g, new Rectangle(3, 2, 14, 16), 5);
        g.drawImage((Image)GraphicsUtils.createColorImage(c, 14, 16), 3, 2, null);
        b.setIcon(new ImageIcon(img));
        BufferedImage imgS = new BufferedImage(20, 20, 2);
        g = imgS.createGraphics();
        g.setColor(Color.orange);
        g.drawRect(0, 0, 19, 19);
        g.setColor(Color.white);
        g.drawRect(1, 1, 17, 17);
        GraphicsUtils.paintTiledBackground(g, new Rectangle(3, 2, 14, 16), 5);
        g.drawImage((Image)GraphicsUtils.createColorImage(c, 14, 16), 3, 2, null);
        b.setSelectedIcon(new ImageIcon(imgS));
        b.setActionCommand(name);
        b.setMargin(new Insets(1, 1, 1, 1));
        b.addActionListener(this);
        return b;
    }

    protected JPanel getPalettePanel() {
        if (this.palettePanel == null) {
            ColorPalette cp = ThemeManager.instance().getCurrentTheme().colorPalette();
            Collection list = cp.list();
            this.palettePanel = new ColorPalettePanel(new GridLayout(list.size() / 4 + (list.size() % 4 != 0 ? 1 : 0) + 1, 4, 2, 2));
            this.palettePanel.setBorder(new EmptyBorder(2, 2, 2, 2));
            ButtonGroup group = new ButtonGroup();
            int i = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                JToggleButton b = this.createToggleButton(name, cp.getColor(name));
                if (i == 24) {
                    int q = 0;
                    while (q < 4) {
                        JPanel sep = new JPanel();
                        sep.setPreferredSize(new Dimension(20, 20));
                        this.palettePanel.add(sep);
                        ++q;
                    }
                }
                this.palettePanel.add(b);
                group.add(b);
                ++i;
            }
        }
        return this.palettePanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            this.selectEditedItem();
        } else if (e.getSource() instanceof JRadioButton) {
            this.type = e.getActionCommand().equals("Border Matrices") ? "borders" : "textures";
            this.getHeightSlider().setEnabled(this.type.equals("borders"));
            this.getWidthSlider().setEnabled(this.type.equals("borders"));
            this.getHeightSlider().setVisible(this.type.equals("borders"));
            this.getWidthSlider().setVisible(this.type.equals("borders"));
            this.refreshNames(null);
        } else if (e.getSource() instanceof JToggleButton) {
            this.colorDispLabel.setText(e.getActionCommand());
        } else if (e.getActionCommand().equals("Save")) {
            ThemeEditor.instance().getEditedTheme().saveMatrices();
        } else if (e.getActionCommand().equals("Add / Set")) {
            String[][] matrix = GraphicsUtils.rotateClockwise(this.type.equals("borders") ? this.currentBorder.getMatrix() : this.currentTexture.getMatrix(), 0);
            ThemeEditor.instance().getEditedTheme().matrixPalette().put(String.valueOf(this.type) + "/." + this.getNamesCombo().getSelectedItem(), matrix);
        } else if (e.getActionCommand().equals("Delete")) {
            this.fileName = String.valueOf(ThemeManager.instance().getPreferences().getThemeDirectory()) + "/" + ThemeEditor.instance().getEditedTheme().getName() + "/matrix/" + this.type + "/." + this.getNamesCombo().getSelectedItem().toString();
            new File(this.fileName).delete();
            this.refreshNames(null);
        } else if (e.getActionCommand().equals("Revert")) {
            ThemeEditor.instance().getEditedTheme().loadMatrices();
            if (this.type.equals("borders")) {
                this.currentBorder.setMatrix(this.backupBorder.getMatrix());
                this.currentBorder.setCenter(this.backupBorder.getCenter()[0], this.backupBorder.getCenter()[1]);
                this.updateSliders();
            } else {
                this.currentTexture.setMatrix(this.backupTexture.getMatrix());
            }
            this.updateSpinners();
            this.getEditor().repaint();
            this.getBorderSample().repaint();
        }
    }

    public void selectEditedItem() {
        Theme theme = ThemeEditor.instance().getEditedTheme();
        Object name = this.getNamesCombo().getSelectedItem();
        if (name != null) {
            if (this.type.equals("borders")) {
                FhMatrixBorder dumbBorder = (FhMatrixBorder)theme.getBorder(name.toString());
                if (dumbBorder != null) {
                    this.currentBorder = dumbBorder;
                    this.backupBorder = this.currentBorder.deriveBorder(0);
                    this.updateSliders();
                }
            } else {
                String[][] newMatrix = (String[][])theme.matrixPalette().get(String.valueOf(this.type) + "/." + name.toString());
                if (newMatrix != null) {
                    this.currentTexture = new MatrixTexture();
                    this.currentTexture.setMatrix(newMatrix);
                    this.backupTexture = (MatrixTexture)this.currentTexture.deriveTexture(0);
                }
            }
            this.updateSpinners();
            this.getBorderSample().setBorder(new CompoundBorder(new EmptyBorder(4, 4, 0, 0), this.currentBorder));
        }
        this.getEditor().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent e) {
        String[][] matrix;
        String[][] stringArray = this.type.equals("borders") ? (this.currentBorder != null ? this.currentBorder.getMatrix() : null) : (matrix = this.currentTexture != null ? this.currentTexture.getMatrix() : null);
        if (matrix != null) {
            if (e.getSource() instanceof JSpinner) {
                String[][] newMatrix = e.getSource() == this.widthSpinner ? new String[matrix.length][((Integer)this.widthSpinner.getValue()).intValue()] : new String[((Integer)this.heightSpinner.getValue()).intValue()][matrix[0].length];
                int i = 0;
                while (i < Math.min(newMatrix.length, matrix.length)) {
                    int k = 0;
                    while (k < Math.min(newMatrix[i].length, matrix[i].length)) {
                        newMatrix[i][k] = matrix[i][k];
                        ++k;
                    }
                    ++i;
                }
                if (this.type.equals("borders")) {
                    this.currentBorder.setMatrix(newMatrix);
                } else {
                    this.currentTexture.setMatrix(newMatrix);
                }
                this.updateSliders();
            } else {
                Object object = this.getTreeLock();
                synchronized (object) {
                    this.currentBorder.setCenter(this.getWidthSlider().getValue(), this.getHeightSlider().getMaximum() - this.getHeightSlider().getValue());
                }
            }
            this.getEditor().repaint();
            this.getBorderSample().repaint();
        }
    }

    protected void updateSpinners() {
        String[][] matrix;
        String[][] stringArray = this.type.equals("borders") ? (this.currentBorder != null ? this.currentBorder.getMatrix() : null) : (matrix = this.currentTexture != null ? this.currentTexture.getMatrix() : null);
        if (matrix != null) {
            this.getHeightSpinner().setValue(new Integer(matrix.length));
        }
        if (matrix != null) {
            this.getWidthSpinner().setValue(new Integer(matrix[0].length));
        }
    }

    protected void updateSliders() {
        if (this.type.equals("borders") && this.currentBorder != null) {
            this.getHeightSlider().removeChangeListener(this);
            this.getWidthSlider().removeChangeListener(this);
            int h = (this.getEditor().getSize().height - 2) / this.currentBorder.getMatrix().length / 3;
            this.getHeightSlider().setBorder(new EmptyBorder(h, 0, h, 0));
            this.getHeightSlider().setMaximum(this.currentBorder.getMatrix().length - 1);
            this.getHeightSlider().setValue(this.getHeightSlider().getMaximum() - this.currentBorder.getCenter()[1]);
            int w = (this.getEditor().getSize().width - 2) / this.currentBorder.getMatrix()[0].length / 3;
            this.getWidthSlider().setBorder(new EmptyBorder(0, w, 0, w));
            this.getWidthSlider().setMaximum(this.currentBorder.getMatrix()[0].length - 1);
            this.getWidthSlider().setValue(this.currentBorder.getCenter()[0]);
            this.getHeightSlider().addChangeListener(this);
            this.getWidthSlider().addChangeListener(this);
        }
    }

    protected void refreshNames(String selectedItem) {
        Theme theme = ThemeEditor.instance().getEditedTheme();
        this.getNamesCombo().removeAllItems();
        Iterator i = theme.matrixPalette().keySet().iterator();
        while (i.hasNext()) {
            String str = (String)i.next();
            if (!str.startsWith(String.valueOf(this.type) + "/")) continue;
            this.getNamesCombo().addItem(str.substring(this.type.length() + 2));
        }
        if (selectedItem != null) {
            this.getNamesCombo().setSelectedItem(selectedItem);
        } else {
            this.getNamesCombo().setSelectedIndex(0);
        }
    }
}

