/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class IconPanel
extends JPanel {
    public static final int NORTH_WEST = 1;
    public static final int NORTH = 2;
    public static final int NORTH_EAST = 3;
    public static final int EAST = 4;
    public static final int SOUTH_EAST = 5;
    public static final int SOUTH = 6;
    public static final int SOUTH_WEST = 7;
    public static final int WEST = 8;
    public static final int CENTER = 9;
    public static final int TILED = 10;
    public static final int STRETCHED = 11;
    protected int placement = 1;
    protected Color background;
    protected Icon icon = null;

    public IconPanel() {
        this.background = super.getBackground();
    }

    public IconPanel(Icon icon) {
        this.icon = icon;
        this.background = super.getBackground();
    }

    public IconPanel(Icon icon, int placement) {
        this.icon = icon;
        this.setPlacement(placement);
        this.background = super.getBackground();
    }

    public void setPlacement(int placement) {
        if (placement < 1 || placement > 11) {
            throw new IllegalArgumentException("Placement value is not valid");
        }
        this.placement = placement;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        this.background = background;
    }

    public int getPlacement() {
        return this.placement;
    }

    public Icon getIcon() {
        return this.icon;
    }

    protected void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = 0;
        int y = 0;
        if (g == null) {
            return;
        }
        g.setColor(this.background);
        g.fillRect(x, y, w, h);
        if (this.icon == null) {
            return;
        }
        if (this.placement == 1) {
            x = 0;
            y = 0;
        } else if (this.placement == 2) {
            x = (w - this.icon.getIconWidth()) / 2;
            y = 0;
        } else if (this.placement == 3) {
            x = w - this.icon.getIconWidth();
            y = 0;
        } else if (this.placement == 4) {
            x = w - this.icon.getIconWidth();
            y = (h - this.icon.getIconHeight()) / 2;
        } else if (this.placement == 5) {
            x = w - this.icon.getIconWidth();
            y = h - this.icon.getIconHeight();
        } else if (this.placement == 6) {
            x = (w - this.icon.getIconWidth()) / 2;
            y = h - this.icon.getIconHeight();
        } else if (this.placement == 7) {
            x = 0;
            y = h - this.icon.getIconHeight();
        } else if (this.placement == 8) {
            x = 0;
            y = (h - this.icon.getIconHeight()) / 2;
        } else if (this.placement == 9) {
            x = (w - this.icon.getIconWidth()) / 2;
            y = (h - this.icon.getIconHeight()) / 2;
        } else if (this.placement == 10) {
            x = 0;
            while (x < w) {
                y = 0;
                while (y < h) {
                    if (this.icon != null) {
                        this.icon.paintIcon(this, g, x, y);
                    }
                    y += this.icon.getIconHeight();
                }
                x += this.icon.getIconWidth();
            }
        } else if (this.placement == 11) {
            if (this.icon instanceof ImageIcon) {
                g.drawImage(((ImageIcon)this.icon).getImage(), 0, 0, w, h, this);
            } else {
                System.out.println("Can only stretch ImageIcons");
                this.icon.paintIcon(this, g, 0, 0);
            }
        }
        if (this.placement != 10 && this.placement != 11) {
            this.icon.paintIcon(this, g, x, y);
        }
    }
}

