/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import mseries.ui.MPopup;
import mseries.ui.ScreenUtilities;
import mseries.ui.Shadow;

public class MPopupPanel
extends JPanel
implements MPopup,
Serializable {
    int desiredLocationX;
    int desiredLocationY;
    boolean isVisible = false;
    boolean hasShadow = false;
    Component invoker;
    Component firstComp = null;

    public MPopupPanel() {
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    public void addComponent(Component aComponent, Object constraints) {
        this.add(aComponent, constraints);
        if (this.firstComp == null) {
            this.firstComp = aComponent;
        }
    }

    public void setShadow(boolean hasShadow) {
        if (hasShadow) {
            this.add((Component)new Shadow(0), "South");
            this.add((Component)new Shadow(1), "East");
        }
        this.hasShadow = hasShadow;
    }

    public boolean isShadow() {
        return this.hasShadow;
    }

    public void removeComponent(Component c) {
        this.remove(c);
    }

    public void requestFocus() {
        this.firstComp.requestFocus();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void pack() {
        this.setSize(this.getPreferredSize());
    }

    public void setParent(Component invoker) {
        this.invoker = invoker;
    }

    private void showPanel(Component invoker) {
        Container parent = ScreenUtilities.getParentWindow(invoker);
        Point p = ScreenUtilities.convertScreenLocationToParent(parent, this.desiredLocationX, this.desiredLocationY);
        this.setLocation(p.x, p.y);
        if (parent instanceof JLayeredPane) {
            ((JLayeredPane)parent).add(this, JLayeredPane.POPUP_LAYER, 0);
        } else {
            parent.add(this);
        }
        this.isVisible = true;
    }

    public void setVisible(boolean show) {
        if (show) {
            this.showPanel(this.invoker);
        } else {
            this.hidePanel();
        }
    }

    private void hidePanel() {
        Container parent = this.getParent();
        Rectangle r = this.getBounds();
        if (parent != null) {
            parent.remove(this);
        }
        parent.repaint(r.x, r.y, r.width, r.height);
        this.isVisible = false;
    }

    public void setLocationOnScreen(int x, int y) {
        Container parent = this.getParent();
        if (parent != null) {
            Point p = ScreenUtilities.convertScreenLocationToParent(parent, x, y);
            this.setLocation(p.x, p.y);
        } else {
            this.desiredLocationX = x;
            this.desiredLocationY = y;
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int getWeight() {
        return 0;
    }

    public boolean isLightweight() {
        return true;
    }

    public boolean isOpaque() {
        return false;
    }
}

