/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.C40Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

final class X12Encoder
extends C40Encoder {
    X12Encoder() {
    }

    @Override
    public final int getEncodingMode() {
        return 3;
    }

    @Override
    public final void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            int n2 = encoderContext.getCurrentChar();
            ++encoderContext.a;
            this.a((char)n2, stringBuilder);
            if (stringBuilder.length() % 3 != 0) continue;
            X12Encoder.a(encoderContext, stringBuilder);
            n2 = HighLevelEncoder.a(encoderContext.getMessage(), encoderContext.a, this.getEncodingMode());
            if (n2 == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n2);
            break;
        }
        this.b(encoderContext, stringBuilder);
    }

    @Override
    final int a(char c2, StringBuilder stringBuilder) {
        switch (c2) {
            case '\r': {
                stringBuilder.append('\u0000');
                break;
            }
            case '*': {
                stringBuilder.append('\u0001');
                break;
            }
            case '>': {
                stringBuilder.append('\u0002');
                break;
            }
            case ' ': {
                stringBuilder.append('\u0003');
                break;
            }
            default: {
                if (c2 >= '0' && c2 <= '9') {
                    stringBuilder.append((char)(c2 - 48 + 4));
                    break;
                }
                if (c2 >= 'A' && c2 <= 'Z') {
                    stringBuilder.append((char)(c2 - 65 + 14));
                    break;
                }
                HighLevelEncoder.a(c2);
            }
        }
        return 1;
    }

    @Override
    final void b(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.updateSymbolInfo();
        int n2 = encoderContext.getSymbolInfo().getDataCapacity() - encoderContext.getCodewordCount();
        int n3 = stringBuilder.length();
        encoderContext.a -= n3;
        if (encoderContext.getRemainingCharacters() > 1 || n2 > 1 || encoderContext.getRemainingCharacters() != n2) {
            encoderContext.writeCodeword('\u00fe');
        }
        if (encoderContext.getNewEncoding() < 0) {
            encoderContext.signalEncoderChange(0);
        }
    }
}

