/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReferenceObjectCache
implements i {
    private final ConcurrentHashMap<Class<?>, Map<Object, Reference<Object>>> classMaps = new ConcurrentHashMap();
    private final boolean useWeak;

    public ReferenceObjectCache(boolean bl2) {
        this.useWeak = bl2;
    }

    public static ReferenceObjectCache makeWeakCache() {
        return new ReferenceObjectCache(true);
    }

    public static ReferenceObjectCache makeSoftCache() {
        return new ReferenceObjectCache(false);
    }

    @Override
    public synchronized <T> void registerClass(Class<T> clazz) {
        if (this.classMaps.get(clazz) == null) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            this.classMaps.put(clazz, concurrentHashMap);
        }
    }

    @Override
    public <T, ID> T get(Class<T> object, ID ID2) {
        if ((object = this.getMapForClass((Class<?>)object)) == null) {
            return null;
        }
        Reference reference = (Reference)object.get(ID2);
        if (reference == null) {
            return null;
        }
        if ((reference = reference.get()) == null) {
            object.remove(ID2);
            return null;
        }
        return (T)reference;
    }

    @Override
    public <T, ID> void put(Class<T> object, ID ID2, T t2) {
        if ((object = this.getMapForClass((Class<?>)object)) != null) {
            if (this.useWeak) {
                object.put(ID2, new WeakReference<T>(t2));
                return;
            }
            object.put(ID2, new SoftReference<T>(t2));
        }
    }

    @Override
    public <T> void clear(Class<T> object) {
        if ((object = this.getMapForClass((Class<?>)object)) != null) {
            object.clear();
        }
    }

    public void clearAll() {
        Iterator<Map<Object, Reference<Object>>> iterator = this.classMaps.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    @Override
    public <T, ID> void remove(Class<T> object, ID ID2) {
        if ((object = this.getMapForClass((Class<?>)object)) != null) {
            object.remove(ID2);
        }
    }

    @Override
    public <T, ID> T updateId(Class<T> object, ID object2, ID ID2) {
        if ((object = this.getMapForClass((Class<?>)object)) == null) {
            return null;
        }
        if ((object2 = (Reference)object.remove(object2)) == null) {
            return null;
        }
        object.put(ID2, object2);
        return ((Reference)object2).get();
    }

    public <T> int size(Class<T> object) {
        if ((object = this.getMapForClass((Class<?>)object)) == null) {
            return 0;
        }
        return object.size();
    }

    public int sizeAll() {
        int n2 = 0;
        for (Map<Object, Reference<Object>> map : this.classMaps.values()) {
            n2 += map.size();
        }
        return n2;
    }

    public <T> void cleanNullReferences(Class<T> object) {
        if ((object = this.getMapForClass((Class<?>)object)) != null) {
            this.cleanMap((Map<Object, Reference<Object>>)object);
        }
    }

    public <T> void cleanNullReferencesAll() {
        for (Map<Object, Reference<Object>> map : this.classMaps.values()) {
            this.cleanMap(map);
        }
    }

    private void cleanMap(Map<Object, Reference<Object>> object) {
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            if (((Reference)((Map.Entry)object.next()).getValue()).get() != null) continue;
            object.remove();
        }
    }

    private Map<Object, Reference<Object>> getMapForClass(Class<?> object) {
        if ((object = this.classMaps.get(object)) == null) {
            return null;
        }
        return object;
    }
}

