/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.config;

import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.asteriskjava.config.Category;
import org.asteriskjava.config.ConfigDirective;
import org.asteriskjava.config.ConfigElement;
import org.asteriskjava.config.ConfigFile;
import org.asteriskjava.config.ConfigFileImpl;
import org.asteriskjava.config.ConfigParseException;
import org.asteriskjava.config.ConfigVariable;
import org.asteriskjava.config.ExecDirective;
import org.asteriskjava.config.IncludeDirective;
import org.asteriskjava.config.MissingDirectiveParameterException;
import org.asteriskjava.config.MissingEqualSignException;
import org.asteriskjava.config.UnknownDirectiveException;

public class ConfigFileReader {
    private static final int MAX_LINE_LENGTH = 8192;
    private static char COMMENT_META = (char)59;
    private static char COMMENT_TAG = (char)45;
    private static final Set<Class<?>> WARNING_CLASSES = new HashSet();
    private StringBuilder commentBlock = new StringBuilder();
    public final Map<String, Category> categories = new LinkedHashMap<String, Category>();
    private final List<ConfigParseException> warnings = new ArrayList<ConfigParseException>();
    public Category currentCategory;
    private int currentCommentLevel = 0;

    public ConfigFile readFile(String string) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            this.readFile(string, bufferedReader);
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {}
        return new ConfigFileImpl(string, new TreeMap<String, Category>(this.categories));
    }

    void reset() {
        this.commentBlock = new StringBuilder();
        this.categories.clear();
        this.warnings.clear();
        this.currentCategory = null;
        this.currentCommentLevel = 0;
    }

    Collection<Category> getCategories() {
        return this.categories.values();
    }

    public Collection<ConfigParseException> getWarnings() {
        return new ArrayList<ConfigParseException>(this.warnings);
    }

    void readFile(String string, BufferedReader bufferedReader) {
        String string2;
        int n2 = 0;
        CharBuffer charBuffer = CharBuffer.allocate(8192);
        this.reset();
        while ((string2 = bufferedReader.readLine()) != null) {
            ++n2;
            charBuffer.clear();
            charBuffer.put(string2);
            charBuffer.put("\n");
            charBuffer.flip();
            this.processLine(string, n2, charBuffer);
        }
    }

    ConfigElement processLine(String object, int n2, CharBuffer charSequence) {
        StringBuilder stringBuilder = new StringBuilder(8192);
        StringBuilder stringBuilder2 = new StringBuilder(8192);
        ((CharBuffer)charSequence).mark();
        while (((Buffer)((Object)charSequence)).hasRemaining()) {
            int n3 = ((Buffer)((Object)charSequence)).position();
            char c2 = ((CharBuffer)charSequence).get();
            if (c2 == COMMENT_META && (n3 <= 0 || ((CharBuffer)charSequence).get(n3 - 1) != '\\')) {
                if (((Buffer)((Object)charSequence)).remaining() >= 3 && ((CharBuffer)charSequence).get(n3 + 1) == COMMENT_TAG && ((CharBuffer)charSequence).get(n3 + 2) == COMMENT_TAG && ((CharBuffer)charSequence).get(n3 + 3) != COMMENT_TAG) {
                    ++this.currentCommentLevel;
                    if (!this.inComment()) {
                        this.commentBlock.append(";--");
                        ((CharBuffer)charSequence).position(n3 + 3);
                        ((CharBuffer)charSequence).mark();
                        continue;
                    }
                } else if (this.inComment() && n3 >= 2 && ((CharBuffer)charSequence).get(n3 - 1) == COMMENT_TAG && ((CharBuffer)charSequence).get(n3 - 2) == COMMENT_TAG) {
                    --this.currentCommentLevel;
                    if (!this.inComment()) {
                        ((CharBuffer)charSequence).reset();
                        this.commentBlock.append(c2);
                        ((CharBuffer)charSequence).position(n3 + 1);
                        ((CharBuffer)charSequence).compact();
                        ((CharBuffer)charSequence).flip();
                        continue;
                    }
                } else if (!this.inComment()) {
                    while (((Buffer)((Object)charSequence)).hasRemaining()) {
                        stringBuilder2.append(((CharBuffer)charSequence).get());
                    }
                    break;
                }
            }
            if (this.inComment()) {
                this.commentBlock.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        String string = stringBuilder.toString().trim();
        charSequence = stringBuilder2.toString().trim();
        if (string.length() == 0) {
            if (((String)charSequence).length() != 0) {
                this.commentBlock.append(";");
                this.commentBlock.append((String)charSequence);
            }
            if (!this.inComment()) {
                this.commentBlock.append("\n");
            }
            return null;
        }
        try {
            object = this.processTextLine((String)object, n2, string);
        }
        catch (ConfigParseException configParseException) {
            if (WARNING_CLASSES.contains(configParseException.getClass())) {
                this.warnings.add(configParseException);
                return null;
            }
            throw configParseException;
        }
        if (((String)charSequence).length() != 0) {
            ((ConfigElement)object).setComment((String)charSequence);
        }
        if (this.commentBlock.length() != 0) {
            ((ConfigElement)object).setPreComment(this.commentBlock.toString());
            this.commentBlock.delete(0, this.commentBlock.length());
        }
        return object;
    }

    boolean inComment() {
        return this.currentCommentLevel != 0;
    }

    public ConfigElement processTextLine(String object, int n2, String string) {
        if (string.charAt(0) == '[') {
            object = this.parseCategoryHeader((String)object, n2, string);
        } else if (string.charAt(0) == '#') {
            object = this.parseDirective((String)object, n2, string);
        } else {
            if (this.currentCategory == null) {
                throw new ConfigParseException((String)object, n2, "parse error: No category context for line %d of %s", n2, object);
            }
            object = this.parseVariable((String)object, n2, string);
            this.currentCategory.addElement((ConfigElement)object);
        }
        return object;
    }

    protected Category parseCategoryHeader(String string, int n2, String stringArray) {
        int n3 = stringArray.indexOf(93);
        if (n3 == -1) {
            throw new ConfigParseException(string, n2, "parse error: no closing ']', line %d of %s", n2, string);
        }
        String string2 = stringArray.substring(1, n3);
        Category category = new Category(string, n2, string2);
        if (stringArray.length() > n3 + 1 && stringArray.charAt(n3 + 1) == '(') {
            if ((n3 = (stringArray = stringArray.substring(n3 + 1)).indexOf(41)) == -1) {
                throw new ConfigParseException(string, n2, "parse error: no closing ')', line %d of %s", n2, string);
            }
            for (String string3 : stringArray.substring(1, n3).split(",")) {
                if ("!".equals(string3)) {
                    category.markAsTemplate();
                    continue;
                }
                if ("+".equals(string3)) {
                    if (this.categories.get(string2) != null) continue;
                    throw new ConfigParseException(string, n2, "Category addition requested, but category '%s' does not exist, line %d of %s", string2, n2, string);
                }
                Category category2 = this.categories.get(string3);
                if (category2 == null) {
                    throw new ConfigParseException(string, n2, "Inheritance requested, but category '%s' does not exist, line %d of %s", string3, n2, string);
                }
                this.inheritCategory(category, category2);
            }
        }
        this.appendCategory(category);
        return category;
    }

    ConfigDirective parseDirective(String string, int n2, String object) {
        int n3;
        String string2 = null;
        CharSequence charSequence = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 1; n3 < ((String)object).length(); ++n3) {
            char c2 = ((String)object).charAt(n3);
            if (string2 == null) {
                ((StringBuilder)charSequence).append(c2);
                if (!Character.isWhitespace(c2) && n3 + 1 != ((String)object).length()) continue;
                string2 = ((StringBuilder)charSequence).toString().trim();
                continue;
            }
            stringBuilder.append(c2);
        }
        charSequence = stringBuilder.toString().trim();
        if (((String)charSequence).length() != 0 && (((String)charSequence).charAt(0) == '\"' || ((String)charSequence).charAt(0) == '<' || ((String)charSequence).charAt(0) == '>')) {
            charSequence = ((String)charSequence).substring(1);
        }
        n3 = ((String)charSequence).length() - 1;
        if (((String)charSequence).length() != 0 && (((String)charSequence).charAt(n3) == '\"' || ((String)charSequence).charAt(n3) == '<' || ((String)charSequence).charAt(n3) == '>')) {
            charSequence = ((String)charSequence).substring(0, n3);
        }
        if ("exec".equalsIgnoreCase(string2)) {
            object = new ExecDirective(string, n2, (String)charSequence);
        } else if ("include".equalsIgnoreCase(string2)) {
            object = new IncludeDirective(string, n2, (String)charSequence);
        } else {
            throw new UnknownDirectiveException(string, n2, "Unknown directive '%s' at line %d of %s", string2, n2, string);
        }
        if (((String)charSequence).length() == 0) {
            if (string2 == null) {
                string2 = "";
            }
            throw new MissingDirectiveParameterException(string, n2, "Directive '#%s' needs an argument (%s) at line %d of %s", string2.toLowerCase(Locale.US), "include".equalsIgnoreCase(string2) ? "filename" : "/path/to/executable", n2, string);
        }
        return object;
    }

    public ConfigVariable parseVariable(String string, int n2, String string2) {
        int n3 = string2.indexOf(61);
        if (n3 == -1) {
            throw new MissingEqualSignException(string, n2, "No '=' (equal sign) in line %d of %s", n2, string);
        }
        String string3 = string2.substring(0, n3).trim();
        if (string2.length() > n3 + 1 && string2.charAt(n3 + 1) == '>') {
            ++n3;
        }
        string2 = string2.length() > n3 + 1 ? string2.substring(n3 + 1).trim() : "";
        return new ConfigVariable(string, n2, string3, string2);
    }

    void inheritCategory(Category category, Category category2) {
        category.addBaseCategory(category2);
    }

    void appendCategory(Category category) {
        this.categories.put(category.getName(), category);
        this.currentCategory = category;
    }

    static {
        WARNING_CLASSES.add(MissingEqualSignException.class);
        WARNING_CLASSES.add(UnknownDirectiveException.class);
        WARNING_CLASSES.add(MissingDirectiveParameterException.class);
    }
}

