/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.asteriskjava.fastagi.AbstractAgiServer;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.fastagi.StaticMappingStrategy;
import org.asteriskjava.fastagi.internal.AgiChannelFactory;
import org.asteriskjava.fastagi.internal.AsyncAgiConnectionHandler;
import org.asteriskjava.fastagi.internal.DefaultAgiChannelFactory;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.AsyncAgiEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AsyncAgiServer
extends AbstractAgiServer
implements ManagerEventListener {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Integer, AsyncAgiConnectionHandler> connectionHandlers = new HashMap<Integer, AsyncAgiConnectionHandler>();

    public AsyncAgiServer() {
        this(new DefaultAgiChannelFactory());
    }

    public AsyncAgiServer(AgiChannelFactory agiChannelFactory) {
        super(agiChannelFactory);
    }

    public AsyncAgiServer(MappingStrategy mappingStrategy) {
        this(mappingStrategy, (AgiChannelFactory)new DefaultAgiChannelFactory());
        this.logger.debug("use default AgiChannelFactory");
    }

    public AsyncAgiServer(MappingStrategy mappingStrategy, AgiChannelFactory agiChannelFactory) {
        this(agiChannelFactory);
        this.setMappingStrategy(mappingStrategy);
    }

    public AsyncAgiServer(AgiScript agiScript, AgiChannelFactory agiChannelFactory) {
        this(agiChannelFactory);
        this.setMappingStrategy(new StaticMappingStrategy(agiScript));
    }

    public AsyncAgiServer(AgiScript agiScript) {
        this(agiScript, (AgiChannelFactory)new DefaultAgiChannelFactory());
        this.logger.debug("use default AgiChannelFactory");
    }

    @Override
    public void onManagerEvent(ManagerEvent managerEvent) {
        if (managerEvent instanceof AsyncAgiEvent) {
            this.handleAsyncAgiEvent((AsyncAgiEvent)managerEvent);
            return;
        }
        if (managerEvent instanceof RenameEvent) {
            this.handleRenameEvent((RenameEvent)managerEvent);
        }
    }

    private void handleAsyncAgiEvent(AsyncAgiEvent asyncAgiEvent) {
        ManagerConnection managerConnection = (ManagerConnection)asyncAgiEvent.getSource();
        String string = asyncAgiEvent.getChannel();
        if (asyncAgiEvent.isStart()) {
            AsyncAgiConnectionHandler asyncAgiConnectionHandler = new AsyncAgiConnectionHandler(this.getMappingStrategy(), asyncAgiEvent, this.getAgiChannelFactory());
            this.setConnectionHandler(managerConnection, string, asyncAgiConnectionHandler);
            try {
                this.execute(asyncAgiConnectionHandler);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.logger.warn("Execution was rejected by pool. Try to increase the pool size.");
                asyncAgiConnectionHandler.release();
                return;
            }
        }
        AsyncAgiConnectionHandler asyncAgiConnectionHandler = this.getConnectionHandler(managerConnection, string);
        if (asyncAgiConnectionHandler == null) {
            this.logger.info("No AsyncAgiConnectionHandler registered for channel " + string + ": Ignoring AsyncAgiEvent");
            return;
        }
        if (asyncAgiEvent.isExec()) {
            asyncAgiConnectionHandler.onAsyncAgiExecEvent(asyncAgiEvent);
            return;
        }
        if (asyncAgiEvent.isEnd()) {
            asyncAgiConnectionHandler.onAsyncAgiEndEvent(asyncAgiEvent);
            this.removeConnectionHandler(managerConnection, string);
            return;
        }
        this.logger.warn("Ignored unknown AsyncAgiEvent of sub type '" + asyncAgiEvent.getSubEvent() + "'");
    }

    private void handleRenameEvent(RenameEvent renameEvent) {
        ManagerConnection managerConnection = (ManagerConnection)renameEvent.getSource();
        AsyncAgiConnectionHandler asyncAgiConnectionHandler = this.getConnectionHandler(managerConnection, renameEvent.getChannel());
        if (asyncAgiConnectionHandler == null) {
            return;
        }
        this.removeConnectionHandler(managerConnection, renameEvent.getChannel());
        this.setConnectionHandler(managerConnection, renameEvent.getNewname(), asyncAgiConnectionHandler);
        asyncAgiConnectionHandler.updateChannelName(renameEvent.getNewname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncAgiConnectionHandler getConnectionHandler(ManagerConnection managerConnection, String string) {
        Map<Integer, AsyncAgiConnectionHandler> map = this.connectionHandlers;
        synchronized (map) {
            return this.connectionHandlers.get(this.calculateHashKey(managerConnection, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnectionHandler(ManagerConnection managerConnection, String string, AsyncAgiConnectionHandler asyncAgiConnectionHandler) {
        Map<Integer, AsyncAgiConnectionHandler> map = this.connectionHandlers;
        synchronized (map) {
            this.connectionHandlers.put(this.calculateHashKey(managerConnection, string), asyncAgiConnectionHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnectionHandler(ManagerConnection managerConnection, String string) {
        Map<Integer, AsyncAgiConnectionHandler> map = this.connectionHandlers;
        synchronized (map) {
            this.connectionHandlers.remove(this.calculateHashKey(managerConnection, string));
            return;
        }
    }

    private Integer calculateHashKey(ManagerConnection managerConnection, String string) {
        return managerConnection.hashCode() * 31 + string.hashCode();
    }
}

