/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerPageBreaks
extends Layer {
    private static final long serialVersionUID = 5536725864099204670L;
    public final int DASH_LENGTH = 2;
    public final int GAP_LENGTH = 7;
    private boolean _paintLines = false;
    protected Color _color = Color.white;
    protected Dimension _pageSize = new Dimension(582, 717);

    public LayerPageBreaks() {
        super("PageBreaks");
    }

    public void setPageSize(Dimension dimension) {
        this._pageSize = dimension;
    }

    @Override
    public List<Fig> getContents() {
        return Collections.emptyList();
    }

    @Override
    public Fig presentationFor(Object object) {
        return null;
    }

    @Override
    public synchronized void paintContents(Graphics graphics) {
        if (graphics instanceof PrintGraphics) {
            return;
        }
        if (!this._paintLines) {
            return;
        }
        if (this._pageSize == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = rectangle.x / this._pageSize.width * this._pageSize.width - this._pageSize.width;
        int n3 = rectangle.y / this._pageSize.height * this._pageSize.height - this._pageSize.height;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        int n6 = (n5 - n3) / this._pageSize.height + 1;
        graphics.setColor(this._color);
        for (int i2 = (n4 - n2) / this._pageSize.width + 1; i2 > 0; --i2) {
            this.drawDashedLine(graphics, 0, n2 - 1, 0, n2 - 1, n5);
            n2 += this._pageSize.width;
        }
        while (n6 > 0) {
            this.drawDashedLine(graphics, 0, 0, n3 - 1, n4, n3 - 1);
            n3 += this._pageSize.height;
            --n6;
        }
    }

    protected int drawDashedLine(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n5 - n3) * (n5 - n3);
        int n8 = (n6 - n4) * (n6 - n4);
        int n9 = (int)Math.sqrt(n7 + n8);
        for (int i2 = n2; i2 < n9 - 2; i2 += 7) {
            int n10;
            n2 = n3 + (n5 - n3) * i2 / n9;
            n7 = n4 + (n6 - n4) * i2 / n9;
            if ((i2 += 2) >= n9) {
                n8 = n5;
                n10 = n6;
            } else {
                n8 = n3 + (n5 - n3) * i2 / n9;
                n10 = n4 + (n6 - n4) * i2 / n9;
            }
            graphics.drawLine(n2, n7, n8, n10);
        }
        return 0;
    }

    @Override
    public void adjust() {
        this._paintLines = !this._paintLines;
        this.refreshEditors();
    }
}

