/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeBroom;
import org.tigris.gef.base.ModeImpl;
import org.tigris.gef.base.ModeModify;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.Handle;

public class ModeSelect
extends FigModifyingModeImpl {
    private static final long serialVersionUID = 2412264848254549816L;
    private Point selectAnchor = new Point(0, 0);
    private Rectangle selectRect = new Rectangle(0, 0, 0, 0);
    private boolean showSelectRect = false;
    private boolean toggleSelection = false;
    private static Log LOG = LogFactory.getLog(ModeSelect.class);

    public ModeSelect(Editor editor) {
        super(editor);
    }

    public ModeSelect() {
    }

    @Override
    public boolean canExit() {
        return false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but rejected as already consumed");
            }
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x1E80) == 1536 || (mouseEvent.getModifiersEx() & 0x3C80) == 9216) {
            this.gotoBroomMode(mouseEvent);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed with alt key pressed");
            }
            return;
        }
        if (mouseEvent.getModifiers() == 4) {
            this.selectAnchor = new Point(mouseEvent.getX(), mouseEvent.getY());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed detected button 3 so setting anchor point");
            }
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.selectAnchor = new Point(n2, n3);
        this.selectRect.setBounds(n2, n3, 0, 0);
        this.toggleSelection = (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) && !mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown();
        SelectionManager selectionManager = this.editor.getSelectionManager();
        Rectangle rectangle = new Rectangle(n2 - 4, n3 - 4, 8, 8);
        Fig fig = this.editor.hit(this.selectAnchor);
        Object object = new Rectangle(n2 - 1, n3 - 1, 3, 3);
        if (fig instanceof FigGroup) {
            fig = ((FigGroup)fig).deepSelect((Rectangle)object);
        }
        if (fig == null && !selectionManager.hit(rectangle)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but rejected as no fig found");
            }
            return;
        }
        object = new Handle(-1);
        selectionManager.hitHandle(new Rectangle(n2 - 4, n3 - 4, 8, 8), (Handle)object);
        if (((Handle)object).index >= 0) {
            this.gotoModifyMode(mouseEvent);
            mouseEvent.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed with hit handle, going to Modify mode and consumed event");
            }
            return;
        }
        if (fig != null) {
            if (this.toggleSelection) {
                selectionManager.toggle(fig);
            } else if (!selectionManager.containsFig(fig)) {
                selectionManager.select(fig);
            }
        }
        if (selectionManager.hit(rectangle)) {
            this.gotoModifyMode(mouseEvent);
        }
        mouseEvent.consume();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MousePressed selection changed and consumed event");
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || mouseEvent.isAltDown() || mouseEvent.isMetaDown()) {
            return;
        }
        this.editor.translateMouseEvent(mouseEvent);
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.showSelectRect = true;
        int n4 = Math.min(this.selectAnchor.x, n2);
        int n5 = Math.min(this.selectAnchor.y, n3);
        int n6 = Math.max(this.selectAnchor.x, n2) - n4;
        int n7 = Math.max(this.selectAnchor.y, n3) - n5;
        double d2 = this.editor.getScale();
        this.scaleDamage(d2, this.selectRect);
        this.selectRect.setBounds(n4, n5, n6, n7);
        this.scaleDamage(d2, this.selectRect);
        this.editor.scrollToShow(n2, n3);
        mouseEvent.consume();
    }

    private void scaleDamage(double d2, Rectangle rectangle) {
        int n2 = (int)((double)rectangle.x * d2) - 1;
        int n3 = (int)((double)rectangle.y * d2) - 1;
        int n4 = (int)((double)(rectangle.width + 2) * d2) + 2;
        int n5 = (int)((double)(rectangle.height + 2) * d2) + 2;
        this.editor.damaged(n2, n3, n4, n5);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as already consumed");
            }
            return;
        }
        if (mouseEvent.isMetaDown()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as meta key down");
            }
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.showSelectRect = false;
        Vector<Fig> vector = new Vector<Fig>();
        Rectangle rectangle = new Rectangle(n2 - 4, n3 - 4, 8, 8);
        for (Fig fig : this.editor.getFigs()) {
            if (!fig.isSelectable() || (this.toggleSelection || !this.selectRect.isEmpty() || !fig.hit(rectangle)) && (this.selectRect.isEmpty() || !fig.within(this.selectRect))) continue;
            vector.addElement(fig);
        }
        if (!this.selectRect.isEmpty() && vector.isEmpty()) {
            for (Fig fig : this.editor.getFigs()) {
                if (!fig.isSelectable() || !fig.intersects(this.selectRect)) continue;
                vector.addElement(fig);
            }
        }
        if (this.toggleSelection) {
            this.editor.getSelectionManager().toggle(vector);
        } else {
            this.editor.getSelectionManager().select(vector);
        }
        this.selectRect.grow(1, 1);
        this.editor.scaleRect(this.selectRect);
        this.editor.damaged(this.selectRect);
        if (mouseEvent.getModifiers() == 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased button 3 detected so not consumed");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MouseReleased and consumed");
        }
        mouseEvent.consume();
    }

    @Override
    public String instructions() {
        return "  ";
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.showSelectRect) {
            Color color = Globals.getPrefs().getRubberbandColor();
            graphics.setColor(color);
            graphics.drawRect(this.selectRect.x, this.selectRect.y, this.selectRect.width, this.selectRect.height);
        }
    }

    protected void gotoModifyMode(MouseEvent mouseEvent) {
        ModeModify modeModify = new ModeModify(this.editor);
        this.editor.pushMode(modeModify);
        ((ModeImpl)modeModify).mousePressed(mouseEvent);
    }

    protected void gotoBroomMode(MouseEvent mouseEvent) {
        ModeBroom modeBroom = new ModeBroom(this.editor);
        this.editor.pushMode(modeBroom);
        ((ModeImpl)modeBroom).mousePressed(mouseEvent);
    }

    private boolean isMultiSelectTrigger(MouseEvent mouseEvent) {
        return mouseEvent.isControlDown() && !mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown();
    }
}

