/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;

class JGraphInternalPane
extends JPanel {
    private Editor _editor;
    private boolean registeredWithTooltip;
    static final long serialVersionUID = -5067026168452437942L;

    public JGraphInternalPane(Editor editor) {
        this._editor = editor;
        this.setLayout(null);
        this.setDoubleBuffered(false);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this._editor.paint(graphics);
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        if (graphics == null) {
            return graphics;
        }
        Serializable serializable = this.getParent();
        if (serializable instanceof JViewport) {
            serializable = (JViewport)serializable;
            Rectangle rectangle = serializable.getBounds();
            serializable = ((JViewport)serializable).getViewPosition();
            graphics.clipRect(rectangle.x + ((Point)serializable).x - 1, rectangle.y + ((Point)serializable).y - 1, rectangle.width + 1, rectangle.height + 1);
        }
        return graphics;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        mouseEvent = Globals.curEditor().retranslateMouseEvent(mouseEvent);
        return super.getToolTipLocation(mouseEvent);
    }

    @Override
    public void setToolTipText(String object) {
        if ("".equals(object)) {
            object = null;
        }
        this.putClientProperty("ToolTipText", object);
        object = ToolTipManager.sharedInstance();
        if (!this.registeredWithTooltip) {
            ((ToolTipManager)object).registerComponent(this);
            this.registeredWithTooltip = true;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.requestFocus();
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }
}

