/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.util.StringTokenizer;
import org.tigris.gef.util.Predicate;
import org.tigris.gef.util.PredicateEquals;
import org.tigris.gef.util.PredicateTrue;

public class PredicateStringMatch
implements Predicate {
    public static int MAX_PATS = 10;
    String[] _patterns;
    int _numPats;

    protected PredicateStringMatch(String[] stringArray, int n2) {
        this._patterns = stringArray;
        this._numPats = n2;
    }

    public static Predicate create(String string) {
        string = string.trim();
        String[] stringArray = new String[MAX_PATS];
        int n2 = 0;
        if (string.startsWith("*")) {
            ++n2;
            stringArray[0] = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            stringArray[n2++] = string2;
        }
        if (string.endsWith("*")) {
            stringArray[n2++] = "";
        }
        if (n2 == 0) {
            return PredicateTrue.theInstance();
        }
        if (n2 == 1) {
            return new PredicateEquals(stringArray[0]);
        }
        return new PredicateStringMatch(stringArray, n2);
    }

    @Override
    public boolean predicate(Object object) {
        if (object == null) {
            return false;
        }
        if (!((String)(object = object.toString())).startsWith(this._patterns[0])) {
            return false;
        }
        if (!((String)object).endsWith(this._patterns[this._numPats - 1])) {
            return false;
        }
        for (int i2 = 0; i2 < this._numPats; ++i2) {
            String string = this._patterns[i2];
            int n2 = ((String)object + "*").indexOf(string);
            if (n2 == -1) {
                return false;
            }
            object = ((String)object).substring(n2 + string.length());
        }
        return true;
    }
}

