/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.deversoft.odf.gearbox.common.ODFId;

public class ODFIdListV2DDD {
    private static final Logger log = LoggerFactory.getLogger(ODFIdListV2DDD.class);
    @NonNull
    List<ODFId> ids = new ArrayList<ODFId>();

    @JsonIgnore
    public void addItem(ODFId add) {
        this.ids.add(add);
    }

    @JsonIgnore
    public void addItemIfNotExists(ODFId add) {
        if (!this.ids.contains(add)) {
            this.addItem(add);
        }
    }

    @JsonIgnore
    public String[] getAsStringArray() {
        List<String> collect = this.getAsStringList();
        return collect.toArray(new String[0]);
    }

    @JsonIgnore
    public List<String> getAsStringList() {
        return this.ids.stream().map(ODFId::getUuidValue).collect(Collectors.toList());
    }

    @JsonIgnore
    public ODFIdListV2DDD sort() {
        Collections.sort(this.ids, new Comparator<ODFId>(){

            @Override
            public int compare(ODFId odfId, ODFId t1) {
                return odfId.getUuidValue().compareToIgnoreCase(t1.getUuidValue());
            }
        });
        return this;
    }

    public void clear() {
        this.ids.clear();
    }

    public void addFromList(List<ODFId> set) {
        for (ODFId id : set) {
            this.addItemIfNotExists(id);
        }
    }

    public void addFromSet(Set<ODFId> set) {
        for (ODFId id : set) {
            this.addItemIfNotExists(id);
        }
    }

    @NonNull
    public List<ODFId> getIds() {
        return this.ids;
    }

    public ODFIdListV2DDD setIds(@NonNull List<ODFId> ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        this.ids = ids;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODFIdListV2DDD)) {
            return false;
        }
        ODFIdListV2DDD other = (ODFIdListV2DDD)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ODFIdListV2DDD;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public ODFIdListV2DDD() {
    }

    public ODFIdListV2DDD(@NonNull List<ODFId> ids) {
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        this.ids = ids;
    }

    public String toString() {
        return "ODFIdListV2DDD(ids=" + this.getIds() + ")";
    }
}

