/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain.promotion;

import java.time.LocalDateTime;
import java.util.HashMap;
import ro.deversoft.odf.gearbox.common.CommonUtils;
import ro.deversoft.odf.gearbox.common.ODFId;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventDDD;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventFilters;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventOperationType;
import ro.deversoft.odf.gearbox.common.domain.globalevents.GlobalEventTopic;

public class PromotionBudgetEventDDD {
    ODFId venueId;
    ODFId userDataId;
    double value;
    String description;
    boolean isSettlement;
    LocalDateTime addedAt;

    public GlobalEventDDD toGlobalEvent() {
        PromotionBudgetEventDDD ddd = this;
        GlobalEventFilters filters = GlobalEventFilters.builder().setVenueid(ddd.getVenueId().getUuidValue()).setUserdataid(ddd.getUserDataId().getUuidValue()).build();
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("value", ddd.getValue());
        payloadMap.put("description", ddd.getDescription());
        return GlobalEventDDD.builder().setOperationType(ddd.getIsSettlement() ? GlobalEventOperationType.SETTLEMENT : GlobalEventOperationType.ALTERATION).setTopic(GlobalEventTopic.USER_PROMOTION_BUGDET).setVenueId(ddd.getVenueId()).setFilters(filters).setPayload(CommonUtils.getJsonNodeFromMap(payloadMap)).build();
    }

    public static PromotionBudgetEventDDDBuilder builder() {
        return new PromotionBudgetEventDDDBuilder();
    }

    public ODFId getVenueId() {
        return this.venueId;
    }

    public ODFId getUserDataId() {
        return this.userDataId;
    }

    public double getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getIsSettlement() {
        return this.isSettlement;
    }

    public LocalDateTime getAddedAt() {
        return this.addedAt;
    }

    public PromotionBudgetEventDDD setVenueId(ODFId venueId) {
        this.venueId = venueId;
        return this;
    }

    public PromotionBudgetEventDDD setUserDataId(ODFId userDataId) {
        this.userDataId = userDataId;
        return this;
    }

    public PromotionBudgetEventDDD setValue(double value) {
        this.value = value;
        return this;
    }

    public PromotionBudgetEventDDD setDescription(String description) {
        this.description = description;
        return this;
    }

    public PromotionBudgetEventDDD setIsSettlement(boolean isSettlement) {
        this.isSettlement = isSettlement;
        return this;
    }

    public PromotionBudgetEventDDD setAddedAt(LocalDateTime addedAt) {
        this.addedAt = addedAt;
        return this;
    }

    public PromotionBudgetEventDDD() {
    }

    public PromotionBudgetEventDDD(ODFId venueId, ODFId userDataId, double value, String description, boolean isSettlement, LocalDateTime addedAt) {
        this.venueId = venueId;
        this.userDataId = userDataId;
        this.value = value;
        this.description = description;
        this.isSettlement = isSettlement;
        this.addedAt = addedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromotionBudgetEventDDD)) {
            return false;
        }
        PromotionBudgetEventDDD other = (PromotionBudgetEventDDD)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PromotionBudgetEventDDD;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "PromotionBudgetEventDDD(super=" + super.toString() + ", venueId=" + this.getVenueId() + ", userDataId=" + this.getUserDataId() + ", value=" + this.getValue() + ", description=" + this.getDescription() + ", isSettlement=" + this.getIsSettlement() + ", addedAt=" + this.getAddedAt() + ")";
    }

    public static class PromotionBudgetEventDDDBuilder {
        private ODFId venueId;
        private ODFId userDataId;
        private double value;
        private String description;
        private boolean isSettlement;
        private LocalDateTime addedAt;

        PromotionBudgetEventDDDBuilder() {
        }

        public PromotionBudgetEventDDDBuilder setVenueId(ODFId venueId) {
            this.venueId = venueId;
            return this;
        }

        public PromotionBudgetEventDDDBuilder setUserDataId(ODFId userDataId) {
            this.userDataId = userDataId;
            return this;
        }

        public PromotionBudgetEventDDDBuilder setValue(double value) {
            this.value = value;
            return this;
        }

        public PromotionBudgetEventDDDBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public PromotionBudgetEventDDDBuilder setIsSettlement(boolean isSettlement) {
            this.isSettlement = isSettlement;
            return this;
        }

        public PromotionBudgetEventDDDBuilder setAddedAt(LocalDateTime addedAt) {
            this.addedAt = addedAt;
            return this;
        }

        public PromotionBudgetEventDDD build() {
            return new PromotionBudgetEventDDD(this.venueId, this.userDataId, this.value, this.description, this.isSettlement, this.addedAt);
        }

        public String toString() {
            return "PromotionBudgetEventDDD.PromotionBudgetEventDDDBuilder(venueId=" + this.venueId + ", userDataId=" + this.userDataId + ", value=" + this.value + ", description=" + this.description + ", isSettlement=" + this.isSettlement + ", addedAt=" + this.addedAt + ")";
        }
    }
}

