/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.enums;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import ro.deversoft.odf.gearbox.common.exception.ODFRuntimeException;

public final class EnumsRegistry {
    static final String ENUM_TO_VALUE_SEPARATOR = "::";
    private static final String ENUM_CLASS_ALREADY_REGISTERED = "The enumClass <%s> has already been registered";
    private static final String ENUM_CLASS_REGISTERED = "The enumClass <%s> has been registered !!";
    private static final String ENUM_CLASSIFIER_NOT_REGISTERED = "The enum classifier <%s> has not been registered [correctly]";
    private static final String ENUM_CLASSIFIER__REGISTERED = "The enum classifier <%s> has been registered [correctly] !!";
    private static Map<Class<? extends Enum<?>>, Enum<?>[]> enumsClassesRegistry = new HashMap();
    private static Map<String, Enum<?>> enumsValuesRegistryByClassifier = new HashMap();
    @Deprecated
    private static final String ENUM_NOT_REGISTERED = "The enum class <%s> has not been registered [correctly]";
    @Deprecated
    private static final String ENUM_VALUE_NOT_REGISTERED = "The enum value <%s> for enum <%s> has not been registered [correctly]";
    @Deprecated
    private static Map<String, Map<String, Enum<?>>> enumsValuesRegistryByClassName = new HashMap();

    public static synchronized <E extends Enum<E>> void registerEnum(@NonNull Class<E> enumClass) {
        if (enumClass == null) {
            throw new NullPointerException("enumClass is marked non-null but is null");
        }
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        if (enumsClassesRegistry.containsKey(enumClass)) {
            throw new ODFRuntimeException(String.format(ENUM_CLASS_ALREADY_REGISTERED, enumClass));
        }
        enumsClassesRegistry.put(enumClass, enumValues);
        System.out.println(String.format(ENUM_CLASS_REGISTERED, enumClass));
        for (Enum enumValue : enumValues) {
            enumsValuesRegistryByClassifier.put(EnumsRegistry.enumValueToClassifier(enumValue), enumValue);
            System.out.println(String.format(ENUM_CLASSIFIER__REGISTERED, enumValue));
        }
    }

    public static String enumValueToClassifier(@NonNull Enum<?> enumValue) {
        if (enumValue == null) {
            throw new NullPointerException("enumValue is marked non-null but is null");
        }
        return enumValue.getClass().getName() + ENUM_TO_VALUE_SEPARATOR + enumValue.name();
    }

    public static Enum<?> getEnumMemberByClassifier(@NonNull String enumValueClassifier) {
        if (enumValueClassifier == null) {
            throw new NullPointerException("enumValueClassifier is marked non-null but is null");
        }
        Enum<?> enumVal = enumsValuesRegistryByClassifier.get(enumValueClassifier);
        if (enumVal == null) {
            throw new ODFRuntimeException(String.format(ENUM_CLASSIFIER_NOT_REGISTERED, enumValueClassifier));
        }
        return enumVal;
    }

    static void clearRegistry() {
        enumsClassesRegistry.clear();
        enumsValuesRegistryByClassifier.clear();
    }

    @Deprecated
    public static Enum<?> getEnumMemberByValue(@NonNull String enumClassName, @NonNull String enumValueName) {
        if (enumClassName == null) {
            throw new NullPointerException("enumClassName is marked non-null but is null");
        }
        if (enumValueName == null) {
            throw new NullPointerException("enumValueName is marked non-null but is null");
        }
        Map<String, Enum<?>> valuesForEnum = enumsValuesRegistryByClassName.get(enumClassName);
        if (valuesForEnum == null) {
            throw new ODFRuntimeException(String.format(ENUM_NOT_REGISTERED, enumClassName));
        }
        Enum<?> enumValue = valuesForEnum.get(enumValueName);
        if (enumValue == null) {
            throw new ODFRuntimeException(String.format(ENUM_VALUE_NOT_REGISTERED, enumValueName, enumClassName));
        }
        return enumValue;
    }

    @Deprecated
    public static Enum<?> classsifierToEnumValue(String enumClassAndValue) {
        int indexOfSeparator = enumClassAndValue.indexOf(ENUM_TO_VALUE_SEPARATOR);
        String enumClassName = enumClassAndValue.substring(0, indexOfSeparator);
        String enumValueName = enumClassAndValue.substring(indexOfSeparator + ENUM_TO_VALUE_SEPARATOR.length());
        return EnumsRegistry.getEnumMemberByValue(enumClassName, enumValueName);
    }

    private EnumsRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

