/*
 * Decompiled with CFR 0.152.
 */
package com4j;

import com4j.COM4J;
import com4j.Com4jObject;
import com4j.ComObjectListener;
import com4j.ExecutionException;
import com4j.LiveObjectCollection;
import com4j.Native;
import com4j.Task;
import com4j.Win32Lock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ComThread
extends Thread {
    private static final ThreadLocal<ComThread> map = new ThreadLocal<ComThread>(){

        @Override
        public ComThread initialValue() {
            if (ComThread.isComThread()) {
                return (ComThread)Thread.currentThread();
            }
            return new ComThread(Thread.currentThread());
        }
    };
    private final Thread peer;
    private Task<?> taskListHead;
    private Task<?> taskListTail;
    private LiveObjectCollection liveObjects = new LiveObjectCollection();
    private final List<ComObjectListener> listeners = new ArrayList<ComObjectListener>();
    private volatile boolean die = false;
    private final Win32Lock lock = new Win32Lock();
    static final Set<ComThread> threads = Collections.synchronizedSet(new HashSet());

    static ComThread get() {
        return map.get();
    }

    static void detach() {
        map.get().kill();
        try {
            map.get().join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        map.remove();
    }

    private ComThread(Thread peer) {
        super("ComThread for " + peer.getName());
        this.peer = peer;
        this.setDaemon(true);
        this.start();
    }

    private boolean canExit() {
        return this.die || !this.peer.isAlive() && this.liveObjects.isEmpty();
    }

    public void kill() {
        this.die = true;
        this.lock.activate();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set<ComThread> set = threads;
        synchronized (set) {
            threads.add(this);
        }
        try {
            this.run0();
        }
        finally {
            set = threads;
            synchronized (set) {
                threads.remove(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run0() {
        Native.coInitialize();
        while (!this.canExit()) {
            this.lock.suspend();
            ComThread comThread = this;
            synchronized (comThread) {
                while (this.taskListHead != null) {
                    Task<?> task = this.taskListHead;
                    this.taskListHead = task.next;
                    task.invoke();
                }
                this.taskListTail = null;
            }
        }
        for (WeakReference<Com4jObject> object : this.liveObjects.getSnapshot()) {
            Com4jObject liveObject = (Com4jObject)object.get();
            if (liveObject == null) continue;
            liveObject.dispose();
        }
        Native.coUninitialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(Task<T> task) {
        Task<T> task2 = task;
        synchronized (task2) {
            ComThread comThread = this;
            synchronized (comThread) {
                if (this.taskListTail != null) {
                    this.taskListTail.next = task;
                }
                this.taskListTail = task;
                if (this.taskListHead == null) {
                    this.taskListHead = task;
                }
            }
            this.lock.activate();
            try {
                task.wait();
            }
            catch (InterruptedException e) {
                task.exception = e;
            }
            if (task.exception != null) {
                Throwable e = task.exception;
                task.exception = null;
                throw new ExecutionException(e);
            }
            Object r = task.result;
            task.result = null;
            return r;
        }
    }

    public synchronized void addLiveObject(Com4jObject r) {
        this.liveObjects.add(r);
        if (!this.listeners.isEmpty()) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).onNewObject(r);
            }
        }
    }

    synchronized void removeLiveObject(Com4jObject object) {
        this.liveObjects.remove(object);
    }

    static boolean isComThread() {
        return Thread.currentThread() instanceof ComThread;
    }

    public void addListener(ComObjectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("can't register the same listener twice");
        }
        this.listeners.add(listener);
    }

    public void removeListener(ComObjectListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("listener isn't registered");
        }
    }

    public static void flushFreeList() {
        System.gc();
        new DummyTask().execute();
    }

    static {
        COM4J.addCom4JShutdownTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ComThread[] threadsSnapshot;
                Set<ComThread> set = threads;
                synchronized (set) {
                    threadsSnapshot = threads.toArray(new ComThread[threads.size()]);
                }
                for (ComThread thread : threadsSnapshot) {
                    thread.kill();
                }
            }
        });
    }

    private static class DummyTask
    extends Task<Void> {
        private DummyTask() {
        }

        @Override
        public Void call() {
            return null;
        }
    }
}

