/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.layouts;

import com.shfarr.ui.layouts.AbstractLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.Hashtable;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class QueueLayout
extends AbstractLayout {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 100;
    public static final int STRECH_COMPONENTS = 2;
    public static final int CENTER_COMPONENTS = 3;
    public static final int FLOAT_COMPONENTS = 4;
    public static final int SINK_COMPONENTS = 5;
    public static final Integer BEGIN = new Integer(0);
    public static final Integer END = new Integer(1);
    protected int gap = 0;
    protected int orientation = 0;
    protected boolean showingAll = true;
    protected int alignment = 3;
    protected Hashtable popupHash = null;

    public QueueLayout() {
        this(0);
    }

    public QueueLayout(int gap) {
        this(gap, 0, 3);
    }

    public QueueLayout(int gap, int orientation, int alignment) {
        this.setGap(gap);
        this.setOrientation(orientation);
        this.popupHash = new Hashtable();
        this.alignment = alignment;
    }

    protected Object getDefaultConstraints() {
        return BEGIN;
    }

    public int getGap() {
        return this.gap;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isShowingAll() {
        return this.showingAll;
    }

    protected void performLayout(Container parent) {
        Component[] cps = parent.getComponents();
        Insets ins = parent.getInsets();
        Dimension cPrefSize = null;
        Dimension pSize = parent.getSize();
        int offset = 0;
        int startOffset = this.orientation == 0 ? ins.top : ins.left;
        int availSpace = this.orientation == 0 ? pSize.height - ins.bottom - ins.top : pSize.width - ins.right - ins.left;
        int endOffset = startOffset + availSpace + this.getGap();
        int mobileVal = 0;
        int i = 0;
        while (i < cps.length) {
            if (cps[i].isVisible()) {
                cPrefSize = cps[i].getPreferredSize() != null ? cps[i].getPreferredSize() : new Dimension(20, 20);
                int n = mobileVal = this.orientation == 0 ? cPrefSize.height : cPrefSize.width;
                if (BEGIN.equals(this.getConstraintsFor(cps[i]))) {
                    offset = startOffset;
                    startOffset += mobileVal + this.getGap();
                } else {
                    offset = endOffset -= mobileVal + this.getGap();
                }
                int x = ins.left + (pSize.width - ins.left - ins.right - cPrefSize.width) / 2;
                int y = ins.top + (pSize.height - ins.top - ins.bottom - cPrefSize.height) / 2;
                int w = cPrefSize.width;
                int h = cPrefSize.height;
                if (this.alignment == 2) {
                    x = ins.left;
                    y = ins.top;
                    w = pSize.width - ins.right - ins.left;
                    h = pSize.height - ins.top - ins.bottom;
                } else if (this.alignment == 5) {
                    x = ins.left + parent.getWidth() - ins.right - cPrefSize.width;
                    y = ins.top + parent.getHeight() - ins.bottom - cPrefSize.height;
                } else if (this.alignment == 4) {
                    x = ins.left;
                    y = ins.top;
                }
                if (cps[i] instanceof JSeparator) {
                    x = ins.left + 2;
                    y = ins.top + 2;
                    w = pSize.width - ins.right - ins.left - 4;
                    h = pSize.height - ins.top - ins.bottom - 4;
                }
                if (this.orientation == 0) {
                    cps[i].setBounds(x, offset, w, mobileVal);
                } else {
                    cps[i].setBounds(offset, y, mobileVal, h);
                }
                availSpace -= this.getGap() + mobileVal;
            }
            ++i;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets ins = parent.getInsets() != null ? parent.getInsets() : new Insets(0, 0, 0, 0);
        int pw = 0;
        int ph = 0;
        Component[] cps = parent.getComponents();
        int cpCount = 0;
        int i = 0;
        while (i < cps.length) {
            if (cps[i].isVisible()) {
                if (this.orientation == 0) {
                    pw = Math.max(cps[i].getPreferredSize().width, pw);
                    ph += cps[i].getPreferredSize().height + (cpCount != 0 ? this.getGap() : 0);
                } else {
                    ph = Math.max(cps[i].getPreferredSize().height, ph);
                    pw += cps[i].getPreferredSize().width + (cpCount != 0 ? this.getGap() : 0);
                }
                ++cpCount;
            }
            ++i;
        }
        return new Dimension(pw + ins.left + ins.right, ph + ins.top + ins.bottom);
    }

    public void setGap(int newGap) {
        this.gap = newGap;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    protected void showPopup(Container src) {
        JPopupMenu popup = (JPopupMenu)this.popupHash.get(src);
        Point point = null;
        JRootPane rp = SwingUtilities.getRootPane(src);
        point = this.getOrientation() == 100 ? new Point(src.getSize().width - popup.getPreferredSize().width - 1, rp.getSize().height > src.getLocation().y + popup.getPreferredSize().height ? src.getSize().height - 1 : -popup.getPreferredSize().height) : new Point(rp.getSize().width > src.getLocation().x + popup.getPreferredSize().width ? src.getSize().width - 1 : -popup.getPreferredSize().width, src.getSize().height - popup.getPreferredSize().height - 1);
        point = SwingUtilities.convertPoint(src, point, rp);
        popup.show(rp, point.x, point.y);
    }
}

