/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme.edit;

import com.shfarr.ui.layouts.QueueLayout;
import com.shfarr.ui.plaf.fh.theme.edit.ThemeEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GeneralEditor
extends JPanel
implements ActionListener,
ChangeListener {
    private JComboBox generalCombo = null;
    private JPanel editor = null;
    private JLabel sampleLabel = null;
    private JPanel sidePanel = null;
    private JCheckBox italicCheckBox = null;
    private JCheckBox boldCheckBox = null;
    private JPanel centerPanel = null;
    private JComboBox namesCombo = null;
    private JSpinner sizeSpinner = null;
    private JComboBox colorsCombo = null;

    public GeneralEditor() {
        super(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 4, 4, 0));
        this.add((Component)this.getSidePanel(), "East");
        this.add((Component)this.getCenterPanel(), "Center");
    }

    protected JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new BorderLayout(4, 4));
            this.centerPanel.setBorder(new EmptyBorder(0, 0, 0, 4));
            JPanel aPanel = new JPanel(new QueueLayout(4, 100, 2));
            aPanel.add(new JLabel("   Mapping key"));
            aPanel.add(this.getNamesCombo());
            this.centerPanel.add((Component)aPanel, "North");
            this.centerPanel.add((Component)this.getEditor(), "Center");
        }
        return this.centerPanel;
    }

    protected JCheckBox getBoldCheckBox() {
        if (this.boldCheckBox == null) {
            this.boldCheckBox = new JCheckBox("Bold");
            this.boldCheckBox.addActionListener(this);
        }
        return this.boldCheckBox;
    }

    protected JCheckBox getItalicCheckBox() {
        if (this.italicCheckBox == null) {
            this.italicCheckBox = new JCheckBox("Italic");
            this.italicCheckBox.addActionListener(this);
        }
        return this.italicCheckBox;
    }

    protected JComboBox getColorsCombo() {
        if (this.colorsCombo == null) {
            this.colorsCombo = new JComboBox();
            int i = -10;
            while (i < 21) {
                this.colorsCombo.addItem("" + i);
                ++i;
            }
            Iterator i2 = ThemeEditor.instance().getEditedTheme().colorPalette().keySet().iterator();
            while (i2.hasNext()) {
                this.colorsCombo.addItem(i2.next());
            }
            this.colorsCombo.addActionListener(this);
        }
        return this.colorsCombo;
    }

    protected JComboBox getNamesCombo() {
        if (this.namesCombo == null) {
            this.namesCombo = new JComboBox();
            Iterator i = ThemeEditor.instance().getEditedTheme().metaPalette().keySet().iterator();
            while (i.hasNext()) {
                this.namesCombo.addItem(i.next());
            }
            this.namesCombo.setSelectedIndex(0);
            this.namesCombo.addActionListener(this);
            this.updateEditor();
        }
        return this.namesCombo;
    }

    protected JSpinner getSizeSpinner() {
        if (this.sizeSpinner == null) {
            this.sizeSpinner = new JSpinner(new SpinnerNumberModel(0, -10000, 10000, 1));
            this.sizeSpinner.addChangeListener(this);
        }
        return this.sizeSpinner;
    }

    protected JPanel getEditor() {
        if (this.editor == null) {
            this.editor = new JPanel(new QueueLayout(4, 0, 2));
        }
        return this.editor;
    }

    protected JPanel getSidePanel() {
        if (this.sidePanel == null) {
            this.sidePanel = new JPanel(new QueueLayout(4, 0, 2));
            this.sidePanel.setBorder(new EmptyBorder(0, 4, 4, 4));
            JButton save = new JButton("Save");
            save.addActionListener(this);
            JButton revert = new JButton("Revert");
            revert.addActionListener(this);
            this.sidePanel.add(save);
            this.sidePanel.add(revert);
        }
        return this.sidePanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Save")) {
            ThemeEditor.instance().getEditedTheme().saveMeta();
        } else if (e.getActionCommand().equals("Revert")) {
            ThemeEditor.instance().getEditedTheme().loadMeta();
            this.updateEditor();
        } else if (e.getSource() == this.getNamesCombo()) {
            this.updateEditor();
        } else if (e.getSource() == this.getColorsCombo()) {
            ThemeEditor.instance().getEditedTheme().metaPalette().put(this.getNamesCombo().getSelectedItem(), this.getColorsCombo().getSelectedItem());
        } else if (e.getSource() instanceof JCheckBox) {
            ThemeEditor.instance().getEditedTheme().metaPalette().put(this.getNamesCombo().getSelectedItem(), new Boolean(((JCheckBox)e.getSource()).isSelected()));
        }
    }

    public void stateChanged(ChangeEvent e) {
        ThemeEditor.instance().getEditedTheme().metaPalette().put(this.getNamesCombo().getSelectedItem(), this.getSizeSpinner().getValue());
    }

    protected void updateEditor() {
        this.getEditor().removeAll();
        String key = (String)this.getNamesCombo().getSelectedItem();
        Object val = ThemeEditor.instance().getEditedTheme().metaPalette().get(key);
        JPanel p = new JPanel(new QueueLayout(4, 100, 2));
        JComponent c = null;
        if (val instanceof String) {
            if (key.toLowerCase().indexOf("background") != -1 || key.toLowerCase().indexOf("foreground") != -1 || key.toLowerCase().indexOf("highlight") != -1 || key.toLowerCase().indexOf("shadow") != -1) {
                c = this.getColorsCombo();
                this.getColorsCombo().setSelectedItem(val);
            } else {
                final JTextField field = new JTextField((String)val);
                field.addKeyListener(new KeyAdapter(){

                    public void keyTyped(KeyEvent e) {
                        ThemeEditor.instance().getEditedTheme().metaPalette().put(GeneralEditor.this.getNamesCombo().getSelectedItem(), field.getText());
                    }
                });
                c = field;
            }
            c.setPreferredSize(new Dimension(Math.max(c.getPreferredSize().width, this.getNamesCombo().getPreferredSize().width), c.getPreferredSize().height));
        } else if (val instanceof Number) {
            c = this.getSizeSpinner();
            this.getSizeSpinner().setValue((Number)val);
            c.setPreferredSize(new Dimension(Math.max(c.getPreferredSize().width, 70), c.getPreferredSize().height));
        } else if (val instanceof Boolean) {
            c = new JCheckBox("", Boolean.TRUE.equals(val));
            ((JCheckBox)c).addActionListener(this);
            c.setPreferredSize(new Dimension(Math.max(c.getPreferredSize().width, this.getNamesCombo().getPreferredSize().width), c.getPreferredSize().height));
        }
        p.add(new JLabel("Mapping value"));
        p.add(c);
        this.getEditor().add(p);
        if (this.getEditor().getParent() != null) {
            ((JComponent)this.getEditor().getParent()).invalidate();
            ((JComponent)this.getEditor().getParent()).validate();
            ((JComponent)this.getEditor().getParent()).repaint();
        }
    }
}

