/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.integrations.erp.soft1.nextitsol.vatra.dto;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;

public class Utils {
    public static Object loadFromJsonFile(String filename, Type c, String forcedDateFormat) throws IOException {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        if (forcedDateFormat != null) {
            builder.setDateFormat(forcedDateFormat);
        }
        Gson gson = builder.create();
        Object config = gson.fromJson((Reader)new FileReader(filename), c);
        return config;
    }

    public static Object loadFromJsonString(String text, Type c, String forcedDateFormat) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        if (forcedDateFormat != null) {
            builder.setDateFormat(forcedDateFormat);
        }
        Gson gson = builder.create();
        Object config = gson.fromJson(text, c);
        return config;
    }

    public static Object loadFromJsonString(String text, Class c, String forcedDateFormat) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        if (forcedDateFormat != null) {
            builder.setDateFormat(forcedDateFormat);
        }
        Gson gson = builder.create();
        Object config = gson.fromJson(text, c);
        return config;
    }

    public static String getJsonForObject(Object o, String forcedDateFormat) {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        if (forcedDateFormat != null) {
            builder.setDateFormat(forcedDateFormat);
        }
        Gson gson = builder.create();
        String txt = gson.toJson(o);
        return txt;
    }

    public static boolean postJsonObjectAsApplicationJson(Object jsonCommand, String address, String dateFormat, Map<String, String> requestProperties, StringBuffer resultSB, Long connectTimeoutInMillis, String responseCharset) throws MalformedURLException, IOException {
        String result;
        int responseCode;
        URL url = new URL(address);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        if (connectTimeoutInMillis != null) {
            con.setConnectTimeout((int)connectTimeoutInMillis.longValue());
        }
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        for (String key : requestProperties.keySet()) {
            if (key == null) continue;
            con.setRequestProperty(key, requestProperties.get(key));
        }
        con.setDoOutput(true);
        Gson gson = new GsonBuilder().setDateFormat(dateFormat).disableHtmlEscaping().create();
        if (jsonCommand != null) {
            OutputStream outputStream;
            String value = gson.toJson(jsonCommand);
            System.out.println("Sending : " + value);
            try (OutputStream os = outputStream = con.getOutputStream();){
                byte[] input = value.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            outputStream.flush();
            outputStream.close();
        }
        if ((responseCode = con.getResponseCode()) == 200) {
            result = Utils.buildStringFromInputStream(con.getInputStream(), responseCharset);
            resultSB.append(result);
            System.out.println("SEND OK " + responseCode + " " + responseCode + " result :" + resultSB);
            return true;
        }
        try {
            result = Utils.buildStringFromInputStream(con.getErrorStream(), responseCharset);
            resultSB.append(result);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("SEND ERR " + responseCode + " " + responseCode + " result :" + resultSB);
        return false;
    }

    public static String getHttpPage(String fullAddress, Map<String, String> requestProperties, Map<String, String> responseHeaders, String expectedCharset) {
        return Utils.getHttpPage(fullAddress, requestProperties, responseHeaders, "GET", expectedCharset);
    }

    public static String getHttpPage(String fullAddress, Map<String, String> requestProperties, Map<String, String> responseHeaders, String requestMethod, String expectedCharset) {
        try {
            URL url = new URL(fullAddress);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setConnectTimeout(55000);
            huc.setRequestMethod(requestMethod);
            if (requestProperties != null) {
                for (String key : requestProperties.keySet()) {
                    huc.setRequestProperty(key, requestProperties.get(key));
                }
            }
            huc.connect();
            InputStream in = huc.getInputStream();
            Utils.extractResponseHeaderFields(responseHeaders, huc);
            return Utils.buildStringFromInputStream(in, expectedCharset);
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void extractResponseHeaderFields(Map<String, String> responseHeaders, HttpURLConnection huc) {
        Map<String, List<String>> headerFields = huc.getHeaderFields();
        for (String key : headerFields.keySet()) {
            List<String> strings;
            if (key == null || (strings = headerFields.get(key)) == null || strings.size() <= 0) continue;
            responseHeaders.put(key, strings.get(0));
        }
    }

    public static String buildStringFromInputStreamNpoGZIP(InputStream in) throws IOException {
        StringBuffer result = new StringBuffer();
        BufferedInputStream bufIn = new BufferedInputStream(in);
        int SIZE = 65535;
        byte[] buffer = new byte[SIZE];
        boolean stop = false;
        while (!stop) {
            int charsRead = bufIn.read(buffer);
            if (charsRead > 0) {
                String s = new String(buffer, 0, charsRead);
                result.append(s);
                continue;
            }
            stop = true;
        }
        return result.toString();
    }

    public static String buildStringFromInputStream(InputStream in, String charset) throws IOException {
        InputStream in1;
        StringBuffer result;
        block5: {
            result = new StringBuffer();
            in1 = in;
            try {
                if (in1.markSupported()) {
                    in1.mark(100000);
                }
                in1 = new GZIPInputStream(in);
            }
            catch (ZipException e) {
                System.err.println("NOT A GZIP STREAM, Using plain stream");
                if (!in1.markSupported()) break block5;
                in1.reset();
            }
        }
        BufferedInputStream bufIn = new BufferedInputStream(in1);
        int SIZE = 65535;
        byte[] buffer = new byte[SIZE];
        boolean stop = false;
        while (!stop) {
            int charsRead = bufIn.read(buffer);
            if (charsRead > 0) {
                String s = new String(buffer, 0, charsRead, charset);
                result.append(s);
                continue;
            }
            stop = true;
        }
        return result.toString();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static String toStringIterable(Iterable collection) {
        String separator = ", ";
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Object o : collection) {
            sb.append(o.toString() + separator);
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - separator.length());
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toStringMap(Map map) {
        String separator = ", ";
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (Object key : map.keySet()) {
            sb.append("\"" + key + "\":\"" + map.get(key) + "\"" + separator);
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - separator.length());
        }
        sb.append("}");
        return sb.toString();
    }
}

